/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.widget;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.intermine.web.logic.widget.config.GraphWidgetConfig;
import org.intermine.web.logic.widget.config.WidgetConfig;
import org.intermine.webservice.server.widget.WidgetProcessor;
import org.intermine.webservice.server.widget.WidgetProcessorImpl;

public final class XMLWidgetProcessor
extends WidgetProcessorImpl {
    private static final WidgetProcessor INSTANCE = new XMLWidgetProcessor();

    private XMLWidgetProcessor() {
    }

    public static WidgetProcessor instance() {
        return INSTANCE;
    }

    public List<String> process(String name, WidgetConfig widgetConfig) {
        StringBuilder sb = new StringBuilder("<widget>");
        sb.append(this.formatCell("name", (Object)name));
        sb.append(this.formatCell("title", (Object)widgetConfig.getTitle()));
        sb.append(this.formatCell("description", (Object)widgetConfig.getDescription()));
        WidgetProcessorImpl.WidgetType widgetType = this.getWidgetType(widgetConfig);
        sb.append(this.formatCell("widgetType", (Object)widgetType.name().toLowerCase()));
        if (widgetType == WidgetProcessorImpl.WidgetType.CHART) {
            sb.append(this.formatCell("chartType", (Object)((GraphWidgetConfig)widgetConfig).getGraphType()));
            sb.append(this.formatCell("labels", (Object)this.getLabels((GraphWidgetConfig)widgetConfig)));
        }
        sb.append(this.formatCell("target", (Object)this.getClasses(widgetConfig.getTypeClass())));
        sb.append(this.formatCell("filter", (Object)widgetConfig.getFilters()));
        sb.append("</widget>");
        return new LinkedList<String>(Arrays.asList(sb.toString()));
    }

    private String formatCell(String name, Object contents) {
        StringBuffer sb = new StringBuffer();
        if (contents instanceof Collection) {
            for (Object o : (Collection)contents) {
                sb.append(this.formatCell(name, o));
            }
        } else {
            sb.append("<" + name + ">");
            if (contents instanceof Map) {
                for (Object k : ((Map)contents).keySet()) {
                    sb.append(this.formatCell(k.toString(), ((Map)contents).get(k)));
                }
            } else {
                sb.append(StringEscapeUtils.escapeXml((String)contents.toString()));
            }
            sb.append("</" + name + ">");
        }
        return sb.toString();
    }

    private List<String> getClasses(String tc) {
        LinkedList<String> ret = new LinkedList<String>();
        for (String s : StringUtils.split((String)tc, (String)",")) {
            ret.add(s.substring(s.lastIndexOf(46) + 1));
        }
        return ret;
    }
}

