<%@ page contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/WEB-INF/struts-html.tld" prefix="html" %>
<%@ taglib uri="/WEB-INF/struts-tiles.tld" prefix="tiles" %>
<%@ taglib tagdir="/WEB-INF/tags" prefix="im"%>

<html:xhtml/>

<!-- apiJava.jsp -->
<c:set var="wiki" value="${WEB_PROPERTIES['api.help']}"/>

<im:boxarea titleKey="api.java.titleKey" stylename="gradientbox" fixedWidth="90%" htmlId="apiJava">
  <form id="apiJavaForm" action="fileDownload.do" method="post">
    <input type="hidden" value="${path}" name="path" />
    <input type="hidden" value="${fileName}" name="fileName" />
    <input type="hidden" value="${mimeType}" name="mimeType" />
    <input type="hidden" value="${mimeExtension}" name="mimeExtension" />
  </form>
<div>
  The Java web service client library makes it easy to run queries in <c:out value="${WEB_PROPERTIES['project.title']}"/> directly from Java programs.
  You can use this libray to construct any query you could run from web interface and fetch the results
  in as either tables of values, or JSON data structures.
  <br/>
  Like all our code, these client libraries are open-source, licensed under the LGPL. For information
  on the API visit our <a href="${wiki}">wiki pages</a>, and for Javadoc please visit the
  <a href="http://intermine.org/intermine-ws-java/javadoc/">API documentation</a>.
</div>
<br>
<div>
  <ul>
    <li>
      <div onclick="javascript:showText('prerequisite')"><h3 style="font-weight: bold;">Get the library</h3></div>
      <div id="prerequisite" style="padding: 5px">
        <p>Maven

        <pre>
            &lt;!-- https://bintray.com/intermineorg/java-client--&gt;
            &lt;dependency&gt;
                &lt;groupId&gt;org.intermine&lt;/groupId&gt;
                &lt;artifactId&gt;intermine-ws-java&lt;/artifactId&gt;
                &lt;version&gt;3.0.+&lt;/version&gt;
            &lt;/dependency&gt;
        </pre>
        </p>
        <p>
        Gradle
        <br>
        <pre>compile 'org.intermine:intermine-ws-java:3.0.+'</pre>
        </p>

      </p>
      </div>
    </li>
    <li>
      <div onclick="javascript:showText('codegen')"><h3 style="font-weight: bold;">Getting Started</h3></div>
      <div id="codegen" style="padding: 5px">
        <span>You can get example Java web service API code either from a Template Query or the QueryBuilder:</span>
          <ul style="padding:0px">
            <li>
              From the QueryBuilder - after creating or editing a query, click the "Java" link in
        the <b>Actions</b> section below the query details.
            </li>
            <li>
              From a Template Query form - click the "Java" link below the template form.
            </li>
          </ul>
      </div>
    </li>
  </ul>
</div>

</im:boxarea>
<!-- /apiJava.jsp -->
