/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.export;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.io.FastaWriterHelper;
import org.biojava.nbio.core.sequence.template.Sequence;
import org.biojava.nbio.ontology.utils.SmallAnnotation;
import org.intermine.bio.web.biojava.BioSequence;
import org.intermine.bio.web.biojava.BioSequenceFactory;
import org.intermine.metadata.ConstraintOp;
import org.intermine.model.InterMineObject;
import org.intermine.model.bio.Protein;
import org.intermine.model.bio.SequenceFeature;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.query.Constraint;
import org.intermine.objectstore.query.ConstraintSet;
import org.intermine.objectstore.query.ContainsConstraint;
import org.intermine.objectstore.query.FromElement;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryEvaluable;
import org.intermine.objectstore.query.QueryField;
import org.intermine.objectstore.query.QueryObjectReference;
import org.intermine.objectstore.query.QueryReference;
import org.intermine.objectstore.query.QuerySelectable;
import org.intermine.objectstore.query.QueryValue;
import org.intermine.objectstore.query.Results;
import org.intermine.objectstore.query.SimpleConstraint;
import org.intermine.web.logic.export.ExportException;
import org.intermine.web.logic.export.FieldExporter;

public class ResidueFieldExporter
implements FieldExporter {
    protected static final Logger LOG = Logger.getLogger(ResidueFieldExporter.class);
    protected static final String PROPERTY_DESCRIPTIONLINE = "description_line";

    public void exportField(InterMineObject object, String fieldName, ObjectStore os, HttpServletResponse response) {
        if (!(object instanceof org.intermine.model.bio.Sequence)) {
            throw new IllegalArgumentException("ResidueFieldExporter can only export Sequence.residues fields");
        }
        org.intermine.model.bio.Sequence sequence = (org.intermine.model.bio.Sequence)object;
        response.setContentType("text/plain");
        response.setHeader("Content-Disposition ", "inline; filename=" + fieldName + ".fasta");
        try {
            SequenceFeature lsf;
            SequenceFeature bioEntity = lsf = ResidueFieldExporter.getSequenceFeatureForSequence(os, (org.intermine.model.bio.Sequence)object);
            Protein protein = null;
            if (bioEntity == null) {
                protein = ResidueFieldExporter.getProteinForSequence(os, sequence);
                bioEntity = protein;
            }
            if (bioEntity == null) {
                LOG.error((Object)("No SequenceFeature or Protein has a Sequence with id " + sequence.getId()));
                ServletOutputStream outputStream = response.getOutputStream();
                PrintStream printStream = new PrintStream((OutputStream)outputStream);
                sequence.getResidues().drainToPrintStream(printStream);
                printStream.println("");
                printStream.close();
                outputStream.close();
                return;
            }
            BioSequence bioSequence = lsf != null ? BioSequenceFactory.make(lsf) : BioSequenceFactory.make(protein);
            ServletOutputStream outputStream = response.getOutputStream();
            SmallAnnotation annotation = bioSequence.getAnnotation();
            annotation.setProperty((Object)PROPERTY_DESCRIPTIONLINE, (Object)bioEntity.getPrimaryIdentifier());
            FastaWriterHelper.writeSequence((OutputStream)outputStream, (Sequence)bioSequence);
            outputStream.close();
        }
        catch (CompoundNotFoundException e) {
            throw new ExportException("unexpected error while exporting", (Exception)((Object)e));
        }
        catch (IllegalArgumentException e) {
            throw new ExportException("unexpected error while exporting", (Exception)e);
        }
        catch (IOException e) {
            throw new ExportException("unexpected IO error while exporting", (Exception)e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ExportException("unexpected error while exporting", e);
        }
    }

    public static SequenceFeature getSequenceFeatureForSequence(ObjectStore os, org.intermine.model.bio.Sequence sequence) {
        Query q = new Query();
        QueryClass lsfQc = new QueryClass(SequenceFeature.class);
        q.addFrom((FromElement)lsfQc);
        q.addToSelect((QuerySelectable)lsfQc);
        QueryClass sequenceQc = new QueryClass(org.intermine.model.bio.Sequence.class);
        q.addFrom((FromElement)sequenceQc);
        QueryObjectReference ref = new QueryObjectReference(lsfQc, "sequence");
        ConstraintSet cs = new ConstraintSet(ConstraintOp.AND);
        cs.addConstraint((Constraint)new ContainsConstraint((QueryReference)ref, ConstraintOp.CONTAINS, sequenceQc));
        QueryField seqIdQf = new QueryField(sequenceQc, "id");
        QueryValue seqIdQv = new QueryValue((Object)sequence.getId());
        cs.addConstraint((Constraint)new SimpleConstraint((QueryEvaluable)seqIdQf, ConstraintOp.EQUALS, (QueryEvaluable)seqIdQv));
        q.setConstraint((Constraint)cs);
        Results results = os.execute(q);
        if (results.size() == 1) {
            return (SequenceFeature)((List)results.get(0)).get(0);
        }
        return null;
    }

    public static Protein getProteinForSequence(ObjectStore os, org.intermine.model.bio.Sequence sequence) {
        Query q = new Query();
        QueryClass proteinQc = new QueryClass(Protein.class);
        q.addFrom((FromElement)proteinQc);
        q.addToSelect((QuerySelectable)proteinQc);
        QueryClass sequenceQc = new QueryClass(org.intermine.model.bio.Sequence.class);
        q.addFrom((FromElement)sequenceQc);
        QueryObjectReference ref = new QueryObjectReference(proteinQc, "sequence");
        ConstraintSet cs = new ConstraintSet(ConstraintOp.AND);
        cs.addConstraint((Constraint)new ContainsConstraint((QueryReference)ref, ConstraintOp.CONTAINS, sequenceQc));
        QueryField seqIdQf = new QueryField(sequenceQc, "id");
        QueryValue seqIdQv = new QueryValue((Object)sequence.getId());
        cs.addConstraint((Constraint)new SimpleConstraint((QueryEvaluable)seqIdQf, ConstraintOp.EQUALS, (QueryEvaluable)seqIdQv));
        q.setConstraint((Constraint)cs);
        Results results = os.execute(q);
        if (results.size() == 1) {
            return (Protein)((List)results.get(0)).get(0);
        }
        return null;
    }

    public static InterMineObject getIMObjectForSequence(ObjectStore os, Class clazz, org.intermine.model.bio.Sequence sequence) {
        Query q = new Query();
        QueryClass queryClass = new QueryClass(clazz);
        q.addFrom((FromElement)queryClass);
        q.addToSelect((QuerySelectable)queryClass);
        QueryClass sequenceQc = new QueryClass(org.intermine.model.bio.Sequence.class);
        q.addFrom((FromElement)sequenceQc);
        QueryObjectReference ref = new QueryObjectReference(queryClass, "sequence");
        ConstraintSet cs = new ConstraintSet(ConstraintOp.AND);
        cs.addConstraint((Constraint)new ContainsConstraint((QueryReference)ref, ConstraintOp.CONTAINS, sequenceQc));
        QueryField seqIdQf = new QueryField(sequenceQc, "id");
        QueryValue seqIdQv = new QueryValue((Object)sequence.getId());
        cs.addConstraint((Constraint)new SimpleConstraint((QueryEvaluable)seqIdQf, ConstraintOp.EQUALS, (QueryEvaluable)seqIdQv));
        q.setConstraint((Constraint)cs);
        Results results = os.execute(q);
        if (results.size() == 1) {
            return (InterMineObject)((List)results.get(0)).get(0);
        }
        return null;
    }
}

