/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.displayer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.query.PathQueryExecutor;
import org.intermine.api.results.ExportResultsIterator;
import org.intermine.api.results.ResultElement;
import org.intermine.metadata.Model;
import org.intermine.model.InterMineObject;
import org.intermine.model.bio.Gene;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.pathquery.Constraints;
import org.intermine.pathquery.OrderDirection;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.displayer.ReportDisplayer;
import org.intermine.web.logic.config.ReportDisplayerConfig;
import org.intermine.web.logic.results.ReportObject;
import org.intermine.web.logic.session.SessionMethods;

public class CuratedProteinsDisplayer
extends ReportDisplayer {
    protected static final Logger LOG = Logger.getLogger(CuratedProteinsDisplayer.class);
    private ArrayList<String> columns = new ArrayList<String>(){
        {
            this.add("primaryIdentifier");
            this.add("id");
            this.add("primaryAccession");
            this.add("organismName");
            this.add("isUniprotCanonical");
            this.add("dataSetsName");
            this.add("length");
        }
    };

    public CuratedProteinsDisplayer(ReportDisplayerConfig config, InterMineAPI im) {
        super(config, im);
    }

    public void display(HttpServletRequest request, ReportObject reportObject) {
        InterMineObject object = reportObject.getObject();
        HttpSession session = request.getSession();
        this.im = SessionMethods.getInterMineAPI((HttpSession)session);
        Model model = this.im.getModel();
        PathQuery query = new PathQuery(model);
        Gene gene = (Gene)object;
        String genePrimaryIDObj = gene.getPrimaryIdentifier();
        if (genePrimaryIDObj != null) {
            ExportResultsIterator values;
            query = CuratedProteinsDisplayer.buildQuery(String.valueOf(genePrimaryIDObj), query);
            Profile profile = SessionMethods.getProfile((HttpSession)session);
            PathQueryExecutor executor = this.im.getPathQueryExecutor(profile);
            try {
                values = executor.execute(query);
            }
            catch (ObjectStoreException e) {
                throw new RuntimeException(e);
            }
            LinkedHashMap results = new LinkedHashMap();
            while (values.hasNext()) {
                List row = values.next();
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (String column : this.columns) {
                    map.put(column, ((ResultElement)row.get(this.columns.indexOf(column))).getField());
                }
                if ("Swiss-Prot data set".equals(map.get("dataSetsName"))) {
                    map.put("isSwissProtCurate", true);
                } else {
                    map.put("isSwissProtCurate", false);
                }
                String key = (String)map.get("primaryIdentifier");
                Map mapObj = (Map)results.get(key);
                if (mapObj != null) {
                    if (((Boolean)mapObj.get("isSwissProtCurate")).booleanValue() || !((Boolean)map.get("isSwissProtCurate")).booleanValue()) continue;
                    results.put(key, map);
                    continue;
                }
                results.put(key, map);
            }
            request.setAttribute("results", results);
        }
    }

    private static PathQuery buildQuery(String genePrimaryID, PathQuery query) {
        query.addViews(new String[]{"Gene.proteins.primaryIdentifier", "Gene.proteins.id", "Gene.proteins.primaryAccession", "Gene.proteins.organism.name", "Gene.proteins.isUniprotCanonical", "Gene.proteins.dataSets.name", "Gene.proteins.length"});
        query.addOrderBy("Gene.proteins.primaryIdentifier", OrderDirection.ASC);
        query.addConstraint((PathConstraint)Constraints.eq((String)"Gene.primaryIdentifier", (String)genePrimaryID));
        return query;
    }
}

