/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.displayer;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.query.PathQueryExecutor;
import org.intermine.api.results.ExportResultsIterator;
import org.intermine.bio.web.model.GeneExpressionAtlasTissuesExpressions;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.Model;
import org.intermine.model.InterMineObject;
import org.intermine.model.bio.Gene;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.pathquery.Constraints;
import org.intermine.pathquery.OrderDirection;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.displayer.ReportDisplayer;
import org.intermine.web.logic.config.ReportDisplayerConfig;
import org.intermine.web.logic.pathqueryresult.PathQueryResultHelper;
import org.intermine.web.logic.results.InlineResultsTable;
import org.intermine.web.logic.results.ReportObject;
import org.intermine.web.logic.session.SessionMethods;

public class GeneExpressionAtlasTissuesDisplayer
extends ReportDisplayer {
    public GeneExpressionAtlasTissuesDisplayer(ReportDisplayerConfig config, InterMineAPI im) {
        super(config, im);
    }

    public void display(HttpServletRequest request, ReportObject reportObject) {
        InterMineObject object = reportObject.getObject();
        HttpSession session = request.getSession();
        this.im = SessionMethods.getInterMineAPI((HttpSession)session);
        Model model = this.im.getModel();
        PathQuery query = new PathQuery(model);
        Gene gene = (Gene)object;
        String genePrimaryIDObj = gene.getPrimaryIdentifier();
        if (genePrimaryIDObj != null) {
            ExportResultsIterator values;
            String genePrimaryID = String.valueOf(genePrimaryIDObj);
            query = GeneExpressionAtlasTissuesDisplayer.geneExpressionAtlasQuery(genePrimaryID, query);
            Profile profile = SessionMethods.getProfile((HttpSession)session);
            PathQueryExecutor executor = this.im.getPathQueryExecutor(profile);
            try {
                values = executor.execute(query);
            }
            catch (ObjectStoreException e) {
                throw new RuntimeException(e);
            }
            GeneExpressionAtlasTissuesExpressions geae = new GeneExpressionAtlasTissuesExpressions(values);
            request.setAttribute("expressions", (Object)geae);
            request.setAttribute("url", (Object)("http://www.ebi.ac.uk/gxa/experiment/E-MTAB-62/" + genePrimaryID));
            request.setAttribute("defaultPValue", (Object)"1e-4");
            request.setAttribute("defaultTValue", (Object)"4");
            for (FieldDescriptor fd : reportObject.getClassDescriptor().getAllFieldDescriptors()) {
                if (!"atlasExpression".equals(fd.getName()) || !fd.isCollection()) continue;
                Collection collection = null;
                try {
                    collection = (Collection)reportObject.getObject().getFieldValue("atlasExpression");
                }
                catch (IllegalAccessException e) {
                    return;
                }
                List lc = PathQueryResultHelper.queryForTypesInCollection((InterMineObject)reportObject.getObject(), (String)"atlasExpression", (ObjectStore)this.im.getObjectStore());
                InlineResultsTable t = new InlineResultsTable(collection, fd.getClassDescriptor().getModel(), SessionMethods.getWebConfig((HttpServletRequest)request), (Map)this.im.getClassKeys(), collection.size(), false, lc);
                request.setAttribute("collection", (Object)t);
                break;
            }
        }
    }

    private static PathQuery geneExpressionAtlasQuery(String genePrimaryID, PathQuery query) {
        query.addViews(new String[]{"Gene.atlasExpression.condition", "Gene.atlasExpression.expression", "Gene.atlasExpression.pValue", "Gene.atlasExpression.tStatistic", "Gene.atlasExpression.type", "Gene.primaryIdentifier"});
        query.addConstraint((PathConstraint)Constraints.eq((String)"Gene.primaryIdentifier", (String)genePrimaryID));
        query.addConstraint((PathConstraint)Constraints.eq((String)"Gene.atlasExpression.type", (String)"organism_part"));
        query.addConstraint((PathConstraint)Constraints.notLike((String)"Gene.atlasExpression.condition", (String)"(empty)"));
        query.addOrderBy("Gene.atlasExpression.condition", OrderDirection.ASC);
        return query;
    }
}

