/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.displayer;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.intermine.api.InterMineAPI;
import org.intermine.bio.web.displayer.ValueComparator;
import org.intermine.model.InterMineObject;
import org.intermine.web.displayer.ReportDisplayer;
import org.intermine.web.logic.config.ReportDisplayerConfig;
import org.intermine.web.logic.results.ReportObject;

public class PathwaysDisplayer
extends ReportDisplayer {
    private Map<Integer, Map<InterMineObject, Integer>> cache = new ConcurrentHashMap<Integer, Map<InterMineObject, Integer>>();

    public PathwaysDisplayer(ReportDisplayerConfig config, InterMineAPI im) {
        super(config, im);
    }

    public void display(HttpServletRequest request, ReportObject reportObject) {
        InterMineObject gene = reportObject.getObject();
        Map<InterMineObject, Integer> pathways = this.getPathways(gene);
        if (pathways.isEmpty()) {
            request.setAttribute("noPathwayResults", (Object)"No pathways found");
        } else {
            TreeMap<InterMineObject, Integer> sortedPathways = new TreeMap<InterMineObject, Integer>(new ValueComparator(pathways));
            sortedPathways.putAll(pathways);
            request.setAttribute("pathways", sortedPathways);
        }
    }

    private Map<InterMineObject, Integer> getPathways(InterMineObject gene) {
        if (!this.cache.containsKey(gene.getId())) {
            try {
                HashMap<InterMineObject, Integer> pathways = new HashMap<InterMineObject, Integer>();
                Collection col = (Collection)gene.getFieldValue("pathways");
                for (Object item : col) {
                    InterMineObject pathway = (InterMineObject)item;
                    if (pathway == null) continue;
                    Collection genes = (Collection)pathway.getFieldValue("genes");
                    pathways.put(pathway, genes.size());
                }
                this.cache.put(gene.getId(), pathways);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return this.cache.get(gene.getId());
    }
}

