/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.displayer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.query.PathQueryExecutor;
import org.intermine.api.results.ExportResultsIterator;
import org.intermine.api.results.ResultElement;
import org.intermine.metadata.Model;
import org.intermine.metadata.TypeUtil;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.pathquery.Constraints;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.displayer.ReportDisplayer;
import org.intermine.web.logic.config.ReportDisplayerConfig;
import org.intermine.web.logic.results.InlineResultsTable;
import org.intermine.web.logic.results.ReportObject;
import org.intermine.web.logic.session.SessionMethods;

public class PublicationAnnotationsDisplayer
extends ReportDisplayer {
    protected static final Logger LOG = Logger.getLogger(PublicationAnnotationsDisplayer.class);

    public PublicationAnnotationsDisplayer(ReportDisplayerConfig config, InterMineAPI im) {
        super(config, im);
    }

    public void display(HttpServletRequest request, ReportObject reportObject) {
        HashMap<String, InlineResultsTable> result = new HashMap<String, InlineResultsTable>();
        InterMineObject object = reportObject.getObject();
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)session);
        String params = this.config.getParameterString();
        if (StringUtils.isEmpty((String)params)) {
            LOG.error((Object)"Parameters not configured for publications displayer, not showing any.");
            return;
        }
        Profile profile = SessionMethods.getProfile((HttpSession)session);
        PathQueryExecutor executor = im.getPathQueryExecutor(profile);
        for (String path : params.split("[, ]+")) {
            ExportResultsIterator values;
            String type = this.getType(path);
            List<Class<?>> lc = this.getClass(type, im.getModel());
            if (lc.isEmpty()) {
                LOG.error((Object)("Invalid class name: " + type));
                continue;
            }
            PathQuery q = new PathQuery(im.getModel());
            q.addView(type + ".id");
            q.addConstraint((PathConstraint)Constraints.eq((String)(path + ".publications.id"), (String)object.getId().toString()));
            if (!q.isValid()) {
                q = new PathQuery(im.getModel());
                q.addView(type + ".id");
                q.addConstraint((PathConstraint)Constraints.eq((String)(path + ".publication.id"), (String)object.getId().toString()));
                if (!q.isValid()) {
                    LOG.error((Object)("No publications reference or collection found: " + path));
                    continue;
                }
            }
            try {
                values = executor.execute(q);
            }
            catch (ObjectStoreException e) {
                throw new RuntimeException(e);
            }
            HashSet<InterMineObject> results = new HashSet<InterMineObject>();
            int count = this.formatResults(results, values);
            InlineResultsTable t = new InlineResultsTable(results, im.getModel(), SessionMethods.getWebConfig((HttpServletRequest)request), (Map)im.getClassKeys(), count, false, lc);
            if (count <= 0) continue;
            result.put(type, t);
        }
        request.setAttribute("results", result);
    }

    private List<Class<?>> getClass(String type, Model model) {
        ArrayList lc = new ArrayList();
        try {
            Class c = TypeUtil.getClass((String)type, (Model)model);
            lc.add(c);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return lc;
    }

    private String getType(String path) {
        if (path.contains(".")) {
            return path.split("\\.")[0];
        }
        return path;
    }

    private int formatResults(Collection<InterMineObject> results, ExportResultsIterator it) {
        int i = 0;
        while (it.hasNext()) {
            List row = it.next();
            ResultElement e = (ResultElement)row.get(0);
            InterMineObject o = (InterMineObject)e.getObject();
            results.add(o);
            ++i;
        }
        return i;
    }
}

