/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.displayer;

import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.metadata.ConstraintOp;
import org.intermine.metadata.Model;
import org.intermine.model.FastPathObject;
import org.intermine.model.InterMineObject;
import org.intermine.model.bio.Publication;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.query.Constraint;
import org.intermine.objectstore.query.ConstraintSet;
import org.intermine.objectstore.query.ContainsConstraint;
import org.intermine.objectstore.query.FromElement;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryCollectionReference;
import org.intermine.objectstore.query.QueryField;
import org.intermine.objectstore.query.QueryFunction;
import org.intermine.objectstore.query.QueryNode;
import org.intermine.objectstore.query.QueryOrderable;
import org.intermine.objectstore.query.QueryReference;
import org.intermine.objectstore.query.QuerySelectable;
import org.intermine.objectstore.query.Results;
import org.intermine.objectstore.query.ResultsRow;
import org.intermine.util.DynamicUtil;
import org.intermine.web.displayer.ReportDisplayer;
import org.intermine.web.logic.config.ReportDisplayerConfig;
import org.intermine.web.logic.results.ReportObject;
import org.intermine.web.logic.session.SessionMethods;

public class PublicationCountsDisplayer
extends ReportDisplayer {
    protected static final Logger LOG = Logger.getLogger(PublicationCountsDisplayer.class);

    public PublicationCountsDisplayer(ReportDisplayerConfig config, InterMineAPI im) {
        super(config, im);
    }

    public void display(HttpServletRequest request, ReportObject reportObject) {
        LinkedHashMap<Publication, String> publications = new LinkedHashMap<Publication, String>();
        InterMineObject object = reportObject.getObject();
        String type = DynamicUtil.getSimpleClass((FastPathObject)object).getSimpleName();
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)session);
        Query q = this.getQuery(im, object, type);
        ObjectStore os = im.getObjectStore();
        Results results = os.execute(q, 2000, true, true, true);
        Iterator it = results.iterator();
        int i = 0;
        while (it.hasNext()) {
            ResultsRow rr = (ResultsRow)it.next();
            Publication pub = (Publication)rr.get(0);
            Long count = (Long)rr.get(1);
            publications.put(pub, count.toString());
            ++i;
        }
        request.setAttribute("totalNumberOfPubs", (Object)i);
        request.setAttribute("results", publications);
        request.setAttribute("type", (Object)type);
        if (results.isEmpty()) {
            request.setAttribute("noResults", (Object)"No publications found");
        }
    }

    private Query getQuery(InterMineAPI im, InterMineObject object, String type) {
        Model model = im.getModel();
        QueryClass qcPub = new QueryClass(Publication.class);
        QueryClass qcOtherGenes = null;
        try {
            qcOtherGenes = new QueryClass(new Class[]{Class.forName(model.getPackageName() + "." + type)});
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)"Error rendering publication count displayer", (Throwable)e);
            return null;
        }
        QueryField qfDate = new QueryField(qcPub, "year");
        ConstraintSet cs = new ConstraintSet(ConstraintOp.AND);
        QueryCollectionReference qcr1 = new QueryCollectionReference(object, "publications");
        cs.addConstraint((Constraint)new ContainsConstraint((QueryReference)qcr1, ConstraintOp.CONTAINS, qcPub));
        QueryCollectionReference qcr2 = new QueryCollectionReference(qcOtherGenes, "publications");
        cs.addConstraint((Constraint)new ContainsConstraint((QueryReference)qcr2, ConstraintOp.CONTAINS, qcPub));
        Query q = new Query();
        q.setDistinct(true);
        q.addFrom((FromElement)qcPub);
        q.addFrom((FromElement)qcOtherGenes);
        q.setConstraint((Constraint)cs);
        q.addToSelect((QuerySelectable)qcPub);
        QueryFunction qf = new QueryFunction();
        q.addToSelect((QuerySelectable)qf);
        q.addToGroupBy((QueryNode)new QueryField(qcPub, "id"));
        q.addToGroupBy((QueryNode)qfDate);
        q.addToSelect((QuerySelectable)qfDate);
        q.addToOrderBy((QueryOrderable)qf);
        q.addToOrderBy((QueryOrderable)qfDate, "desc");
        return q;
    }
}

