/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.logic;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.ArrayUtils;
import org.apache.tools.ant.BuildException;
import org.intermine.bio.web.logic.GenomicRegionSearchService;
import org.intermine.bio.web.logic.RegionParseException;
import org.intermine.bio.web.model.ChromosomeInfo;
import org.intermine.bio.web.model.GenomicRegion;
import org.intermine.metadata.ConstraintOp;
import org.intermine.model.bio.Chromosome;
import org.intermine.model.bio.Location;
import org.intermine.model.bio.Organism;
import org.intermine.model.bio.SequenceFeature;
import org.intermine.objectstore.query.BagConstraint;
import org.intermine.objectstore.query.Constraint;
import org.intermine.objectstore.query.ConstraintSet;
import org.intermine.objectstore.query.ContainsConstraint;
import org.intermine.objectstore.query.FromElement;
import org.intermine.objectstore.query.OverlapConstraint;
import org.intermine.objectstore.query.OverlapRange;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryEvaluable;
import org.intermine.objectstore.query.QueryField;
import org.intermine.objectstore.query.QueryNode;
import org.intermine.objectstore.query.QueryObjectReference;
import org.intermine.objectstore.query.QueryOrderable;
import org.intermine.objectstore.query.QueryReference;
import org.intermine.objectstore.query.QuerySelectable;
import org.intermine.objectstore.query.QueryValue;
import org.intermine.objectstore.query.SimpleConstraint;
import org.intermine.web.logic.session.SessionMethods;

public final class GenomicRegionSearchUtil {
    private static final Pattern DOT_DOT = Pattern.compile("[^:]+: ?\\d+\\.{2}\\d+$");
    private static final Pattern BED = Pattern.compile("[^\\t\\s]+\\t\\d+\\t\\d+");
    private static final Pattern DASH = Pattern.compile("[^:]+: ?\\d+\\-\\d+$");
    private static final Pattern SINGLE_POS = Pattern.compile("[^:]+: ?\\d+$");

    private GenomicRegionSearchUtil() {
    }

    public static GenomicRegionSearchService getGenomicRegionSearchService(HttpServletRequest request) {
        String serviceClassName = (String)SessionMethods.getWebProperties((ServletContext)request.getSession().getServletContext()).get("genomicRegionSearch.service");
        GenomicRegionSearchService grsService = null;
        if (serviceClassName == null || "".equals(serviceClassName)) {
            grsService = new GenomicRegionSearchService();
            grsService.init(request);
        } else {
            Class<?> serviceClass;
            try {
                serviceClass = Class.forName(serviceClassName);
            }
            catch (ClassNotFoundException e) {
                throw new BuildException("Class not found for " + serviceClassName, (Throwable)e);
            }
            Class[] types = new Class[]{HttpServletRequest.class};
            Object[] args = new Object[]{request};
            try {
                grsService = (GenomicRegionSearchService)serviceClass.getConstructor(types).newInstance(args);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        return grsService;
    }

    public static GenomicRegion parseRegion(String span, boolean isInterbase, Map<String, ChromosomeInfo> chromsForOrg) throws RegionParseException {
        String[] parts = GenomicRegionSearchUtil.parseDotDotSpan(span);
        if (parts == null) {
            parts = GenomicRegionSearchUtil.parseBedSpan(span);
        }
        if (parts == null) {
            parts = GenomicRegionSearchUtil.parseDashSpan(span);
        }
        if (parts == null) {
            parts = GenomicRegionSearchUtil.parseSinglePositionSpan(span);
        }
        if (parts == null) {
            throw new RegionParseException("Span format not recognised");
        }
        GenomicRegion region = new GenomicRegion();
        region.setChr(parts[0].trim());
        int start = Integer.valueOf(parts[1].trim());
        int end = Integer.valueOf(parts[2].trim());
        if (isInterbase) {
            region.setStart(start + 1);
        } else {
            region.setStart(start);
        }
        region.setEnd(end);
        region.setMinusStrand(start > end);
        ChromosomeInfo ci = GenomicRegionSearchUtil.getChromosomeInfo(chromsForOrg, region.getChr());
        if (region.getStart() >= 1 && region.getStart() <= ci.getChrLength() && region.getEnd() >= 1 && region.getEnd() <= ci.getChrLength()) {
            if (region.getStart() > region.getEnd()) {
                int oldStart = region.getStart();
                int oldEnd = region.getEnd();
                region.setStart(oldStart);
                region.setEnd(oldEnd);
            }
        } else {
            throw new RegionParseException("start and/or end values are out of bounds (0 - " + ci.getChrLength() + ")");
        }
        region.setChr(ci.getChrPID());
        return region;
    }

    private static ChromosomeInfo getChromosomeInfo(Map<String, ChromosomeInfo> chromsForOrg, String chromosome) throws RegionParseException {
        String chr = chromosome.toLowerCase();
        if (chromsForOrg.containsKey(chr)) {
            return chromsForOrg.get(chr);
        }
        if (chr.startsWith("chr") && chromsForOrg.containsKey(chr.substring(3))) {
            return chromsForOrg.get(chr.substring(3));
        }
        throw new RegionParseException(chr + " does not match any chromosome in this organism");
    }

    private static String[] parseDotDotSpan(String span) {
        Matcher m = DOT_DOT.matcher(span);
        if (m.find()) {
            Object[] chr = new String[]{span.split(":")[0]};
            return (String[])ArrayUtils.addAll((Object[])chr, (Object[])span.split(":")[1].split("\\.{2}"));
        }
        return null;
    }

    private static String[] parseBedSpan(String span) {
        Matcher m = BED.matcher(span);
        if (m.find()) {
            return span.split("\t");
        }
        return null;
    }

    private static String[] parseDashSpan(String span) {
        Matcher m = DASH.matcher(span);
        if (m.find()) {
            Object[] chr = new String[]{span.split(":")[0]};
            return (String[])ArrayUtils.addAll((Object[])chr, (Object[])span.split(":")[1].split("-"));
        }
        return null;
    }

    private static String[] parseSinglePositionSpan(String span) {
        Matcher m = SINGLE_POS.matcher(span);
        String[] ret = new String[3];
        if (m.find()) {
            ret[0] = span.split(":")[0];
            ret[1] = span.split(":")[1];
            ret[2] = ret[1];
            return ret;
        }
        return null;
    }

    public static Map<GenomicRegion, Query> createQueryList(Collection<GenomicRegion> genomicRegions, int extension, String organismName, Set<Class<?>> featureTypes, boolean strandSpecific) {
        return GenomicRegionSearchUtil.createRegionQueries(genomicRegions, extension, organismName, featureTypes, strandSpecific, false);
    }

    public static Map<GenomicRegion, Query> createRegionListQueries(Collection<GenomicRegion> genomicRegions, int extension, Map<String, ChromosomeInfo> chromInfo, String organismName, Set<Class<?>> featureTypes, boolean strandSpecific) {
        return GenomicRegionSearchUtil.createRegionQueries(genomicRegions, extension, organismName, featureTypes, strandSpecific, true);
    }

    private static Map<GenomicRegion, Query> createRegionQueries(Collection<GenomicRegion> genomicRegions, int extension, String organismName, Set<Class<?>> featureTypes, boolean strandSpecific, boolean idOnly) {
        LinkedHashMap<GenomicRegion, Query> queryMap = new LinkedHashMap<GenomicRegion, Query>();
        for (GenomicRegion aSpan : genomicRegions) {
            Integer end;
            Integer start;
            if (extension > 0) {
                aSpan = GenomicRegionSearchUtil.extendGenomicRegion(aSpan, extension);
                start = aSpan.getExtendedStart();
                end = aSpan.getExtendedEnd();
            } else {
                start = aSpan.getStart();
                end = aSpan.getEnd();
            }
            Query q = new Query();
            q.setDistinct(true);
            String chrPID = aSpan.getChr();
            QueryClass qcOrg = new QueryClass(Organism.class);
            QueryClass qcChr = new QueryClass(Chromosome.class);
            QueryClass qcFeature = new QueryClass(SequenceFeature.class);
            QueryClass qcLoc = new QueryClass(Location.class);
            QueryField qfOrgName = new QueryField(qcOrg, "shortName");
            QueryField qfFeatureId = new QueryField(qcFeature, "id");
            QueryField qfFeaturePID = new QueryField(qcFeature, "primaryIdentifier");
            QueryField qfFeatureSymbol = new QueryField(qcFeature, "symbol");
            QueryField qfFeatureClass = new QueryField(qcFeature, "class");
            QueryField qfChr = new QueryField(qcChr, "primaryIdentifier");
            QueryField qfLocStart = new QueryField(qcLoc, "start");
            QueryField qfLocEnd = new QueryField(qcLoc, "end");
            QueryField qfLocStrand = new QueryField(qcLoc, "strand");
            q.addToSelect((QuerySelectable)qfFeatureId);
            q.addFrom((FromElement)qcFeature);
            q.addFrom((FromElement)qcChr);
            q.addFrom((FromElement)qcOrg);
            q.addFrom((FromElement)qcLoc);
            if (!idOnly) {
                q.addToSelect((QuerySelectable)qfFeaturePID);
                q.addToSelect((QuerySelectable)qfFeatureSymbol);
                q.addToSelect((QuerySelectable)qfFeatureClass);
                q.addToSelect((QuerySelectable)qfChr);
                q.addToSelect((QuerySelectable)qfLocStart);
                q.addToSelect((QuerySelectable)qfLocEnd);
                q.addToSelect((QuerySelectable)qfLocStrand);
                q.addToOrderBy((QueryOrderable)qfLocStart, "ascending");
            }
            ConstraintSet constraints = new ConstraintSet(ConstraintOp.AND);
            q.setConstraint((Constraint)constraints);
            QueryObjectReference organism = new QueryObjectReference(qcFeature, "organism");
            ContainsConstraint ccOrg = new ContainsConstraint((QueryReference)organism, ConstraintOp.CONTAINS, qcOrg);
            constraints.addConstraint((Constraint)ccOrg);
            SimpleConstraint scOrg = new SimpleConstraint((QueryEvaluable)qfOrgName, ConstraintOp.EQUALS, (QueryEvaluable)new QueryValue((Object)organismName));
            constraints.addConstraint((Constraint)scOrg);
            QueryObjectReference locSubject = new QueryObjectReference(qcLoc, "feature");
            ContainsConstraint ccLocSubject = new ContainsConstraint((QueryReference)locSubject, ConstraintOp.CONTAINS, qcFeature);
            constraints.addConstraint((Constraint)ccLocSubject);
            QueryObjectReference locObject = new QueryObjectReference(qcLoc, "locatedOn");
            ContainsConstraint ccLocObject = new ContainsConstraint((QueryReference)locObject, ConstraintOp.CONTAINS, qcChr);
            constraints.addConstraint((Constraint)ccLocObject);
            if (strandSpecific) {
                String strand = "1";
                if (aSpan.getMinusStrand().booleanValue()) {
                    strand = "-1";
                }
                SimpleConstraint scStrand = new SimpleConstraint((QueryEvaluable)qfLocStrand, ConstraintOp.EQUALS, (QueryEvaluable)new QueryValue((Object)strand));
                constraints.addConstraint((Constraint)scStrand);
            }
            SimpleConstraint scChr = new SimpleConstraint((QueryEvaluable)qfChr, ConstraintOp.EQUALS, (QueryEvaluable)new QueryValue((Object)chrPID));
            constraints.addConstraint((Constraint)scChr);
            constraints.addConstraint((Constraint)new BagConstraint((QueryNode)qfFeatureClass, ConstraintOp.IN, featureTypes));
            OverlapRange overlapInput = new OverlapRange((QueryEvaluable)new QueryValue((Object)start), (QueryEvaluable)new QueryValue((Object)end), locObject);
            OverlapRange overlapFeature = new OverlapRange((QueryEvaluable)new QueryField(qcLoc, "start"), (QueryEvaluable)new QueryField(qcLoc, "end"), locObject);
            OverlapConstraint oc = new OverlapConstraint(overlapInput, ConstraintOp.OVERLAPS, overlapFeature);
            constraints.addConstraint((Constraint)oc);
            queryMap.put(aSpan, q);
        }
        return queryMap;
    }

    private static GenomicRegion extendGenomicRegion(GenomicRegion gr, int extension) {
        int min = 1;
        int start = gr.getStart();
        int end = gr.getEnd();
        int extendedStart = start - extension;
        int extendedEnd = end + extension;
        if (extendedStart < min) {
            gr.setExtendedStart(min);
        } else {
            gr.setExtendedStart(extendedStart);
        }
        gr.setExtendedEnd(extendedEnd);
        return gr;
    }

    public static List<GenomicRegion> generateGenomicRegions(Collection<String> genomicRegionStringCollection) throws Exception {
        ArrayList<GenomicRegion> genomicRegionList = new ArrayList<GenomicRegion>();
        for (String genomicRegionString : genomicRegionStringCollection) {
            String organism;
            String extenedSize;
            String extended;
            String original;
            String[] grInfo = genomicRegionString.trim().split("\\|");
            if (grInfo.length == 3) {
                original = grInfo[0];
                extended = null;
                extenedSize = grInfo[1];
                organism = grInfo[2];
            } else if (grInfo.length == 4) {
                original = grInfo[1];
                extended = grInfo[0];
                extenedSize = grInfo[2];
                organism = grInfo[3];
            } else {
                throw new Exception("Genomic region info error: " + genomicRegionString);
            }
            GenomicRegion gr = new GenomicRegion();
            if (organism == null || original == null) {
                throw new Exception("Organism and Original genomic region string can not be null");
            }
            if (extended == null) {
                Matcher m = DOT_DOT.matcher(original);
                if (m.find()) {
                    String chr = original.split(":")[0];
                    String start = original.split(":")[1].split("\\.{2}")[0];
                    String end = original.split(":")[1].split("\\.{2}")[1];
                    gr.setOrganism(organism);
                    gr.setChr(chr);
                    gr.setStart(Integer.valueOf(start));
                    gr.setEnd(Integer.valueOf(end));
                    gr.setExtendedRegionSize(0);
                    gr.setMinusStrand(gr.getStart() > gr.getEnd());
                    genomicRegionList.add(gr);
                    continue;
                }
                throw new Exception("Not Dot-Dot format: " + original);
            }
            if (extenedSize == null) {
                throw new Exception("extenedSize can not be null");
            }
            Matcher mo = DOT_DOT.matcher(original);
            Matcher me = DOT_DOT.matcher(extended);
            if (mo.find() && me.find()) {
                String chr = original.split(":")[0];
                String start = original.split(":")[1].split("\\.{2}")[0];
                String end = original.split(":")[1].split("\\.{2}")[1];
                String extStart = extended.split(":")[1].split("\\.{2}")[0];
                String extEnd = extended.split(":")[1].split("\\.{2}")[1];
                gr.setOrganism(organism);
                gr.setChr(chr);
                gr.setStart(Integer.valueOf(start));
                gr.setEnd(Integer.valueOf(end));
                gr.setExtendedStart(Integer.valueOf(extStart));
                gr.setExtendedEnd(Integer.valueOf(extEnd));
                gr.setExtendedRegionSize(Integer.valueOf(extenedSize));
                gr.setMinusStrand(gr.getStart() > gr.getEnd());
                genomicRegionList.add(gr);
                continue;
            }
            throw new Exception("Not Dot-Dot format: " + original);
        }
        return genomicRegionList;
    }

    public static List<GenomicRegion> createGenomicRegionsFromString(Collection<String> regionStringList, String organism, Integer extendedRegionSize, Boolean isInterBaseCoordinate) {
        ArrayList<GenomicRegion> grList = new ArrayList<GenomicRegion>();
        for (String grStr : regionStringList) {
            String start;
            String[] spanItems;
            GenomicRegion aSpan = new GenomicRegion();
            aSpan.setOrganism(organism);
            if (extendedRegionSize != null) {
                aSpan.setExtendedRegionSize(extendedRegionSize);
            }
            if (DOT_DOT.matcher(grStr).find()) {
                aSpan.setChr(grStr.split(":")[0]);
                spanItems = grStr.split(":")[1].split("\\..");
                start = spanItems[0].trim();
                if (isInterBaseCoordinate.booleanValue()) {
                    aSpan.setStart(Integer.valueOf(start) + 1);
                } else {
                    aSpan.setStart(Integer.valueOf(start));
                }
                aSpan.setEnd(Integer.valueOf(spanItems[1]));
            } else if (BED.matcher(grStr).find()) {
                spanItems = grStr.split("\t");
                aSpan.setChr(spanItems[0]);
                if (isInterBaseCoordinate.booleanValue()) {
                    aSpan.setStart(Integer.valueOf(spanItems[1]) + 1);
                } else {
                    aSpan.setStart(Integer.valueOf(spanItems[1]));
                }
                aSpan.setEnd(Integer.valueOf(spanItems[2]));
            } else if (DASH.matcher(grStr).find()) {
                aSpan.setChr(grStr.split(":")[0]);
                spanItems = grStr.split(":")[1].split("-");
                start = spanItems[0].trim();
                if (isInterBaseCoordinate.booleanValue()) {
                    aSpan.setStart(Integer.valueOf(start) + 1);
                } else {
                    aSpan.setStart(Integer.valueOf(start));
                }
                aSpan.setEnd(Integer.valueOf(spanItems[1]));
            } else if (SINGLE_POS.matcher(grStr).find()) {
                aSpan.setChr(grStr.split(":")[0]);
                String start2 = grStr.split(":")[1].trim();
                if (isInterBaseCoordinate.booleanValue()) {
                    aSpan.setStart(Integer.valueOf(start2) + 1);
                } else {
                    aSpan.setStart(Integer.valueOf(start2));
                }
                aSpan.setEnd(Integer.valueOf(grStr.split(":")[1].trim()));
            } else {
                throw new IllegalArgumentException("Region string is in wrong format: " + grStr);
            }
            aSpan.setMinusStrand(aSpan.getStart() > aSpan.getEnd());
            grList.add(aSpan);
        }
        return grList;
    }

    public static List<GenomicRegion> groupGenomicRegionByInterval(String interval, Set<GenomicRegion> regionSet) throws Exception {
        Matcher m = DOT_DOT.matcher(interval);
        if (m.find()) {
            String chr = interval.split(":")[0];
            int start = Integer.valueOf(interval.split(":")[1].split("\\.{2}")[0]);
            int end = Integer.valueOf(interval.split(":")[1].split("\\.{2}")[1]);
            ArrayList<GenomicRegion> filteredList = new ArrayList<GenomicRegion>();
            for (GenomicRegion gr : regionSet) {
                if (!chr.equals(gr.getChr())) continue;
                if (gr.getExtendedRegionSize() > 0) {
                    if (gr.getExtendedStart() < start && gr.getExtendedEnd() < end && gr.getExtendedStart() > start && gr.getExtendedEnd() > end) continue;
                    filteredList.add(gr);
                    continue;
                }
                if (gr.getStart() < start && gr.getEnd() < end && gr.getStart() > start && gr.getEnd() > end) continue;
                filteredList.add(gr);
            }
            return filteredList;
        }
        throw new Exception("Not Dot-Dot format: " + interval);
    }
}

