/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.model;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.intermine.api.results.ExportResultsIterator;
import org.intermine.api.results.ResultElement;

public class GeneExpressionAtlasTissuesExpressions {
    private Map<String, ExpressionList> results;
    private ArrayList<String> expressionColumns = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("condition");
            this.add("expression");
            this.add("pValue");
            this.add("tStatistic");
            this.add("type");
        }
    };

    public Map<String, ExpressionList> getByName() {
        return this.results;
    }

    public Map<String, ExpressionList> getByTStatistic() {
        TreeMap<String, ExpressionList> n = new TreeMap<String, ExpressionList>(new ByTStatisticComparator());
        n.putAll(this.results);
        return n;
    }

    public Map<String, ExpressionList> getByPValue() {
        TreeMap<String, ExpressionList> n = new TreeMap<String, ExpressionList>(new ByPValueComparator());
        n.putAll(this.results);
        return n;
    }

    public GeneExpressionAtlasTissuesExpressions(ExportResultsIterator values) {
        this.results = new TreeMap<String, ExpressionList>(new CaseInsensitiveComparator());
        while (values.hasNext()) {
            ExpressionList listOfCellTypeExpressions;
            List valuesRow = values.next();
            HashMap<String, String> resultRow = new HashMap<String, String>();
            for (int i = 0; i < this.expressionColumns.size(); ++i) {
                resultRow.put(this.expressionColumns.get(i), ((ResultElement)valuesRow.get(i)).getField().toString());
            }
            String cellKey = (String)resultRow.get("condition");
            if (this.results.containsKey(cellKey)) {
                listOfCellTypeExpressions = this.results.get(cellKey);
            } else {
                listOfCellTypeExpressions = new ExpressionList();
                this.results.put(cellKey, listOfCellTypeExpressions);
            }
            listOfCellTypeExpressions.add(resultRow);
        }
    }

    public class ByPValueComparator
    implements Comparator<String> {
        @Override
        public int compare(String aK, String bK) {
            double bDouble;
            double aDouble = ((ExpressionList)GeneExpressionAtlasTissuesExpressions.this.results.get(aK)).pValue;
            if (aDouble < (bDouble = ((ExpressionList)GeneExpressionAtlasTissuesExpressions.this.results.get(bK)).pValue)) {
                return 1;
            }
            if (aDouble > bDouble) {
                return -1;
            }
            CaseInsensitiveComparator cic = new CaseInsensitiveComparator();
            return cic.compare(aK, bK);
        }
    }

    public class ByTStatisticComparator
    implements Comparator<String> {
        @Override
        public int compare(String aK, String bK) {
            ExpressionList aExpressions = (ExpressionList)GeneExpressionAtlasTissuesExpressions.this.results.get(aK);
            ExpressionList bExpressions = (ExpressionList)GeneExpressionAtlasTissuesExpressions.this.results.get(bK);
            if (aExpressions.tStatistic < bExpressions.tStatistic) {
                return 1;
            }
            if (aExpressions.tStatistic > bExpressions.tStatistic) {
                return -1;
            }
            CaseInsensitiveComparator cic = new CaseInsensitiveComparator();
            return cic.compare(aK, bK);
        }
    }

    public class CaseInsensitiveComparator
    implements Comparator<String> {
        @Override
        public int compare(String aK, String bK) {
            return aK.toLowerCase().compareTo(bK.toLowerCase());
        }
    }

    public class ExpressionList {
        private List<Map<String, String>> values = new ArrayList<Map<String, String>>();
        private float tStatistic = -1000.0f;
        private double pValue = 1.0;

        public void add(Map<String, String> resultRow) {
            this.updateTStatistic(resultRow.get("tStatistic"));
            this.updatePValue(resultRow.get("pValue"));
            this.values.add(resultRow);
        }

        public List<Map<String, String>> getValues() {
            return this.values;
        }

        private void updateTStatistic(String tStatistic) {
            Float f = new Float(tStatistic);
            if (f.floatValue() > this.tStatistic) {
                this.tStatistic = f.floatValue();
            }
        }

        private void updatePValue(String pValue) {
            double d = Double.parseDouble(pValue);
            if (d < this.pValue) {
                this.pValue = d;
            }
        }
    }
}

