/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.intermine.bio.web.model.GeneModel;
import org.intermine.bio.web.model.GeneModelSettings;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.ConstraintOp;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.Model;
import org.intermine.model.FastPathObject;
import org.intermine.model.InterMineObject;
import org.intermine.model.bio.Gene;
import org.intermine.model.bio.Organism;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.query.Constraint;
import org.intermine.objectstore.query.ConstraintSet;
import org.intermine.objectstore.query.ContainsConstraint;
import org.intermine.objectstore.query.FromElement;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryCollectionReference;
import org.intermine.objectstore.query.QueryEvaluable;
import org.intermine.objectstore.query.QueryField;
import org.intermine.objectstore.query.QueryObjectReference;
import org.intermine.objectstore.query.QueryReference;
import org.intermine.objectstore.query.QuerySelectable;
import org.intermine.objectstore.query.QueryValue;
import org.intermine.objectstore.query.Results;
import org.intermine.objectstore.query.SimpleConstraint;
import org.intermine.util.CacheMap;
import org.intermine.util.DynamicUtil;

public final class GeneModelCache {
    private static CacheMap<Integer, List<GeneModel>> cache = new CacheMap();
    protected static final Logger LOG = Logger.getLogger(GeneModelCache.class);
    private static Map<String, GeneModelSettings> organismSettings = new HashMap<String, GeneModelSettings>();

    private GeneModelCache() {
    }

    public static List<GeneModel> getGeneModels(InterMineObject object, Model model) {
        String clsName = DynamicUtil.getSimpleClass((FastPathObject)object).getSimpleName();
        Gene gene = null;
        if ("Gene".equals(clsName)) {
            gene = (Gene)object;
        } else if ("Transcript".equals(clsName) || "MRNA".equals(clsName) || "Exon".equals(clsName) || "UTR".equals(clsName) || "FivePrimeUTR".equals(clsName) || "ThreePrimeUTR".equals(clsName)) {
            try {
                gene = (Gene)object.getFieldValue("gene");
            }
            catch (IllegalAccessException e) {
                LOG.warn((Object)("Failed to get gene from " + clsName + ": " + object.getId()));
            }
        }
        return GeneModelCache.fetchGeneModels(gene, model);
    }

    protected static synchronized List<GeneModel> fetchGeneModels(Gene gene, Model model) {
        if (gene == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<GeneModel> geneModels = (ArrayList<GeneModel>)cache.get((Object)gene.getId());
        if (geneModels == null) {
            geneModels = new ArrayList<GeneModel>();
            try {
                Collection transcripts = (Collection)gene.getFieldValue("transcripts");
                for (InterMineObject transcript : transcripts) {
                    geneModels.add(new GeneModel(model, gene, transcript));
                }
                cache.put((Object)gene.getId(), geneModels);
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)("Error accessing transcripts collection for gene: " + gene.getPrimaryIdentifier() + ", " + gene.getId()));
            }
        }
        return geneModels;
    }

    public static GeneModelSettings getGeneModelOrganismSettings(String organismName, ObjectStore os) {
        if (!organismSettings.containsKey(organismName)) {
            GeneModelSettings settings = GeneModelCache.determineOrganismSettings(organismName, os);
            organismSettings.put(organismName, settings);
        }
        return organismSettings.get(organismName);
    }

    private static GeneModelSettings determineOrganismSettings(String organism, ObjectStore os) {
        GeneModelSettings settings = new GeneModelSettings(organism);
        Query query = new Query();
        ConstraintSet cs = new ConstraintSet(ConstraintOp.AND);
        query.setConstraint((Constraint)cs);
        QueryClass qcGene = new QueryClass(Gene.class);
        query.addFrom((FromElement)qcGene);
        QueryClass qcOrganism = new QueryClass(Organism.class);
        query.addFrom((FromElement)qcOrganism);
        QueryObjectReference orgRef = new QueryObjectReference(qcGene, "organism");
        QueryField qfOrgName = new QueryField(qcOrganism, "name");
        cs.addConstraint((Constraint)new SimpleConstraint((QueryEvaluable)qfOrgName, ConstraintOp.EQUALS, (QueryEvaluable)new QueryValue((Object)organism)));
        cs.addConstraint((Constraint)new ContainsConstraint((QueryReference)orgRef, ConstraintOp.CONTAINS, qcOrganism));
        query.addToSelect((QuerySelectable)new QueryValue((Object)"1"));
        settings.hasGenes = GeneModelCache.returnsResults(query, os);
        Model model = os.getModel();
        QueryClass qcTranscript = new QueryClass(model.getClassDescriptorByName("Transcript").getType());
        query.addFrom((FromElement)qcTranscript);
        QueryCollectionReference transcriptsCol = new QueryCollectionReference(qcGene, "transcripts");
        cs.addConstraint((Constraint)new ContainsConstraint((QueryReference)transcriptsCol, ConstraintOp.CONTAINS, qcTranscript));
        settings.hasTranscripts = GeneModelCache.returnsResults(query, os);
        settings.hasExons = GeneModelCache.doesTranscriptHave("Exon", "exons", qcTranscript, query, os);
        settings.hasIntrons = GeneModelCache.doesTranscriptHave("Intron", "introns", qcTranscript, query, os);
        settings.hasThreePrimeUTRs = GeneModelCache.doesTranscriptHave("ThreePrimeUTR", "threePrimeUTR", qcTranscript, query, os);
        settings.hasFivePrimeUTRs = GeneModelCache.doesTranscriptHave("FivePrimeUTR", "fivePrimeUTR", qcTranscript, query, os);
        settings.hasCDSs = GeneModelCache.doesTranscriptHave("CDS", "CDSs", qcTranscript, query, os);
        return settings;
    }

    private static boolean doesTranscriptHave(String clsName, String fieldName, QueryClass qcTranscript, Query q, ObjectStore os) {
        ClassDescriptor cldTranscript;
        FieldDescriptor fld;
        Model model = os.getModel();
        if (os.getModel().hasClassDescriptor(clsName) && (fld = (cldTranscript = model.getClassDescriptorByName(qcTranscript.getType().getName())).getFieldDescriptorByName(fieldName)) != null && !fld.isAttribute()) {
            QueryClass qcTarget = new QueryClass(model.getClassDescriptorByName(clsName).getType());
            q.addFrom((FromElement)qcTarget);
            ConstraintSet cs = (ConstraintSet)q.getConstraint();
            ContainsConstraint cc = null;
            if (fld.isReference()) {
                QueryObjectReference ref = new QueryObjectReference(qcTranscript, fieldName);
                cc = new ContainsConstraint((QueryReference)ref, ConstraintOp.CONTAINS, qcTarget);
                cs.addConstraint((Constraint)cc);
            } else if (fld.isCollection()) {
                QueryCollectionReference col = new QueryCollectionReference(qcTranscript, fieldName);
                cc = new ContainsConstraint((QueryReference)col, ConstraintOp.CONTAINS, qcTarget);
                ((ConstraintSet)q.getConstraint()).addConstraint((Constraint)cc);
            }
            boolean hasResults = GeneModelCache.returnsResults(q, os);
            q.setConstraint((Constraint)cs.removeConstraint(cc));
            q.deleteFrom((FromElement)qcTarget);
            return hasResults;
        }
        return false;
    }

    private static boolean returnsResults(Query q, ObjectStore os) {
        Results res = os.execute(q, 1, true, false, false);
        return res.iterator().hasNext();
    }

    public static Set<Integer> getGeneModelIds(InterMineObject object, Model model) {
        HashSet<Integer> geneModelIds = new HashSet<Integer>();
        for (GeneModel geneModel : GeneModelCache.getGeneModels(object, model)) {
            geneModelIds.addAll(geneModel.getIds());
        }
        return geneModelIds;
    }
}

