/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.webservice;

import java.util.List;
import java.util.Map;
import org.intermine.api.InterMineAPI;
import org.intermine.bio.web.export.SequenceExporter;
import org.intermine.bio.web.logic.SequenceFeatureExportUtil;
import org.intermine.bio.webservice.AbstractRegionExportService;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.logic.export.Exporter;
import org.intermine.webservice.server.exceptions.BadRequestException;

public class GenomicRegionFastaService
extends AbstractRegionExportService {
    protected static final String SUFFIX = ".fasta";

    public GenomicRegionFastaService(InterMineAPI im) {
        super(im);
    }

    @Override
    protected String getContentType() {
        return "text/x-fasta";
    }

    @Override
    protected Exporter getExporter(PathQuery pq) {
        return new SequenceExporter(this.im.getObjectStore(), this.getOutputStream(), 0, (Map<String, List<FieldDescriptor>>)this.im.getClassKeys(), 0, "n");
    }

    @Override
    protected String getSuffix() {
        return SUFFIX;
    }

    @Override
    protected void checkPathQuery(PathQuery pq) throws Exception {
        try {
            SequenceFeatureExportUtil.isValidFastaQuery(pq);
        }
        catch (SequenceFeatureExportUtil.InvalidQueryException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
    }
}

