/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.struts;

import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.intermine.api.InterMineAPI;
import org.intermine.metadata.Model;
import org.intermine.pathquery.PathQuery;
import org.intermine.pathquery.PathQueryBinding;
import org.intermine.web.logic.results.PagedTable;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.InterMineAction;
import org.intermine.web.util.URLGenerator;

public class GalaxyExportAction
extends InterMineAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)session);
        Model model = im.getModel();
        String tableName = request.getParameter("tableName");
        PagedTable pt = SessionMethods.getResultsTable((HttpSession)session, (String)tableName);
        PathQuery query = pt.getWebTable().getPathQuery();
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        String prefix = request.getParameter("prefix");
        ArrayList<String> newView = new ArrayList<String>();
        newView.add(prefix + ".chromosome.primaryIdentifier");
        newView.add(prefix + ".chromosomeLocation.start");
        newView.add(prefix + ".chromosomeLocation.end");
        newView.add(prefix + ".primaryIdentifier");
        newView.add(prefix + ".score");
        newView.add(prefix + ".chromosomeLocation.strand");
        query.addViews(newView);
        String queryXML = PathQueryBinding.marshal((PathQuery)query, (String)"tmpName", (String)model.getName(), (int)2);
        String encodedQueryXML = URLEncoder.encode(queryXML, "UTF-8");
        StringBuffer stringUrl = new StringBuffer(new URLGenerator(request).getPermanentBaseURL() + "/service/query/results?query=" + encodedQueryXML + "&size=1000000");
        StringBuffer returnString = new StringBuffer();
        returnString.append(stringUrl);
        out.println(returnString.toString());
        out.flush();
        out.close();
        return null;
    }
}

