/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.BagManager;
import org.intermine.api.config.ClassKeyHelper;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.api.types.ClassKeys;
import org.intermine.metadata.AttributeDescriptor;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.ConstraintOp;
import org.intermine.metadata.Model;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.query.BagConstraint;
import org.intermine.objectstore.query.Constraint;
import org.intermine.objectstore.query.ConstraintSet;
import org.intermine.objectstore.query.FromElement;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryEvaluable;
import org.intermine.objectstore.query.QueryField;
import org.intermine.objectstore.query.QueryNode;
import org.intermine.objectstore.query.QuerySelectable;
import org.intermine.objectstore.query.QueryValue;
import org.intermine.objectstore.query.Results;
import org.intermine.objectstore.query.ResultsRow;
import org.intermine.objectstore.query.SimpleConstraint;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.FindInListForm;
import org.intermine.web.struts.ForwardParameters;
import org.intermine.web.struts.InterMineAction;

public class FindInListAction
extends InterMineAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)session);
        FindInListForm qsf = (FindInListForm)form;
        String textToFind = qsf.getTextToFind().trim();
        String bagName = qsf.getBagName();
        Profile profile = SessionMethods.getProfile((HttpSession)session);
        BagManager bagManager = im.getBagManager();
        InterMineBag bag = bagManager.getBag(profile, bagName);
        ForwardParameters forwardParameters = new ForwardParameters(mapping.findForward("bagDetails"));
        forwardParameters.addParameter("name", bagName);
        if (bag != null) {
            ClassKeys classKeys = im.getClassKeys();
            ObjectStore os = im.getObjectStore();
            String bagQualifiedType = bag.getQualifiedType();
            List keyFields = ClassKeyHelper.getKeyFieldNames((Map)classKeys, (String)bagQualifiedType);
            int foundId = -1;
            if (keyFields.size() > 0) {
                Query q = this.makeQuery(textToFind, bag, (Collection)keyFields, os.getModel());
                foundId = this.findFirst(os, q);
            }
            if (foundId == -1) {
                List allStringFields = this.getStringFields(os.getModel(), bagQualifiedType);
                Query q = this.makeQuery(textToFind, bag, (Collection)allStringFields, os.getModel());
                foundId = this.findFirst(os, q);
            }
            if (foundId == -1) {
                SessionMethods.recordMessage((String)("Cannot find \"" + textToFind + "\" in " + bagName), (HttpSession)session);
                forwardParameters.addParameter("foundItem", "false");
            } else {
                forwardParameters.addParameter("highlightId", foundId + "");
                forwardParameters.addParameter("gotoHighlighted", "true");
            }
        }
        return forwardParameters.forward();
    }

    private List<String> getStringFields(Model model, String bagQualifiedType) {
        ArrayList<String> retList = new ArrayList<String>();
        ClassDescriptor cd = model.getClassDescriptorByName(bagQualifiedType);
        for (AttributeDescriptor ad : cd.getAllAttributeDescriptors()) {
            if (!ad.getType().equals(String.class.getName())) continue;
            retList.add(ad.getName());
        }
        return retList;
    }

    private Query makeQuery(String searchTerm, InterMineBag bag, Collection<String> identifierFieldNames, Model model) {
        QueryClass qc;
        String bagClassName = bag.getQualifiedType();
        ClassDescriptor cd = model.getClassDescriptorByName(bagClassName);
        Query q = new Query();
        try {
            qc = new QueryClass(new Class[]{Class.forName(bagClassName)});
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("class not found", e);
        }
        QueryField idQF = new QueryField(qc, "id");
        ConstraintSet cs = new ConstraintSet(ConstraintOp.AND);
        q.addFrom((FromElement)qc);
        q.addToSelect((QuerySelectable)idQF);
        BagConstraint bagConstraint = new BagConstraint((QueryNode)idQF, ConstraintOp.IN, bag.getOsb());
        cs.addConstraint((Constraint)bagConstraint);
        ConstraintSet fieldCS = new ConstraintSet(ConstraintOp.OR);
        for (String fieldName : identifierFieldNames) {
            QueryValue queryValue;
            QueryField qf;
            block9: {
                qf = new QueryField(qc, fieldName);
                AttributeDescriptor attDesc = cd.getAttributeDescriptorByName(fieldName, true);
                String attType = attDesc.getType();
                if ("java.lang.Integer".equals(attType)) {
                    try {
                        Integer intSearchTerm = Integer.valueOf(searchTerm);
                        queryValue = new QueryValue((Object)intSearchTerm);
                        break block9;
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                }
                if ("java.lang.Long".equals(attType)) {
                    try {
                        Long longSearchTerm = Long.valueOf(searchTerm);
                        queryValue = new QueryValue((Object)longSearchTerm);
                        break block9;
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                }
                if (!"java.lang.String".equals(attType)) continue;
                queryValue = new QueryValue((Object)searchTerm);
            }
            SimpleConstraint sc = new SimpleConstraint((QueryEvaluable)qf, ConstraintOp.EQUALS, (QueryEvaluable)queryValue);
            fieldCS.addConstraint((Constraint)sc);
        }
        cs.addConstraint((Constraint)fieldCS);
        q.setConstraint((Constraint)cs);
        return q;
    }

    private int findFirst(ObjectStore os, Query q) {
        Results res = os.execute(q);
        try {
            return (Integer)((ResultsRow)res.get(0)).get(0);
        }
        catch (IndexOutOfBoundsException e) {
            return -1;
        }
    }
}

