/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.actions.TilesAction;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.api.searchengine.KeywordSearchFacetData;
import org.intermine.api.searchengine.KeywordSearchPropertiesManager;
import org.intermine.api.searchengine.KeywordSearchResults;
import org.intermine.api.searchengine.solr.SolrKeywordSearchHandler;
import org.intermine.objectstore.ObjectStore;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.search.SearchUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class KeywordSearchResultsController
extends TilesAction {
    private static final String QUERY_TERM_ALL = "*:*";
    private static final Logger LOG = Logger.getLogger(KeywordSearchResultsController.class);
    private static Logger searchLog = null;

    public ActionForward execute(ComponentContext context, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String searchTerm = request.getParameter("searchTerm");
        LOG.debug((Object)("SEARCH TERM: '" + searchTerm + "'"));
        if (StringUtils.isBlank((String)searchTerm)) {
            return null;
        }
        long time = System.currentTimeMillis();
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)request.getSession());
        ServletContext servletContext = request.getSession().getServletContext();
        String contextPath = servletContext.getRealPath("/");
        Vector facets = KeywordSearchPropertiesManager.getInstance((ObjectStore)im.getObjectStore()).getFacets();
        int totalHits = 0;
        Profile profile = SessionMethods.getProfile((HttpSession)request.getSession());
        im.getTrackerDelegate().trackKeywordSearch(searchTerm, profile, request.getSession().getId());
        WebConfig wc = SessionMethods.getWebConfig((HttpServletRequest)request);
        String searchBag = request.getParameter("searchBag");
        if (searchBag == null) {
            searchBag = "";
        }
        List ids = this.getBagIds(im, request, searchBag);
        int offset = this.getOffset(request);
        Map facetValues = this.getFacetValues(request, facets);
        LOG.debug((Object)("Initializing took " + (System.currentTimeMillis() - time) + " ms"));
        long searchTime = System.currentTimeMillis();
        SolrKeywordSearchHandler keywordSearchHandler = new SolrKeywordSearchHandler();
        KeywordSearchResults results = keywordSearchHandler.doKeywordSearch(im, searchTerm, facetValues, ids, offset);
        Collection searchResultsParsed = SearchUtils.parseResults((InterMineAPI)im, (WebConfig)wc, (Collection)results.getHits());
        Collection searchResultsFacets = results.getFacets();
        totalHits = results.getTotalHits();
        LOG.debug((Object)("SEARCH RESULTS FOR " + searchTerm + ": " + totalHits));
        if (QUERY_TERM_ALL.equals(searchTerm)) {
            searchTerm = "";
        }
        request.setAttribute("searchResults", (Object)searchResultsParsed);
        request.setAttribute("searchTerm", (Object)searchTerm);
        request.setAttribute("searchBag", (Object)searchBag);
        request.setAttribute("searchFacetValues", (Object)facetValues);
        request.setAttribute("jsonFacets", (Object)this.javaMapToJSON(facetValues));
        context.putAttribute("searchResults", request.getAttribute("searchResults"));
        context.putAttribute("searchTerm", request.getAttribute("searchTerm"));
        context.putAttribute("searchBag", request.getAttribute("searchBag"));
        context.putAttribute("searchFacetValues", request.getAttribute("searchFacetValues"));
        context.putAttribute("jsonFacets", request.getAttribute("jsonFacets"));
        context.putAttribute("searchOffset", (Object)offset);
        context.putAttribute("searchPerPage", (Object)100);
        context.putAttribute("searchTotalHits", (Object)totalHits);
        context.putAttribute("searchFacets", (Object)searchResultsFacets);
        for (Map.Entry facetValue : facetValues.entrySet()) {
            context.putAttribute("facet_" + (String)facetValue.getKey(), facetValue.getValue());
        }
        long totalTime = System.currentTimeMillis() - time;
        context.putAttribute("searchTime", (Object)new Long(totalTime));
        LOG.debug((Object)("--> TOTAL: " + (System.currentTimeMillis() - time) + " ms"));
        return null;
    }

    private int getOffset(HttpServletRequest request) {
        Integer offset = new Integer(0);
        try {
            if (!StringUtils.isBlank((String)request.getParameter("searchOffset"))) {
                offset = Integer.valueOf(request.getParameter("searchOffset"));
            }
        }
        catch (NumberFormatException e) {
            LOG.info((Object)"invalid offset", (Throwable)e);
        }
        LOG.debug((Object)("SEARCH OFFSET: " + offset + ""));
        return offset;
    }

    private List<Integer> getBagIds(InterMineAPI im, HttpServletRequest request, String searchBag) {
        List<Integer> ids = new ArrayList<Integer>();
        if (!StringUtils.isEmpty((String)searchBag)) {
            LOG.debug((Object)("SEARCH BAG: '" + searchBag + "'"));
            InterMineBag bag = im.getBagManager().getBag(SessionMethods.getProfile((HttpSession)request.getSession()), searchBag);
            if (bag != null) {
                ids = bag.getContentsAsIds();
                LOG.debug((Object)("SEARCH LIST: " + Arrays.toString(ids.toArray()) + ""));
            }
        }
        return ids;
    }

    private Map<String, String> getFacetValues(HttpServletRequest request, Vector<KeywordSearchFacetData> facets) {
        HashMap<String, String> facetValues = new HashMap<String, String>();
        if (StringUtils.isBlank((String)request.getParameter("searchSubmit")) || !StringUtils.isBlank((String)request.getParameter("searchSubmitRestricted"))) {
            for (Map.Entry entry : request.getParameterMap().entrySet()) {
                if (!((String)entry.getKey()).startsWith("facet_") || ((String[])entry.getValue()).length <= 0 || StringUtils.isBlank((String)((String[])entry.getValue())[0])) continue;
                String facetField = ((String)entry.getKey()).substring("facet_".length());
                boolean found = false;
                for (KeywordSearchFacetData keywordSearchFacetData : facets) {
                    if (!facetField.equals(keywordSearchFacetData.getField())) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                facetValues.put(facetField, ((String[])entry.getValue())[0]);
            }
            for (Map.Entry<Object, Object> entry : facetValues.entrySet()) {
                LOG.debug((Object)("SEARCH FACET: " + (String)entry.getKey() + " = " + (String)entry.getValue()));
            }
        }
        return facetValues;
    }

    private JSONObject javaMapToJSON(Map<String, String> facets) throws JSONException {
        JSONObject jo = new JSONObject();
        JSONArray ja = new JSONArray();
        for (Map.Entry<String, String> entry : facets.entrySet()) {
            JSONObject facet = new JSONObject();
            facet.put("facetName", (Object)entry.getKey());
            facet.put("facetValue", (Object)entry.getValue());
            ja.put((Object)facet);
        }
        jo.put("facets", (Object)ja);
        return jo;
    }
}

