/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.actions.TilesAction;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.SavedQuery;
import org.intermine.api.template.ApiTemplate;
import org.intermine.api.template.TemplateManager;
import org.intermine.metadata.Model;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathConstraintBag;
import org.intermine.pathquery.PathConstraintMultiValue;
import org.intermine.pathquery.PathConstraintNull;
import org.intermine.pathquery.PathException;
import org.intermine.pathquery.PathQuery;
import org.intermine.template.TemplateQuery;
import org.intermine.web.autocompletion.AutoCompleter;
import org.intermine.web.logic.query.DisplayConstraint;
import org.intermine.web.logic.query.DisplayConstraintFactory;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.TemplateForm;

public class TemplateController
extends TilesAction {
    public ActionForward execute(ComponentContext context, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)session);
        Profile profile = SessionMethods.getProfile((HttpSession)session);
        TemplateManager templateManager = im.getTemplateManager();
        String templateName = request.getParameter("name");
        String scope = request.getParameter("scope");
        String loadModifiedTemplate = request.getParameter("loadModifiedTemplate");
        TemplateForm tf = (TemplateForm)form;
        tf.setScope(scope);
        TemplateQuery modifiedTemplate = null;
        TemplateQuery template = null;
        ApiTemplate originalTemplate = null;
        if (loadModifiedTemplate != null) {
            String savedQueryName = request.getParameter("savedQueryName");
            if (savedQueryName != null) {
                modifiedTemplate = this.getHistoryTemplate(session, savedQueryName);
            } else {
                PathQuery query = SessionMethods.getQuery((HttpSession)session);
                if (query instanceof TemplateQuery) {
                    modifiedTemplate = (TemplateQuery)query;
                }
            }
            templateName = modifiedTemplate.getName();
            template = modifiedTemplate;
            if (scope == null) {
                scope = "all";
            }
            originalTemplate = templateManager.getTemplate(profile, templateName, scope);
        }
        if (context.getAttribute("builder") != null || session.getAttribute("NEW_TEMPLATE") != null) {
            template = (TemplateQuery)SessionMethods.getQuery((HttpSession)session);
        }
        if (template == null) {
            if (scope == null) {
                scope = "all";
            }
            template = templateManager.getTemplate(profile, templateName, scope);
        }
        TemplateQuery displayTemplate = null;
        if (template == null) {
            ActionMessages actionMessages = this.getErrors(request);
            actionMessages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("errors.template.missing", (Object)templateName));
            this.saveErrors(request, actionMessages);
            request.setAttribute("templateQuery", (Object)displayTemplate);
            return null;
        }
        ArrayList<DisplayConstraint> displayConstraintList = new ArrayList<DisplayConstraint>();
        displayTemplate = template.clone();
        DisplayConstraintFactory factory = this.getFactory(session);
        int index = 0;
        DisplayConstraint displayConstraint = null;
        for (PathConstraint pathConstraint : template.getEditableConstraints()) {
            if (loadModifiedTemplate != null && pathConstraint instanceof PathConstraintBag) {
                String code = (String)template.getConstraints().get(pathConstraint);
                PathConstraint originalPathConstraint = originalTemplate.getConstraintForCode(code);
                displayConstraint = factory.get(originalPathConstraint, profile, (PathQuery)originalTemplate);
                displayConstraint.setSwitchOffAbility(template.getSwitchOffAbility(pathConstraint));
                displayConstraint.setBagSelected(true);
                displayConstraint.setSelectedBagOp(pathConstraint.getOp());
                displayConstraint.setSelectedBagValue(((PathConstraintBag)pathConstraint).getBag());
            } else {
                displayConstraint = factory.get(pathConstraint, profile, (PathQuery)template);
            }
            displayConstraintList.add(displayConstraint);
            if (displayConstraint.isBoolean()) {
                if (!displayConstraint.isBagSelected()) {
                    tf.setAttributeValues("" + (index + 1), (Object)displayConstraint.getSelectedValue());
                } else {
                    tf.setAttributeValues("" + (index + 1), (Object)displayConstraint.getOriginalValue());
                }
            }
            if (pathConstraint instanceof PathConstraintNull) {
                tf.setNullConstraint("" + (index + 1), displayConstraint.getSelectedValue());
            }
            if (pathConstraint instanceof PathConstraintBag) {
                tf.setUseBagConstraint("" + (index + 1), displayConstraint.isBagSelected());
            }
            if (pathConstraint instanceof PathConstraintMultiValue) {
                Collection selectedValues = displayConstraint.getMultiValues();
                String[] multiSelecteValue = new String[selectedValues.size()];
                int multiValueIndex = 0;
                for (String selectedvalue : selectedValues) {
                    multiSelecteValue[multiValueIndex++] = selectedvalue;
                }
                tf.setMultiValues("" + (index + 1), multiSelecteValue);
            }
            ++index;
        }
        this.verifyDisplayExtraValue(displayConstraintList, template);
        request.setAttribute("dcl", displayConstraintList);
        request.setAttribute("templateQuery", (Object)displayTemplate);
        String constraintLogic = template.getConstraintLogicForEditableConstraints();
        if (constraintLogic.contains("or") || constraintLogic.contains("not")) {
            request.setAttribute("displayLogicExpression", (Object)"true");
        }
        if (profile.getSavedTemplates().get(displayTemplate.getName()) != null) {
            request.setAttribute("IS_OWNER", (Object)true);
        }
        return null;
    }

    private TemplateQuery getHistoryTemplate(HttpSession session, String templateName) {
        Profile profile = SessionMethods.getProfile((HttpSession)session);
        SavedQuery savedQuery = (SavedQuery)profile.getHistory().get(templateName);
        TemplateQuery template = null;
        if (savedQuery != null && savedQuery.getPathQuery() instanceof TemplateQuery) {
            template = (TemplateQuery)savedQuery.getPathQuery();
        }
        return template;
    }

    private DisplayConstraintFactory getFactory(HttpSession session) {
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)session);
        AutoCompleter ac = SessionMethods.getAutoCompleter((ServletContext)session.getServletContext());
        DisplayConstraintFactory factory = new DisplayConstraintFactory(im, ac);
        return factory;
    }

    private void verifyDisplayExtraValue(List<DisplayConstraint> displayConstraintList, TemplateQuery template) {
        Set pathConstraints = template.getConstraints().keySet();
        Model model = template.getModel();
        for (DisplayConstraint dc : displayConstraintList) {
            if (!dc.isExtraConstraint()) continue;
            String mainPath = dc.getPath().getPath().toStringNoConstraints();
            String connectField = dc.getExtraConnectFieldPath();
            for (PathConstraint pathConstraint : pathConstraints) {
                String path = pathConstraint.getPath();
                if (mainPath.equals(path)) continue;
                try {
                    if (!path.equals(connectField) && (!path.startsWith(connectField) || connectField.split("\\.").length != path.split("\\.").length - 1 || !new Path(model, path).endIsAttribute())) continue;
                    dc.setShowExtraConstraint(false);
                }
                catch (PathException pathException) {}
            }
        }
    }
}

