/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.tags.disclosure;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import org.intermine.web.logic.results.WebState;
import org.intermine.web.tags.disclosure.BaseDisclosureTag;

public class DisclosureTag
extends BaseDisclosureTag {
    private static final String DEFAULT_STYLE_CLASS = "disclosure";
    private static final String CONSISTENT = "consistent";
    private String id;
    private boolean opened = true;
    private String onClick;
    private String type = "simple";

    public String getType() {
        return this.type.toLowerCase();
    }

    public void setType(String type) {
        this.type = type;
    }

    protected String getDefaultStyleClass() {
        return DEFAULT_STYLE_CLASS;
    }

    public String getOnClick() {
        return this.onClick;
    }

    public void setOnClick(String onChange) {
        this.onClick = onChange;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public boolean getOpened() {
        Boolean ret;
        WebState webState;
        if (this.isConsistentType() && (webState = (WebState)this.getJspContext().getAttribute("WEB_STATE", 3)) != null && (ret = (Boolean)webState.getToggledElements().get(this.getId())) != null) {
            return ret;
        }
        return this.opened;
    }

    public boolean isConsistentType() {
        return this.getType().equals(CONSISTENT);
    }

    public void setOpened(boolean opened) {
        this.opened = opened;
    }

    public void doTag() throws JspException, IOException {
        JspWriter out = this.getJspContext().getOut();
        out.write("<div");
        this.printStyleAndClass(out);
        out.write(">");
        this.getJspBody().invoke(null);
        if (!this.getOpened()) {
            this.printJavascriptHides(out);
        }
        out.write("</div>");
    }

    private void printJavascriptHides(JspWriter out) throws IOException {
        out.write("<script type=\"text/javascript\">toggleHidden('");
        out.write(this.getId());
        out.write("')</script>");
    }

    public String getLink() {
        StringBuilder sb = new StringBuilder();
        sb.append("javascript:toggleHidden('");
        sb.append(this.getId());
        sb.append("');");
        if (this.isConsistentType()) {
            sb.append("saveToggleState('");
            sb.append(this.getId());
            sb.append("');");
        }
        if (this.getOnClick() != null) {
            sb.append(this.getOnClick());
            sb.append(";");
        }
        return sb.toString();
    }
}

