/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.intermine.api.InterMineAPI;
import org.intermine.api.types.ClassKeys;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.Model;
import org.intermine.webservice.server.SummaryService;
import org.intermine.webservice.server.exceptions.ServiceException;
import org.json.JSONObject;

public class ClassKeysService
extends SummaryService {
    public ClassKeysService(InterMineAPI im) {
        super(im);
    }

    protected void execute() throws Exception {
        ClassKeys classKeys = this.im.getClassKeys();
        if (classKeys == null) {
            throw new ServiceException("class keys unavailable");
        }
        HashMap ckData = new HashMap();
        Model m = this.im.getModel();
        this.output.setHeaderAttributes(this.getHeaderAttributes());
        for (ClassDescriptor cd : m.getClassDescriptors()) {
            ArrayList<String> keyFields = new ArrayList<String>();
            String cname = cd.getUnqualifiedName();
            if ("InterMineObject".equals(cname) || !classKeys.containsKey(cname)) continue;
            for (FieldDescriptor fd : (List)classKeys.get(cname)) {
                keyFields.add(cname + "." + fd.getName());
            }
            ckData.put(cname, keyFields);
        }
        JSONObject jo = new JSONObject(ckData);
        this.output.addResultItem(Collections.singletonList(jo.toString()));
    }
}

