/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.bg;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Reader;
import java.net.URLDecoder;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.intermine.api.InterMineAPI;
import org.intermine.modelproduction.MetadataManager;
import org.intermine.objectstore.ObjectStoreWriter;
import org.intermine.objectstore.intermine.ObjectStoreInterMineImpl;
import org.intermine.sql.Database;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.exceptions.ResourceNotFoundException;
import org.intermine.webservice.server.exceptions.ServiceForbiddenException;

public class BGPropertiesUpdateService
extends JSONService {
    public BGPropertiesUpdateService(InterMineAPI im) {
        super(im);
    }

    protected void execute() throws Exception {
        if (!this.getPermission().getProfile().isSuperuser()) {
            throw new ServiceForbiddenException("Only admins users can access this service");
        }
        String body = IOUtils.toString((Reader)this.request.getReader());
        String key = null;
        String value = null;
        if (!StringUtils.isEmpty((String)body)) {
            String[] input = this.parseInput(URLDecoder.decode(body, "UTF-8"));
            key = input[0];
            value = input[1];
        }
        if (StringUtils.isEmpty(key) || StringUtils.isEmpty(value)) {
            key = this.getRequiredParameter("key");
            value = this.getRequiredParameter("value");
        }
        ObjectStoreWriter uosw = this.im.getProfileManager().getProfileObjectStoreWriter();
        String bgPropsAsString = MetadataManager.retrieve((Database)((ObjectStoreInterMineImpl)uosw).getDatabase(), (String)"bgProperties");
        ObjectMapper mapper = new ObjectMapper();
        if (bgPropsAsString == null) {
            throw new ResourceNotFoundException("A property with key " + key + " doesn't exists.");
        }
        HashMap bgMap = (HashMap)mapper.readValue(bgPropsAsString, HashMap.class);
        if (!bgMap.containsKey(key)) {
            throw new ResourceNotFoundException("A property with key " + key + " doesn't exists.");
        }
        bgMap.put(key, value);
        MetadataManager.store((Database)((ObjectStoreInterMineImpl)uosw).getDatabase(), (String)"bgProperties", (String)mapper.writeValueAsString((Object)bgMap));
    }

    private String[] parseInput(String input) {
        String key = "";
        String value = "";
        String[] keyValuePairs = StringUtils.split((String)input, (String)"&");
        for (int index = 0; index < keyValuePairs.length; ++index) {
            String[] keyValuePair = StringUtils.split((String)keyValuePairs[index], (String)"=");
            if (keyValuePair[0].equalsIgnoreCase("key")) {
                key = keyValuePair[1];
                continue;
            }
            if (!keyValuePair[0].equalsIgnoreCase("value")) continue;
            value = keyValuePair[1];
        }
        return new String[]{key, value};
    }
}

