/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.api.results.ResultCell;
import org.intermine.objectstore.query.PathExpressionField;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryCollectionPathExpression;
import org.intermine.objectstore.query.QueryObjectPathExpression;
import org.intermine.objectstore.query.QuerySelectable;
import org.intermine.objectstore.query.Results;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathException;
import org.intermine.pathquery.PathQuery;
import org.intermine.webservice.server.core.DisjointList;
import org.intermine.webservice.server.core.DisjointRecursiveList;
import org.intermine.webservice.server.core.Either;
import org.intermine.webservice.server.core.EitherVisitor;
import org.intermine.webservice.server.core.Page;
import org.intermine.webservice.server.core.SubTable;
import org.intermine.webservice.server.core.TableRowIterator;
import org.intermine.webservice.server.exceptions.NotImplementedException;

public class TableRowIterator
implements Iterator<List<Either<ResultCell, SubTable>>>,
Iterable<List<Either<ResultCell, SubTable>>> {
    private static final String EXPECTED_SUBTABLE = "Expected this result element to be a subtable of the form %s, but was %s";
    private static final String NOT_INTERMINE_OBJECT = "Table row iteration only supported over InterMine Objects, not %s instances. Got %s";
    private static final Logger LOG = Logger.getLogger(TableRowIterator.class);
    private final PathQuery pathQuery;
    private final Query query;
    private final Results results;
    private final Map<String, QuerySelectable> nodeForPath = new HashMap();
    private final List<Path> paths = new ArrayList();
    private final Page page;
    private final InterMineAPI im;
    private DisjointRecursiveList<List<Path>> resultsShape;
    private final List<Path> effectiveView = new ArrayList();
    private int counter = 0;
    private Path root;
    private Iterator<Object> osIter;
    private Map<DisjointRecursiveList<List<Path>>, Path> levels;
    private static final EitherVisitor<ResultCell, SubTable, Path> PATH_GETTER = new /* Unavailable Anonymous Inner Class!! */;
    private Comparator<Either<ResultCell, SubTable>> reorderer;
    private Comparator<Either<Path, DisjointRecursiveList<Path>>> pathReorderer;

    public TableRowIterator(PathQuery pathQuery, Query query, Results results, Map<String, QuerySelectable> nodeForPath, Page page, InterMineAPI im) {
        this.page = page;
        this.query = query;
        this.pathQuery = pathQuery;
        this.results = results;
        this.nodeForPath.putAll(nodeForPath);
        this.im = im;
        try {
            this.init();
        }
        catch (PathException e) {
            throw new RuntimeException("Failed to initialise", e);
        }
    }

    private void init() throws PathException {
        this.osIter = this.results.iteratorFrom(this.page.getStart());
        this.counter = this.page.getStart();
        this.root = this.pathQuery.makePath(this.pathQuery.getRootClass());
        for (String view : this.pathQuery.getView()) {
            this.paths.add(this.pathQuery.makePath(view));
        }
        ColumnConversionInput cci = new ColumnConversionInput(this, null);
        cci.paths = this.paths;
        cci.pathToQueryNode = this.nodeForPath;
        cci.select = new ArrayList(this.query.getSelect());
        this.resultsShape = this.determineResultShape(cci);
        this.levels = this.getLevelMap(this.resultsShape);
        this.levels.put(this.resultsShape, this.root);
        this.reorderer = new /* Unavailable Anonymous Inner Class!! */;
        this.pathReorderer = new /* Unavailable Anonymous Inner Class!! */;
        this.effectiveView.addAll(this.determineEffectiveView());
    }

    public List<Path> getEffectiveView() {
        return Collections.unmodifiableList(this.effectiveView);
    }

    private DisjointRecursiveList<Path> consolidateLevels(DisjointRecursiveList<List<Path>> shape) {
        DisjointRecursiveList consolidated = new DisjointRecursiveList();
        shape.forEach((EitherVisitor)new /* Unavailable Anonymous Inner Class!! */);
        return consolidated;
    }

    private void orderListOnEachLevel(DisjointRecursiveList<Path> consolidated) {
        consolidated.forEach((EitherVisitor)new /* Unavailable Anonymous Inner Class!! */);
        Collections.sort(consolidated.items, this.pathReorderer);
    }

    private List<Path> determineEffectiveView() {
        DisjointRecursiveList consolidated = this.consolidateLevels(this.resultsShape);
        this.orderListOnEachLevel(consolidated);
        return consolidated.flatten();
    }

    private Map<DisjointRecursiveList<List<Path>>, Path> getLevelMap(DisjointRecursiveList<List<Path>> shape) {
        HashMap<DisjointRecursiveList<List<Path>>, Path> retVal = new HashMap<DisjointRecursiveList<List<Path>>, Path>();
        this.determineLevels(shape, retVal);
        return retVal;
    }

    private Path determineLevels(DisjointRecursiveList<List<Path>> shape, Map<DisjointRecursiveList<List<Path>>, Path> shapeToLevel) {
        HashSet pathsAtThisLevel = new HashSet();
        ArrayList pathsBelowThisLevel = new ArrayList();
        if (shape.items.isEmpty()) {
            return null;
        }
        shape.forEach((EitherVisitor)new /* Unavailable Anonymous Inner Class!! */);
        Path retVal = null;
        try {
            if (!pathsAtThisLevel.isEmpty()) {
                Path oneOfThisLevel = (Path)pathsAtThisLevel.iterator().next();
                retVal = this.getOJG(oneOfThisLevel);
            } else if (!pathsBelowThisLevel.isEmpty()) {
                Path oneBelowThisLevel = (Path)pathsBelowThisLevel.iterator().next();
                retVal = this.getOJG(oneBelowThisLevel.getPrefix());
            } else {
                throw new RuntimeException("no paths found in this shape: " + shape);
            }
            while (!retVal.endIsCollection() && !retVal.isRootPath()) {
                retVal = this.getOJG(retVal.getPrefix());
            }
        }
        catch (PathException e) {
            throw new RuntimeException("This should never have happened.", e);
        }
        shapeToLevel.put(shape, retVal);
        return retVal;
    }

    private Path getOJG(Path somePath) throws PathException {
        return this.pathQuery.makePath(this.pathQuery.getOuterJoinGroup(somePath.getNoConstraintsString()));
    }

    private DisjointRecursiveList<List<Path>> determineResultShape(ColumnConversionInput cci) {
        DisjointRecursiveList retval = new DisjointRecursiveList();
        for (QuerySelectable qs : cci.select) {
            List subSelect;
            boolean done = false;
            while (!done) {
                if (qs instanceof QueryObjectPathExpression) {
                    QueryObjectPathExpression qope = (QueryObjectPathExpression)qs;
                    subSelect = qope.getSelect();
                    if (!subSelect.isEmpty()) {
                        qs = (QuerySelectable)subSelect.get(0);
                        if (!qs.equals(qope.getDefaultClass())) continue;
                        qs = qope;
                        done = true;
                        continue;
                    }
                    done = true;
                    continue;
                }
                if (qs instanceof PathExpressionField) {
                    PathExpressionField pef = (PathExpressionField)qs;
                    QueryObjectPathExpression qope = pef.getQope();
                    if (!(qs = (QuerySelectable)qope.getSelect().get(pef.getFieldNumber())).equals(qope.getDefaultClass())) continue;
                    qs = qope;
                    done = true;
                    continue;
                }
                done = true;
            }
            if (qs instanceof QueryCollectionPathExpression) {
                QueryCollectionPathExpression qc = (QueryCollectionPathExpression)qs;
                subSelect = qc.getSelect();
                if (subSelect.isEmpty()) {
                    subSelect = Collections.singletonList(qc.getDefaultClass());
                }
                retval.addList(this.determineResultShape(cci.getNextLevelInput(subSelect)));
                continue;
            }
            LinkedList<Path> fieldsForObject = new LinkedList<Path>();
            for (Path path : cci.paths) {
                Path parent = path.getPrefix();
                QuerySelectable selectableForPath = (QuerySelectable)cci.pathToQueryNode.get(parent.toStringNoConstraints());
                if (selectableForPath instanceof QueryCollectionPathExpression) {
                    selectableForPath = ((QueryCollectionPathExpression)selectableForPath).getDefaultClass();
                }
                if (!qs.equals(selectableForPath)) continue;
                fieldsForObject.add(path);
            }
            if (fieldsForObject.isEmpty()) {
                LOG.error((Object)("Couldn't find any paths for " + qs + " from amongst " + cci.paths));
            }
            retval.addNode(fieldsForObject);
        }
        return retval;
    }

    @Override
    public Iterator<List<Either<ResultCell, SubTable>>> iterator() {
        return new TableRowIterator(this.pathQuery, this.query, this.results, this.nodeForPath, this.page, this.im);
    }

    @Override
    public boolean hasNext() {
        return this.page.withinRange(this.counter) && this.osIter.hasNext();
    }

    @Override
    public void remove() {
        throw new NotImplementedException(this.getClass(), "remove");
    }

    @Override
    public List<Either<ResultCell, SubTable>> next() {
        List row = (List)this.osIter.next();
        ++this.counter;
        return this.recursiveNext(row, this.resultsShape);
    }

    private List<Either<ResultCell, SubTable>> recursiveNext(List row, DisjointRecursiveList<List<Path>> shape) {
        DisjointList retVal = new DisjointList();
        Iterator iter = row.iterator();
        shape.forEach((EitherVisitor)new /* Unavailable Anonymous Inner Class!! */);
        Collections.sort(retVal, this.reorderer);
        return retVal;
    }

    static /* synthetic */ PathQuery access$100(TableRowIterator x0) {
        return x0.pathQuery;
    }

    static /* synthetic */ EitherVisitor access$200() {
        return PATH_GETTER;
    }

    static /* synthetic */ DisjointRecursiveList access$300(TableRowIterator x0, DisjointRecursiveList x1) {
        return x0.consolidateLevels(x1);
    }

    static /* synthetic */ void access$400(TableRowIterator x0, DisjointRecursiveList x1) {
        x0.orderListOnEachLevel(x1);
    }

    static /* synthetic */ Path access$500(TableRowIterator x0, DisjointRecursiveList x1, Map x2) {
        return x0.determineLevels(x1, x2);
    }

    static /* synthetic */ InterMineAPI access$600(TableRowIterator x0) {
        return x0.im;
    }

    static /* synthetic */ List access$700(TableRowIterator x0, List x1, DisjointRecursiveList x2) {
        return x0.recursiveNext(x1, x2);
    }

    static /* synthetic */ Map access$800(TableRowIterator x0) {
        return x0.levels;
    }
}

