/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.template.result;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.template.ApiTemplate;
import org.intermine.api.template.TemplateManager;
import org.intermine.api.template.TemplatePopulator;
import org.intermine.pathquery.PathQuery;
import org.intermine.template.TemplatePopulatorException;
import org.intermine.template.TemplateQuery;
import org.intermine.web.logic.template.TemplateResultInput;
import org.intermine.web.logic.template.Templates;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.ResourceNotFoundException;
import org.intermine.webservice.server.query.result.PathQueryBuilderForJSONObj;
import org.intermine.webservice.server.query.result.QueryResultService;
import org.intermine.webservice.server.template.result.TemplateResultRequestParser;

public class TemplateResultService
extends QueryResultService {
    public static final String TYPE_PARAMETER = "type";
    public static final String NAME_PARAMETER = "name";
    private static final Logger LOG = Logger.getLogger(TemplateResultService.class);

    public TemplateResultService(InterMineAPI im) {
        super(im);
    }

    protected void execute() {
        TemplateQuery populatedTemplate;
        Map templateValues;
        TemplateManager templateManager = this.im.getTemplateManager();
        TemplateResultInput input = this.getInput();
        Profile profile = this.getPermission().getProfile();
        ApiTemplate template = templateManager.getUserOrGlobalTemplate(profile, input.getName());
        if (template == null) {
            throw new ResourceNotFoundException("You do not have access to a template called '" + input.getName() + "' in this mine.");
        }
        try {
            templateValues = Templates.getValuesFromInput((TemplateQuery)template, (TemplateResultInput)input);
        }
        catch (Templates.TemplateValueParseException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
        try {
            populatedTemplate = TemplatePopulator.getPopulatedTemplate((TemplateQuery)template, (Map)templateValues);
        }
        catch (TemplatePopulatorException e) {
            e.printStackTrace();
            LOG.error((Object)("Error populating template: " + template.getName() + ". " + (Object)((Object)e)));
            throw new BadRequestException("Error in applying constraint values to template: " + template.getName(), (Throwable)e);
        }
        if (this.formatIsJsonObj()) {
            List newView = PathQueryBuilderForJSONObj.getAlteredViews((PathQuery)populatedTemplate);
            populatedTemplate.clearView();
            populatedTemplate.addViews((Collection)newView);
        }
        this.setHeaderAttributes((PathQuery)populatedTemplate, input.getStart(), input.getLimit());
        if (!populatedTemplate.isValid()) {
            String msg = "Required data source (template) is outdated and is in conflict with model: " + populatedTemplate.verifyQuery();
            throw new BadRequestException(msg);
        }
        this.runPathQuery((PathQuery)populatedTemplate, input.getStart().intValue(), input.getLimit().intValue());
    }

    private TemplateResultInput getInput() {
        return new TemplateResultRequestParser(this.request).getInput();
    }
}

