/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web;

import java.net.MalformedURLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.actions.TilesAction;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.util.PathUtil;
import org.intermine.bio.util.BioUtil;
import org.intermine.bio.web.XRef;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.Model;
import org.intermine.metadata.TypeUtil;
import org.intermine.model.InterMineObject;
import org.intermine.model.bio.Organism;
import org.intermine.objectstore.ObjectStore;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathException;
import org.intermine.util.DynamicUtil;
import org.intermine.web.logic.bag.BagHelper;
import org.intermine.web.logic.results.ReportObject;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.util.AttributeLinkURL;

public class AttributeLinksController
extends TilesAction {
    protected static final Logger LOG = Logger.getLogger(AttributeLinksController.class);
    static final String ATTR_MARKER_RE = "<<attributeValue>>";

    public ActionForward execute(ComponentContext context, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)request.getSession());
        ServletContext servletContext = request.getSession().getServletContext();
        InterMineBag bag = (InterMineBag)request.getAttribute("bag");
        ReportObject reportObject = null;
        InterMineObject imo = null;
        if (bag == null) {
            reportObject = (ReportObject)request.getAttribute("reportObject");
            imo = reportObject.getObject();
        }
        ObjectStore os = im.getObjectStore();
        Model model = im.getModel();
        Set classDescriptors = imo == null ? bag.getClassDescriptors() : model.getClassDescriptorsForClass(imo.getClass());
        StringBuffer sb = new StringBuffer();
        for (ClassDescriptor cd : classDescriptors) {
            if (sb.length() <= 0) {
                sb.append("(");
            } else {
                sb.append("|");
            }
            sb.append(TypeUtil.unqualifiedName((String)cd.getName()));
        }
        sb.append(")");
        Organism organismReference = null;
        String geneOrgKey = sb.toString();
        if (imo != null) {
            try {
                organismReference = (Organism)imo.getFieldValue("organism");
            }
            catch (Exception exception) {
                // empty catch block
            }
            geneOrgKey = organismReference == null || organismReference.getTaxonId() == null ? geneOrgKey + "(\\.(\\*))?" : geneOrgKey + "(\\.(" + organismReference.getTaxonId() + "|\\*))?";
        } else {
            geneOrgKey = geneOrgKey + "(\\.(\\*|[\\d]+))?";
        }
        Map<String, ConfigMap> linkConfigs = new HashMap<String, ConfigMap>();
        Properties webProperties = (Properties)servletContext.getAttribute("WEB_PROPERTIES");
        String regexp = "attributelink\\.([^.]+)\\." + geneOrgKey + "\\.([^.]+)(\\.list)?\\.(url|text|imageName|usePost|delimiter|enctype|dataset|useCheckbox)";
        Pattern p = Pattern.compile(regexp);
        String className = null;
        String taxId = null;
        for (Map.Entry<Object, Object> entry : webProperties.entrySet()) {
            ConfigMap config;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            Matcher matcher = p.matcher(key);
            if (!matcher.matches()) continue;
            String dbName = matcher.group(1);
            className = matcher.group(2);
            taxId = matcher.group(4);
            String attrName = matcher.group(5);
            String imType = matcher.group(6);
            String propType = matcher.group(7);
            if (imo != null && imType != null || bag != null && imType == null) continue;
            if (linkConfigs.containsKey(dbName)) {
                config = linkConfigs.get(dbName);
            } else {
                config = new ConfigMap();
                config.put("attributeName", attrName);
                config.put("linkId", dbName);
                linkConfigs.put(dbName, config);
            }
            Object attrValue = null;
            Collection taxIds = null;
            if (config.containsKey("attributeValue")) {
                attrValue = config.get("attributeValue");
            } else {
                try {
                    if (imo != null) {
                        attrValue = imo.getFieldValue(attrName);
                    } else {
                        attrValue = BagHelper.getAttributesFromBag((InterMineBag)bag, (ObjectStore)os, (String)dbName, (String)attrName);
                        if (!"*".equalsIgnoreCase(taxId) && ((taxIds = BioUtil.getOrganisms((ObjectStore)os, (String)bag.getType(), (List)bag.getContentsAsIds(), (boolean)false, (String)"taxonId")) == null || !taxIds.contains(taxId))) continue;
                    }
                    if (attrValue != null) {
                        config.put("attributeValue", attrValue);
                        config.put("valid", Boolean.TRUE);
                    }
                }
                catch (IllegalAccessException e) {
                    config.put("attributeValue", e);
                    config.put("valid", Boolean.FALSE);
                    LOG.error((Object)("configuration problem in AttributeLinkDisplayerController: couldn't get a value for field " + attrName + " in class " + className));
                }
            }
            if ("url".equals(propType)) {
                if (attrValue == null) continue;
                String url = value.contains(ATTR_MARKER_RE) ? value.replaceAll(ATTR_MARKER_RE, String.valueOf(attrValue)) : value + attrValue;
                config.put("url", url);
                continue;
            }
            if ("imageName".equals(propType)) {
                config.put("imageName", value);
                continue;
            }
            if ("usePost".equals(propType)) {
                config.put("usePost", value);
                continue;
            }
            if ("delimiter".equals(propType)) {
                config.put("delimiter", value);
                continue;
            }
            if ("enctype".equals(propType)) {
                config.put("enctype", value);
                continue;
            }
            if ("dataset".equals(propType)) {
                config.put("dataset", value);
                continue;
            }
            if ("useCheckbox".equals(propType)) {
                config.put("useCheckbox", value);
                continue;
            }
            if (!"text".equals(propType)) continue;
            config.put("title", value.replaceAll("[^A-Za-z0-9 ]", "").replaceFirst("attributeValue", ""));
            String text = value.replaceAll(ATTR_MARKER_RE, String.valueOf(attrValue));
            config.put("text", text);
        }
        linkConfigs = this.processConfigs(im, linkConfigs, reportObject);
        request.setAttribute("attributeLinkConfiguration", linkConfigs);
        request.setAttribute("attributeLinkClassName", className);
        LinkedHashMap<String, XRef> xrefMap = new LinkedHashMap<String, XRef>();
        String xrefRegExp = "xreflink\\.([^.]+)\\.(url|imageName)";
        Pattern xrefpat = Pattern.compile("xreflink\\.([^.]+)\\.(url|imageName)");
        for (Map.Entry<Object, Object> entry : webProperties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            Matcher matcher = xrefpat.matcher(key);
            if (!matcher.matches()) continue;
            String sourceName = matcher.group(1);
            String propType = matcher.group(2);
            XRef xref = new XRef();
            xref.setSourceName(sourceName);
            if ("url".equals(propType)) {
                xref.setUrl(value);
            } else if ("imageName".equals(propType)) {
                xref.setSourceName(value);
            }
            xrefMap.put(sourceName, xref);
        }
        request.setAttribute("xrefMap", xrefMap);
        return null;
    }

    private Map<String, ConfigMap> processConfigs(InterMineAPI im, Map<String, ConfigMap> linkConfigs, ReportObject reportObject) {
        HashMap<String, ConfigMap> newMap = new HashMap<String, ConfigMap>(linkConfigs);
        for (Map.Entry entry : newMap.entrySet()) {
            ConfigMap config = (ConfigMap)entry.getValue();
            if (config.get("delimiter") != null) {
                AttributeLinksController.modifyIdString(config);
            }
            if (config.get("usePost") != null && ((String)config.get("usePost")).equalsIgnoreCase("true")) {
                AttributeLinksController.modifyConfigToPost(config);
            }
            if (config.get("dataset") == null) continue;
            String datasetToMatch = (String)config.get("dataset");
            boolean hasValidDataset = false;
            try {
                hasValidDataset = AttributeLinksController.hasDataset(im, reportObject, datasetToMatch);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (hasValidDataset) continue;
            linkConfigs.remove(entry.getKey());
        }
        return linkConfigs;
    }

    private static boolean hasDataset(InterMineAPI im, ReportObject reportObject, String datasetToMatch) throws PathException {
        boolean isValidDataset = false;
        InterMineObject imo = reportObject.getObject();
        Path path = new Path(im.getModel(), DynamicUtil.getSimpleClass(imo.getClass()).getSimpleName() + ".dataSets");
        Set listOfListObjects = PathUtil.resolveCollectionPath((Path)path, (Object)imo);
        for (Object listObject : listOfListObjects) {
            InterMineObject interMineListObject = (InterMineObject)listObject;
            Object value = null;
            try {
                value = interMineListObject.getFieldValue("name");
            }
            catch (IllegalAccessException e) {
                continue;
            }
            if (value == null || !value.toString().equals(datasetToMatch)) continue;
            isValidDataset = true;
        }
        return isValidDataset;
    }

    private static void modifyIdString(ConfigMap config) {
        String delim = (String)config.get("delimiter");
        String urlString = (String)config.get("url");
        String idString = (String)config.get("attributeValue");
        if ("NEWLINE".equals(delim)) {
            urlString = urlString.replace(",", System.getProperty("line.separator"));
            idString = idString.replace(",", System.getProperty("line.separator"));
        } else {
            urlString = urlString.replace(",", delim);
            idString = idString.replace(",", delim);
        }
        config.put("url", urlString);
        config.put("attributeValue", idString);
    }

    private static void modifyConfigToPost(ConfigMap config) {
        AttributeLinkURL link;
        String urlString = (String)config.get("url");
        try {
            link = new AttributeLinkURL(urlString);
        }
        catch (MalformedURLException e) {
            LOG.error((Object)"Converting url from GET to POST form failed. Url retained in GET form.", (Throwable)e);
            return;
        }
        config.put("url", link.getBaseURL());
        if (link.getParameters().size() > 0) {
            config.put("parameters", link.getParameters());
        }
    }

    private class ConfigMap
    extends HashMap<String, Object> {
        private ConfigMap() {
        }
    }
}

