/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.displayer;

import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.intermine.api.InterMineAPI;
import org.intermine.model.FastPathObject;
import org.intermine.model.InterMineObject;
import org.intermine.util.DynamicUtil;
import org.intermine.web.displayer.ReportDisplayer;
import org.intermine.web.logic.config.ReportDisplayerConfig;
import org.intermine.web.logic.results.ReportObject;

public class SequenceFeatureDisplayer
extends ReportDisplayer {
    private Integer maximumNumberOfLocations = 27;

    public SequenceFeatureDisplayer(ReportDisplayerConfig config, InterMineAPI im) {
        super(config, im);
    }

    public void display(HttpServletRequest request, ReportObject reportObject) {
        InterMineObject imObj = reportObject.getObject();
        Object loc = null;
        String imoClassName = imObj.getClass().getSimpleName();
        if (imoClassName.endsWith("Shadow")) {
            imoClassName = imoClassName.substring(0, imoClassName.indexOf("Shadow"));
        }
        request.setAttribute("objectClass", (Object)imoClassName);
        try {
            loc = imObj.getFieldValue("chromosomeLocation");
            if (loc == null) {
                Collection col = (Collection)imObj.getFieldValue("locations");
                ArrayList results = new ArrayList();
                Integer i = 0;
                for (Object item : col) {
                    if (i == this.maximumNumberOfLocations) break;
                    InterMineObject imLocation = (InterMineObject)item;
                    Object locatedOnObject = imLocation.getFieldValue("locatedOn");
                    if (locatedOnObject != null && "Chromosome".equals(DynamicUtil.getSimpleClass((FastPathObject)((InterMineObject)locatedOnObject)).getSimpleName())) {
                        results.add(item);
                    }
                    Integer n = i;
                    Integer n2 = i = Integer.valueOf(i + 1);
                }
                if (!results.isEmpty()) {
                    request.setAttribute("locationsCollection", results);
                    request.setAttribute("locationsCollectionSize", (Object)col.size());
                }
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        try {
            String cytoLocation = (String)imObj.getFieldValue("cytoLocation");
            if (!StringUtils.isBlank((String)cytoLocation)) {
                request.setAttribute("cytoLocation", (Object)cytoLocation);
            }
        }
        catch (IllegalAccessException cytoLocation) {
            // empty catch block
        }
        try {
            String mapLocation = (String)imObj.getFieldValue("mapLocation");
            if (!StringUtils.isBlank((String)mapLocation)) {
                request.setAttribute("mapLocation", (Object)mapLocation);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }
}

