/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.webservice;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.BagManager;
import org.intermine.api.profile.Profile;
import org.intermine.bio.web.logic.GenomicRegionSearchQueryRunner;
import org.intermine.bio.web.logic.GenomicRegionSearchUtil;
import org.intermine.bio.web.logic.RegionParseException;
import org.intermine.bio.web.model.ChromosomeInfo;
import org.intermine.bio.web.model.GenomicRegion;
import org.intermine.bio.web.model.GenomicRegionSearchConstraint;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.MetaDataException;
import org.intermine.metadata.Model;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.ServiceException;
import org.intermine.webservice.server.lists.ListInput;
import org.json.JSONArray;
import org.json.JSONObject;

public class GenomicRegionSearchListInput
extends ListInput {
    private final InterMineAPI api;
    private final GenomicRegionSearchInfo info;

    public GenomicRegionSearchListInput(HttpServletRequest request, BagManager bagManager, Profile profile, InterMineAPI im) throws Exception {
        super(request, bagManager, profile);
        this.api = im;
        this.info = this.parseRegionRequest();
    }

    private GenomicRegionSearchInfo parseRegionRequest() throws Exception {
        String input = "";
        input = "application/x-www-form-urlencoded".equals(this.request.getContentType()) || "GET".equalsIgnoreCase(this.request.getMethod()) ? this.request.getParameter("query") : IOUtils.toString((InputStream)this.request.getInputStream());
        JSONObject jsonRequest = new JSONObject(input);
        GenomicRegionSearchInfo parsed = new GenomicRegionSearchInfo();
        parsed.setOrganism(jsonRequest.getString("organism"));
        if (!jsonRequest.isNull("isInterbase")) {
            parsed.setInterbase(jsonRequest.getBoolean("isInterbase"));
        }
        if (!jsonRequest.isNull("extension")) {
            parsed.setExtension(jsonRequest.optInt("extension", 0));
        }
        JSONArray fts = jsonRequest.getJSONArray("featureTypes");
        int noOfTypes = fts.length();
        ArrayList<String> featureTypes = new ArrayList<String>();
        for (int i = 0; i < noOfTypes; ++i) {
            featureTypes.add(fts.getString(i));
        }
        parsed.setFeatureTypes(featureTypes);
        JSONArray regs = jsonRequest.getJSONArray("regions");
        int noOfRegs = regs.length();
        ArrayList<String> regions = new ArrayList<String>();
        for (int i = 0; i < noOfRegs; ++i) {
            regions.add(regs.getString(i));
        }
        parsed.setRegions(regions);
        if (!jsonRequest.isNull("strandSpecific")) {
            parsed.setStrandSpecific(jsonRequest.getBoolean("strandSpecific"));
        }
        return parsed;
    }

    protected String produceName() {
        String name = this.request.getParameter("listName");
        if (!StringUtils.isBlank((String)name)) {
            return name;
        }
        return super.produceName();
    }

    public GenomicRegionSearchInfo getSearchInfo() {
        return this.info;
    }

    public class GenomicRegionSearchInfo {
        private final String sequenceFeature = "org.intermine.model.bio.SequenceFeature";
        private String organism;
        private Set<String> featureTypes;
        private Set<ClassDescriptor> featureCds;
        private List<String> regions;
        private int extension = 0;
        private boolean isInterbase = false;
        private Set<String> invalidSpans = new HashSet<String>();
        private boolean strandSpecific;

        public Set<String> getInvalidSpans() {
            return this.invalidSpans;
        }

        public String getOrganism() {
            return this.organism;
        }

        public void setOrganism(String organism) {
            this.organism = organism;
        }

        public boolean getStrandSpecific() {
            return this.strandSpecific;
        }

        public void setStrandSpecific(boolean strandSpecific) {
            this.strandSpecific = strandSpecific;
        }

        public Set<String> getFeatureTypes() {
            return Collections.unmodifiableSet(this.featureTypes);
        }

        public void setFeatureTypes(Collection<String> featureTypes) {
            this.featureTypes = new HashSet<String>(featureTypes);
            this.featureCds = new HashSet<ClassDescriptor>();
            HashSet<String> badTypes = new HashSet<String>();
            Model model = GenomicRegionSearchListInput.this.api.getModel();
            ClassDescriptor sfCd = model.getClassDescriptorByName("org.intermine.model.bio.SequenceFeature");
            for (String f : this.featureTypes) {
                ClassDescriptor cld = model.getClassDescriptorByName(f);
                if (cld == null) {
                    badTypes.add(f);
                    continue;
                }
                try {
                    if (!("org.intermine.model.bio.SequenceFeature".equals(f) || sfCd.getUnqualifiedName().equals(f) || ClassDescriptor.findSuperClassNames((Model)model, (String)f).contains("org.intermine.model.bio.SequenceFeature"))) {
                        throw new BadRequestException(f + " is not a " + "org.intermine.model.bio.SequenceFeature");
                    }
                }
                catch (MetaDataException e) {
                    throw new ServiceException((Throwable)e);
                }
                this.featureCds.add(cld);
                for (ClassDescriptor subCld : model.getAllSubs(cld)) {
                    this.featureCds.add(subCld);
                }
            }
            if (!badTypes.isEmpty()) {
                throw new BadRequestException("The following feature types are not valid feature class names: " + badTypes);
            }
        }

        public Set<ClassDescriptor> getFeatureCds() {
            return Collections.unmodifiableSet(this.featureCds);
        }

        public Set<Class<?>> getFeatureClasses() {
            HashSet<Class> ftSet = new HashSet<Class>();
            for (ClassDescriptor cld : this.getFeatureCds()) {
                ftSet.add(cld.getType());
            }
            return Collections.unmodifiableSet(ftSet);
        }

        public List<String> getRegions() {
            return this.regions;
        }

        public void setRegions(List<String> regions) {
            this.regions = regions;
        }

        public List<GenomicRegion> getGenomicRegions() {
            HashSet<String> spans = new HashSet<String>(this.getRegions());
            ArrayList<GenomicRegion> newRegions = new ArrayList<GenomicRegion>();
            Map<String, ChromosomeInfo> chromsForOrg = GenomicRegionSearchQueryRunner.getChromosomeInfo(GenomicRegionSearchListInput.this.api).get(this.getOrganism());
            for (String span : spans) {
                try {
                    newRegions.add(GenomicRegionSearchUtil.parseRegion(span, this.isInterbase(), chromsForOrg));
                }
                catch (RegionParseException e) {
                    this.invalidSpans.add(span + "; " + e.getMessage());
                }
            }
            return newRegions;
        }

        public int getExtension() {
            return this.extension;
        }

        public void setExtension(int extension) {
            this.extension = extension;
        }

        public boolean isInterbase() {
            return this.isInterbase;
        }

        public void setInterbase(boolean isInterbase) {
            this.isInterbase = isInterbase;
        }

        public GenomicRegionSearchConstraint asSearchConstraint() {
            GenomicRegionSearchConstraint grsc = new GenomicRegionSearchConstraint();
            grsc.setOrgName(this.organism);
            grsc.setFeatureTypes(this.getFeatureClasses());
            grsc.setGenomicRegionList(this.getGenomicRegions());
            grsc.setExtendedRegionSize(this.extension);
            return grsc;
        }
    }
}

