/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.complexes;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.intermine.api.InterMineAPI;
import org.intermine.api.results.ExportResultsIterator;
import org.intermine.api.results.ResultElement;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.pathquery.Constraints;
import org.intermine.pathquery.OrderDirection;
import org.intermine.pathquery.OuterJoinStatus;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathQuery;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.exceptions.BadRequestException;
import psidev.psi.mi.jami.bridges.exception.BridgeFailedException;
import psidev.psi.mi.jami.bridges.fetcher.OntologyTermFetcher;
import psidev.psi.mi.jami.bridges.ols.CachedOlsOntologyTermFetcher;
import psidev.psi.mi.jami.datasource.InteractionWriter;
import psidev.psi.mi.jami.factory.InteractionWriterFactory;
import psidev.psi.mi.jami.json.InteractionViewerJson;
import psidev.psi.mi.jami.json.MIJsonOptionFactory;
import psidev.psi.mi.jami.json.MIJsonType;
import psidev.psi.mi.jami.model.CvTerm;
import psidev.psi.mi.jami.model.Feature;
import psidev.psi.mi.jami.model.Interaction;
import psidev.psi.mi.jami.model.InteractionCategory;
import psidev.psi.mi.jami.model.Interactor;
import psidev.psi.mi.jami.model.ModelledParticipant;
import psidev.psi.mi.jami.model.Organism;
import psidev.psi.mi.jami.model.Position;
import psidev.psi.mi.jami.model.Stoichiometry;
import psidev.psi.mi.jami.model.Xref;
import psidev.psi.mi.jami.model.impl.DefaultComplex;
import psidev.psi.mi.jami.model.impl.DefaultCvTerm;
import psidev.psi.mi.jami.model.impl.DefaultInteractor;
import psidev.psi.mi.jami.model.impl.DefaultModelledFeature;
import psidev.psi.mi.jami.model.impl.DefaultModelledParticipant;
import psidev.psi.mi.jami.model.impl.DefaultOrganism;
import psidev.psi.mi.jami.model.impl.DefaultPosition;
import psidev.psi.mi.jami.model.impl.DefaultRange;
import psidev.psi.mi.jami.model.impl.DefaultStoichiometry;
import psidev.psi.mi.jami.model.impl.DefaultXref;

public class ExportService
extends JSONService {
    private static final String FORMAT_PARAMETER = "format";
    private static final String DEFAULT_FORMAT = "JSON";
    private static final String EBI = "intact";
    private static final Map<String, String> MOLECULE_TYPES = new HashMap<String, String>();
    private Map<String, DefaultInteractor> interactors = new HashMap<String, DefaultInteractor>();
    private Map<String, DefaultModelledParticipant> participants = new HashMap<String, DefaultModelledParticipant>();
    private Map<String, FeatureHolder> features = new HashMap<String, FeatureHolder>();
    private static final String BINDING_SITE = "binding region";

    public ExportService(InterMineAPI im) {
        super(im);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws Exception {
        String format = this.request.getParameter(FORMAT_PARAMETER);
        if (StringUtils.isEmpty((String)format)) {
            format = DEFAULT_FORMAT;
        }
        String identifier = this.getComplexIdentifier();
        DefaultComplex complex = this.getComplex(identifier);
        InteractionViewerJson.initialiseAllMIJsonWriters();
        MIJsonOptionFactory optionFactory = MIJsonOptionFactory.getInstance();
        InteractionWriterFactory writerFactory = InteractionWriterFactory.getInstance();
        InteractionWriter writer = null;
        try {
            writer = writerFactory.getInteractionWriterWith(optionFactory.getJsonOptions((Object)this.getRawOutput(), InteractionCategory.modelled, null, MIJsonType.n_ary_only, (OntologyTermFetcher)new CachedOlsOntologyTermFetcher(), null));
        }
        catch (BridgeFailedException e) {
            writer = writerFactory.getInteractionWriterWith(optionFactory.getJsonOptions((Object)this.getRawOutput(), InteractionCategory.modelled, null, MIJsonType.n_ary_only, null, null));
        }
        try {
            writer.start();
            writer.write((Interaction)complex);
            writer.end();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private String getComplexIdentifier() {
        String identifier = StringUtils.substring((String)this.request.getPathInfo(), (int)1);
        if (StringUtils.isBlank((String)identifier)) {
            throw new BadRequestException("No identifier provided");
        }
        return identifier;
    }

    protected DefaultComplex getComplex(String identifier) throws ObjectStoreException {
        PathQuery q = this.getQuery(identifier);
        ExportResultsIterator results = this.im.getPathQueryExecutor().execute(q);
        DefaultXref complexXref = new DefaultXref((CvTerm)new DefaultCvTerm(EBI), identifier);
        DefaultComplex complex = new DefaultComplex(identifier, (Xref)complexXref);
        while (results.hasNext()) {
            List row = results.next();
            String name = (String)((ResultElement)row.get(0)).getField();
            String systematicName = (String)((ResultElement)row.get(1)).getField();
            String properties = (String)((ResultElement)row.get(2)).getField();
            String primaryIdentifier = (String)((ResultElement)row.get(4)).getField();
            Integer stoichiometry = (Integer)((ResultElement)row.get(5)).getField();
            if (stoichiometry == null) {
                stoichiometry = 1;
            }
            String biologicalRole = (String)((ResultElement)row.get(7)).getField();
            String moleculeType = (String)((ResultElement)row.get(8)).getField();
            complex.setFullName(name);
            complex.setSystematicName(systematicName);
            complex.setPhysicalProperties(properties);
            DefaultCvTerm type = this.getInteractorType(moleculeType);
            DefaultOrganism organism = null;
            if (row.get(6) != null && ((ResultElement)row.get(6)).getField() != null) {
                Integer taxonId = Integer.parseInt((String)((ResultElement)row.get(6)).getField());
                organism = new DefaultOrganism(taxonId.intValue());
            }
            DefaultCvTerm db = new DefaultCvTerm("uniprotkb");
            DefaultXref xref = new DefaultXref((CvTerm)db, primaryIdentifier);
            DefaultInteractor interactor = this.updateInteractor(primaryIdentifier, (CvTerm)type, organism, (Xref)xref);
            DefaultModelledParticipant participant = this.getParticipant(complex, primaryIdentifier, interactor, biologicalRole, stoichiometry);
            if (row.get(9) == null || ((ResultElement)row.get(9)).getField() == null) continue;
            String locatedOn = (String)((ResultElement)row.get(10)).getField();
            Integer start = (Integer)((ResultElement)row.get(11)).getField();
            Integer end = (Integer)((ResultElement)row.get(12)).getField();
            DefaultPosition startPosition = new DefaultPosition(new Long(start.intValue()).longValue());
            DefaultPosition endPosition = new DefaultPosition(new Long(end.intValue()).longValue());
            DefaultRange range = new DefaultRange((Position)startPosition, (Position)endPosition);
            DefaultCvTerm cvterm = new DefaultCvTerm(BINDING_SITE);
            DefaultModelledFeature feature = this.getFeature(primaryIdentifier, participant, locatedOn);
            DefaultXref bindingXref = new DefaultXref((CvTerm)db, locatedOn);
            DefaultInteractor bindingInteractor = this.getInteractor(locatedOn, (Xref)bindingXref);
            DefaultModelledParticipant bindingParticipant = this.getParticipant(complex, locatedOn, bindingInteractor, null, null);
            DefaultModelledFeature bindingFeature = this.getFeature(locatedOn, bindingParticipant, primaryIdentifier);
            bindingFeature.getRanges().add(range);
            feature.getLinkedFeatures().add(bindingFeature);
            participant.getFeatures().add(feature);
        }
        return complex;
    }

    private DefaultInteractor updateInteractor(String primaryIdentifier, CvTerm type, DefaultOrganism organism, Xref xref) {
        DefaultInteractor interactor = this.getInteractor(primaryIdentifier, xref);
        interactor.setInteractorType(type);
        interactor.setOrganism((Organism)organism);
        return interactor;
    }

    private DefaultInteractor getInteractor(String primaryIdentifier, Xref xref) {
        DefaultInteractor interactor = this.interactors.get(primaryIdentifier);
        if (interactor == null) {
            interactor = new DefaultInteractor(primaryIdentifier, xref);
            this.interactors.put(primaryIdentifier, interactor);
        }
        return interactor;
    }

    private DefaultModelledParticipant getParticipant(DefaultComplex complex, String primaryIdentifier, DefaultInteractor interactor, String biologicalRole, Integer stoichiometry) {
        DefaultModelledParticipant participant = this.participants.get(primaryIdentifier);
        if (participant == null) {
            participant = new DefaultModelledParticipant((Interactor)interactor);
            this.participants.put(primaryIdentifier, participant);
            complex.addParticipant((ModelledParticipant)participant);
        }
        if (biologicalRole != null) {
            participant.setBiologicalRole((CvTerm)new DefaultCvTerm(biologicalRole));
            participant.setStoichiometry((Stoichiometry)new DefaultStoichiometry(stoichiometry.intValue()));
        }
        return participant;
    }

    private DefaultModelledFeature getFeature(String primaryIdentifier, DefaultModelledParticipant participant, String otherIdentifier) {
        FeatureHolder holder = this.features.get(primaryIdentifier);
        DefaultModelledFeature feature = null;
        if (holder == null) {
            feature = new DefaultModelledFeature((ModelledParticipant)participant, primaryIdentifier, primaryIdentifier);
            participant.addFeature((Feature)feature);
            holder = new FeatureHolder(primaryIdentifier, participant);
            holder.addLinkedFeature(otherIdentifier, feature);
            this.features.put(primaryIdentifier, holder);
        } else {
            feature = holder.getLinkedFeature(otherIdentifier);
            if (feature == null) {
                feature = new DefaultModelledFeature((ModelledParticipant)participant, primaryIdentifier, primaryIdentifier);
                holder.addLinkedFeature(otherIdentifier, feature);
                participant.addFeature((Feature)feature);
            }
        }
        return feature;
    }

    private DefaultCvTerm getInteractorType(String moleculeType) {
        String identifier = MOLECULE_TYPES.get(moleculeType);
        DefaultCvTerm cvTerm = new DefaultCvTerm(moleculeType, identifier);
        return cvTerm;
    }

    private PathQuery getQuery(String identifier) throws ObjectStoreException {
        PathQuery query = new PathQuery(this.model);
        query.addViews(new String[]{"Complex.name", "Complex.systematicName", "Complex.properties", "Complex.function", "Complex.allInteractors.participant.primaryIdentifier", "Complex.allInteractors.stoichiometry", "Complex.allInteractors.participant.organism.taxonId", "Complex.allInteractors.biologicalRole", "Complex.allInteractors.type", "Complex.allInteractors.interactions.details.interactingRegions.locations.feature.primaryIdentifier", "Complex.allInteractors.interactions.details.interactingRegions.locations.locatedOn.primaryIdentifier", "Complex.allInteractors.interactions.details.interactingRegions.locations.start", "Complex.allInteractors.interactions.details.interactingRegions.locations.end"});
        query.setOuterJoinStatus("Complex.allInteractors.interactions", OuterJoinStatus.OUTER);
        query.setOuterJoinStatus("Complex.allInteractors.participant.organism", OuterJoinStatus.OUTER);
        query.addConstraint((PathConstraint)Constraints.eq((String)"Complex.identifier", (String)identifier));
        query.addOrderBy("Complex.allInteractors.participant.primaryIdentifier", OrderDirection.ASC);
        return query;
    }

    static {
        MOLECULE_TYPES.put("protein", "MI:0326");
        MOLECULE_TYPES.put("small molecule", "MI:0328");
        MOLECULE_TYPES.put("ribonucleic acid", "MI:0320");
        MOLECULE_TYPES.put("transfer rna", "MI:0325");
        MOLECULE_TYPES.put("double stranded deoxyribonucleic acid", "MI:0681");
        MOLECULE_TYPES.put("small nucleolar rna", "MI:0609");
    }

    protected class FeatureHolder {
        protected String primaryIdentifier = null;
        protected Map<String, DefaultModelledFeature> binderToFeatures = new HashMap<String, DefaultModelledFeature>();
        protected DefaultModelledParticipant participant = null;

        protected FeatureHolder(String primaryIdentifier, DefaultModelledParticipant participant) {
            this.primaryIdentifier = primaryIdentifier;
            this.participant = participant;
        }

        protected void addLinkedFeature(String identifier, DefaultModelledFeature linkedFeature) {
            this.binderToFeatures.put(identifier, linkedFeature);
        }

        protected DefaultModelledFeature getLinkedFeature(String identifier) {
            return this.binderToFeatures.get(identifier);
        }

        protected DefaultModelledParticipant getParticipant() {
            return this.participant;
        }
    }
}

