/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.displayer;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.intermine.api.InterMineAPI;
import org.intermine.bio.web.model.GeneModel;
import org.intermine.bio.web.model.GeneModelCache;
import org.intermine.bio.web.model.GeneModelSettings;
import org.intermine.metadata.Model;
import org.intermine.model.InterMineObject;
import org.intermine.model.bio.Gene;
import org.intermine.model.bio.SequenceFeature;
import org.intermine.objectstore.ObjectStore;
import org.intermine.web.displayer.ReportDisplayer;
import org.intermine.web.logic.config.ReportDisplayerConfig;
import org.intermine.web.logic.results.ReportObject;

public class GeneStructureDisplayer
extends ReportDisplayer {
    public GeneStructureDisplayer(ReportDisplayerConfig config, InterMineAPI im) {
        super(config, im);
    }

    public void display(HttpServletRequest request, ReportObject reportObject) {
        List geneModels = GeneModelCache.getGeneModels((InterMineObject)reportObject.getObject(), (Model)this.im.getModel());
        if (geneModels != null && !geneModels.isEmpty()) {
            Gene gene = ((GeneModel)geneModels.get(0)).getGene();
            request.setAttribute("gene", (Object)gene);
        }
        String organismName = ((SequenceFeature)reportObject.getObject()).getOrganism().getName();
        GeneModelSettings settings = GeneModelCache.getGeneModelOrganismSettings((String)organismName, (ObjectStore)this.im.getObjectStore());
        request.setAttribute("settings", (Object)settings);
        request.setAttribute("geneModels", (Object)geneModels);
        request.setAttribute("actualId", (Object)reportObject.getId());
    }
}

