/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.webservice;

import java.util.ArrayList;
import java.util.Set;
import org.intermine.api.InterMineAPI;
import org.intermine.bio.web.export.GFF3Exporter;
import org.intermine.bio.web.logic.SequenceFeatureExportUtil;
import org.intermine.bio.webservice.AbstractRegionExportService;
import org.intermine.bio.webservice.GFFQueryService;
import org.intermine.pathquery.PathQuery;
import org.intermine.webservice.server.exceptions.BadRequestException;

public class GenomicRegionGFF3Service
extends AbstractRegionExportService {
    public GenomicRegionGFF3Service(InterMineAPI im) {
        super(im);
    }

    protected GFF3Exporter getExporter(PathQuery pq) {
        String sourceName = this.webProperties.getProperty("project.title");
        Set organisms = null;
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        ArrayList viewColumns = new ArrayList(pq.getView());
        for (int i = 0; i < viewColumns.size(); ++i) {
            indexes.add(i);
        }
        GFFQueryService.removeFirstItemInPaths(viewColumns);
        return new GFF3Exporter(this.getPrintWriter(), indexes, GFFQueryService.getSoClassNames(), viewColumns, sourceName, organisms, false);
    }

    protected String getSuffix() {
        return ".gff3";
    }

    protected String getContentType() {
        return "text/x-gff3";
    }

    protected void checkPathQuery(PathQuery pq) throws Exception {
        try {
            SequenceFeatureExportUtil.isValidSequenceFeatureQuery((PathQuery)pq);
        }
        catch (SequenceFeatureExportUtil.InvalidQueryException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
    }
}

