/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.query;

import org.intermine.pathquery.PathQuery;
import org.intermine.web.logic.query.QueryMonitor;

public class QueryMonitorTimeout
implements QueryMonitor {
    protected int n;
    protected long lastTickle = -1L;
    protected int tickleCount = 0;
    private boolean complete = false;
    private boolean error = false;
    private boolean cancelled = false;
    private PathQuery query = null;

    public QueryMonitorTimeout(int n) {
        this.n = n;
        this.tickle();
    }

    public boolean shouldCancelQuery() {
        return System.currentTimeMillis() - this.lastTickle > (long)this.n;
    }

    public void tickle() {
        this.lastTickle = System.currentTimeMillis();
        ++this.tickleCount;
    }

    public int getTickleCount() {
        return this.tickleCount;
    }

    public void queryCompleted() {
        this.complete = true;
    }

    public boolean isCompleted() {
        return this.complete;
    }

    public void queryCancelledWithError() {
        this.error = true;
    }

    public boolean isCancelledWithError() {
        return this.error;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void queryCancelled() {
        this.cancelled = true;
    }

    public void setPathQuery(PathQuery query) {
        this.query = query.clone();
    }

    public PathQuery getPathQuery() {
        return this.query;
    }
}

