/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.results;

import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.intermine.pathquery.ConstraintValueParser;

public class ReportObjectField {
    private String fieldName;
    private Object fieldValue;
    private String fieldDisplayerPage;
    private String pathString;
    private boolean fieldDoNotTruncate;
    private boolean fieldEscapeXml;
    private String label = null;

    public ReportObjectField(String objectType, String fieldName, Object fieldValue, String fieldDisplayerPage, boolean doNotTruncate, boolean escapeXml) {
        this.fieldName = fieldName;
        this.fieldValue = fieldValue instanceof String ? (fieldValue != null && fieldValue.equals("null") ? "" : fieldValue) : (fieldValue instanceof Date ? ConstraintValueParser.ISO_DATE_FORMAT.format(fieldValue) : fieldValue);
        this.fieldDisplayerPage = fieldDisplayerPage;
        this.fieldDoNotTruncate = doNotTruncate;
        this.fieldEscapeXml = escapeXml;
        this.pathString = objectType + "." + fieldName;
    }

    public ReportObjectField(String objectType, String fieldName, Object fieldValue, String fieldDisplayerPage, boolean doNotTruncate, boolean escapeXml, String label) {
        this(objectType, fieldName, fieldValue, fieldDisplayerPage, doNotTruncate, escapeXml);
        this.label = label;
    }

    public String getDisplayName() {
        if (this.label != null) {
            return this.label;
        }
        String[] parts = StringUtils.splitByCharacterTypeCamelCase((String)this.fieldName);
        Object[] ucFirstParts = new String[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            ucFirstParts[i] = StringUtils.capitalize((String)parts[i]);
        }
        return StringUtils.join((Object[])ucFirstParts, (String)" ");
    }

    public String getName() {
        return this.fieldName;
    }

    public Object getValue() {
        return this.fieldValue;
    }

    public boolean getDoNotTruncate() {
        return this.fieldDoNotTruncate;
    }

    public boolean getEscapeXml() {
        return this.fieldEscapeXml;
    }

    public String getDisplayerPage() {
        return this.fieldDisplayerPage;
    }

    public boolean getValueHasDisplayer() {
        return this.fieldDisplayerPage != null;
    }

    public String getPathString() {
        return this.pathString;
    }
}

