/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.intermine.api.InterMineAPI;
import org.intermine.metadata.Util;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.query.ClobAccess;
import org.intermine.web.logic.config.FieldConfig;
import org.intermine.web.logic.config.Type;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.web.logic.export.FieldExporter;
import org.intermine.web.logic.session.SessionMethods;

public class GetAttributeAsFileAction
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)session);
        ObjectStore os = im.getObjectStore();
        WebConfig webConfig = SessionMethods.getWebConfig((HttpServletRequest)request);
        Integer objectId = new Integer(request.getParameter("object"));
        String fieldName = request.getParameter("field");
        String fileType = request.getParameter("type");
        InterMineObject object = os.getObjectById(objectId);
        FieldExporter fieldExporter = null;
        Set classes = Util.decomposeClass(object.getClass());
        for (Class c : classes) {
            String fieldExporterClassName;
            Type thisTypeConfig = (Type)webConfig.getTypes().get(c.getName());
            FieldConfig fc = (FieldConfig)thisTypeConfig.getFieldConfigMap().get(fieldName);
            if (fc == null || (fieldExporterClassName = fc.getFieldExporter()) == null) continue;
            fieldExporter = (FieldExporter)Class.forName(fieldExporterClassName).newInstance();
            break;
        }
        if (fieldExporter == null) {
            Object fieldValue = object.getFieldValue(fieldName);
            if (fileType == null || fileType.length() == 0) {
                response.setContentType("text/plain; charset=UTF-8");
                response.setHeader("Content-Disposition ", "inline; filename=" + fieldName + ".txt");
            } else {
                response.setContentType("text/" + fileType);
                response.setHeader("Content-Disposition ", "inline; filename=" + fieldName + "." + fileType);
            }
            PrintStream out = new PrintStream((OutputStream)response.getOutputStream());
            if (fieldValue instanceof ClobAccess) {
                ((ClobAccess)fieldValue).drainToPrintStream(out);
            } else {
                out.print(fieldValue);
            }
            out.flush();
        } else {
            fieldExporter.exportField(object, fieldName, os, response);
        }
        return null;
    }
}

