/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server;

import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.intermine.api.profile.Profile;
import org.intermine.webservice.server.JWTBuilder;
import org.json.JSONObject;

public final class JWTBuilder {
    private static final String TO_STR_FMT = "JWTBuilder(algorithm = %s, key = %s, issuer = %s)";
    private static final String BAD_VALIDITY = "minimum validity is 1 second - you requested ";
    private static final String ALGORITHM_NOT_SUPPORTED = "This algorithm (%s) is not supported by this JVM.";
    private static final String BAD_PROFILE = "Profile must exist and be for a registered user, you provided ";
    private final Algorithm algorithm;
    private final PrivateKey key;
    private final String issuer;

    public JWTBuilder(PrivateKey key, String issuer) {
        this.algorithm = Algorithm.SHA256withRSA;
        this.key = key;
        this.issuer = issuer;
        this.verify();
    }

    public JWTBuilder(Algorithm algorithm, PrivateKey key, String issuer) {
        this.algorithm = algorithm;
        this.key = key;
        this.issuer = issuer;
        this.verify();
    }

    private void verify() {
        if (this.algorithm == null || this.key == null || this.issuer == null) {
            throw new NullPointerException("No argument can be null for " + this.toString());
        }
    }

    public String issueToken(Profile profile, int validForSeconds) throws InvalidKeyException, SignatureException {
        if (validForSeconds < 1) {
            throw new IllegalArgumentException(BAD_VALIDITY + validForSeconds);
        }
        if (profile == null || !profile.isLoggedIn()) {
            throw new IllegalArgumentException(BAD_PROFILE + profile);
        }
        String sub = profile.getUsername();
        String email = profile.getEmailAddress();
        long absoluteExpiry = System.currentTimeMillis() + (long)validForSeconds * 1000L;
        return this.issueToken(sub, email, absoluteExpiry);
    }

    String issueToken(String subject, String email, long absoluteExpiry) throws InvalidKeyException, SignatureException {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("alg", this.algorithm.name());
        header.put("typ", "JWT");
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put("sub", subject);
        claims.put("iss", this.issuer);
        claims.put("exp", absoluteExpiry / 1000L);
        claims.put("iat", System.currentTimeMillis() / 1000L);
        claims.put("http://wso2.org/claims/emailaddress", email);
        String toSign = this.encodeContent(header, claims);
        byte[] signature = this.sign(toSign);
        return toSign + "." + Base64.encodeBase64URLSafeString((byte[])signature);
    }

    private String encodeContent(Map<String, Object> header, Map<String, Object> claims) {
        String toSign = String.format("%s.%s", Base64.encodeBase64URLSafeString((byte[])new JSONObject(header).toString().getBytes()), Base64.encodeBase64URLSafeString((byte[])new JSONObject(claims).toString().getBytes()));
        return toSign;
    }

    private byte[] sign(String toSign) throws InvalidKeyException, SignatureException {
        Signature signing = this.algorithm.createSignature();
        signing.initSign(this.key);
        signing.update(toSign.getBytes());
        byte[] signature = signing.sign();
        return signature;
    }

    public String toString() {
        return String.format(TO_STR_FMT, this.algorithm, this.key, this.issuer);
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder();
        hcb.append((Object)this.algorithm).append((Object)this.key).append((Object)this.issuer);
        return hcb.toHashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof JWTBuilder) {
            JWTBuilder jwtb = (JWTBuilder)other;
            return this.algorithm.equals((Object)jwtb.algorithm) && this.key.equals(jwtb.key) && this.issuer.equals(jwtb.issuer);
        }
        return false;
    }
}

