/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.output;

import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import org.intermine.webservice.server.output.Formatter;
import org.intermine.webservice.server.output.Output;

public class StreamedOutput
extends Output {
    private int resultsCount = 0;
    private PrintWriter writer;
    private final Formatter formatter;
    private boolean headerPrinted = false;
    private final String separator;

    public StreamedOutput(PrintWriter writer, Formatter formatter) {
        this.writer = writer;
        this.formatter = formatter;
        this.separator = null;
    }

    public StreamedOutput(PrintWriter writer, Formatter formatter, String separator) {
        this.writer = writer;
        this.formatter = formatter;
        this.separator = separator;
    }

    private void ensureHeaderIsPrinted() {
        if (!this.headerPrinted) {
            String header = this.formatter.formatHeader(this.getHeaderAttributes());
            if (header != null && header.length() > 0) {
                this.writeLn(header);
            }
            this.headerPrinted = true;
        }
    }

    public void writeLn(String s) {
        this.writer.print(s);
        if (this.separator == null) {
            this.writer.println();
        } else {
            this.writer.print(this.separator);
        }
    }

    public void addResultItem(List<String> item) {
        this.ensureHeaderIsPrinted();
        this.writeLn(this.formatter.formatResult(item));
        ++this.resultsCount;
    }

    public PrintWriter getWriter() {
        return this.writer;
    }

    public void setWriter(PrintWriter writer) {
        this.writer = writer;
    }

    public void flush() {
        this.ensureHeaderIsPrinted();
        this.writeFooter();
        this.writer.flush();
        this.writer.close();
    }

    public void writeFooter() {
        this.writer.print(this.formatter.formatFooter(this.getError(), this.getCode()));
    }

    public void setHeaderAttributes(Map<String, Object> attributes) {
        if (this.headerPrinted) {
            throw new RuntimeException("Attempt to set header attributes although header was printed already.");
        }
        super.setHeaderAttributes(attributes);
    }

    public int getResultsCount() {
        return this.resultsCount;
    }
}

