/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.query;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.TagManager;
import org.intermine.api.query.codegen.WebserviceCodeGenInfo;
import org.intermine.api.query.codegen.WebserviceCodeGenerator;
import org.intermine.api.query.codegen.WebserviceJavaCodeGenerator;
import org.intermine.api.query.codegen.WebserviceJavaScriptCodeGenerator;
import org.intermine.api.query.codegen.WebservicePerlCodeGenerator;
import org.intermine.api.query.codegen.WebservicePythonCodeGenerator;
import org.intermine.api.query.codegen.WebserviceRubyCodeGenerator;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.logic.export.ResponseUtil;
import org.intermine.web.util.URLGenerator;
import org.intermine.webservice.server.Format;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.query.AbstractQueryService;
import org.intermine.webservice.server.query.CodeService;
import org.intermine.webservice.server.query.QueryRequestParser;
import org.intermine.webservice.server.query.result.PathQueryBuilder;
import org.json.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
public class CodeService
extends AbstractQueryService {
    protected static final Logger LOG = Logger.getLogger(CodeService.class);
    private String perlModuleVersion;
    private static final String PERL_MODULE_URI = "http://api.metacpan.org/v0/module/Webservice::InterMine";

    public CodeService(InterMineAPI im) {
        super(im);
    }

    protected Format getDefaultFormat() {
        return Format.TEXT;
    }

    protected boolean canServe(Format format) {
        switch (1.$SwitchMap$org$intermine$webservice$server$Format[format.ordinal()]) {
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    protected String getDefaultFileName() {
        return "query";
    }

    protected String getExtension() {
        String extension = super.getExtension();
        String lang = this.request.getParameter("lang");
        if ("perl".equals(lang) || "pl".equals(lang)) {
            return ".pl" + extension;
        }
        if ("java".equals(lang)) {
            return ".java" + extension;
        }
        if ("python".equals(lang) || "py".equals(lang)) {
            return ".py" + extension;
        }
        if ("javascript".equals(lang) || "js".equals(lang)) {
            return ".html" + extension;
        }
        if ("ruby".equals(lang) || "rb".equals(lang)) {
            return ".rb" + extension;
        }
        throw new BadRequestException("Unknown code generation language: " + lang);
    }

    private WebserviceCodeGenerator getCodeGenerator(String lang) {
        if ("js".equals(lang = StringUtils.lowerCase((String)lang)) || "javascript".equals(lang)) {
            return new WebserviceJavaScriptCodeGenerator();
        }
        if ("py".equals(lang) || "python".equals(lang)) {
            return new WebservicePythonCodeGenerator();
        }
        if ("java".equals(lang)) {
            return new WebserviceJavaCodeGenerator();
        }
        if ("pl".equals(lang) || "perl".equals(lang)) {
            return new WebservicePerlCodeGenerator();
        }
        if ("rb".equals(lang) || "ruby".equals(lang)) {
            return new WebserviceRubyCodeGenerator();
        }
        throw new BadRequestException("Unknown code generation language: " + lang);
    }

    protected void execute() {
        Profile profile = this.getPermission().getProfile();
        String serviceBaseURL = new URLGenerator(this.request).getPermanentBaseURL();
        String projectTitle = this.webProperties.getProperty("project.title");
        String perlWSModuleVer = this.getPerlModuleVersion();
        String lang = this.request.getParameter("lang");
        PathQuery pq = this.getPathQuery();
        String name = pq.getTitle() != null ? pq.getTitle() : "query";
        String fileName = name.replaceAll("[^a-zA-Z0-9_,.()-]", "_") + this.getExtension();
        this.response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        WebserviceCodeGenInfo info = new WebserviceCodeGenInfo(pq, serviceBaseURL, projectTitle, perlWSModuleVer, CodeService.pathQueryIsPublic((PathQuery)pq, (InterMineAPI)this.im, (Profile)profile), profile, this.getLineBreak());
        info.readWebProperties(this.webProperties);
        WebserviceCodeGenerator codeGen = this.getCodeGenerator(lang);
        String sc = codeGen.generate(info);
        if (this.formatIsJSON()) {
            ResponseUtil.setJSONHeader((HttpServletResponse)this.response, (String)"querycode.json");
            HashMap<String, String> attributes = new HashMap<String, String>();
            if (this.formatIsJSONP()) {
                String callback = this.getCallback();
                if (callback == null || "".equals(callback)) {
                    callback = "callback";
                }
                attributes.put("callback", callback);
            }
            attributes.put("intro", "\"code\":");
            attributes.put("outro", "");
            this.output.setHeaderAttributes(attributes);
            sc = "\"" + StringEscapeUtils.escapeJava((String)sc) + "\"";
        }
        this.output.addResultItem(Arrays.asList(sc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPerlModuleVersion() {
        if (this.perlModuleVersion == null) {
            BufferedReader reader = null;
            try {
                String line;
                URL url = new URL("http://api.metacpan.org/v0/module/Webservice::InterMine");
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setRequestProperty("Accept", "application/json");
                conn.setRequestProperty("User-Agent", "InterMine-34");
                int responseCode = conn.getResponseCode();
                if (responseCode != 200) {
                    String string = null;
                    return string;
                }
                reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuffer body = new StringBuffer();
                while ((line = reader.readLine()) != null) {
                    body.append(line);
                }
                String json = body.toString();
                JSONObject data = new JSONObject(json);
                this.perlModuleVersion = data.getString("version");
            }
            catch (Exception e) {
                String string = null;
                return string;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return this.perlModuleVersion;
    }

    protected static boolean pathQueryIsPublic(PathQuery pq, InterMineAPI im, Profile p) {
        Set listNames = pq.getBagNames();
        TagManager tm = im.getTagManager();
        for (String name : listNames) {
            Set tags = tm.getObjectTagNames(name, "bag", p.getUsername());
            if (tags.contains("im:public")) continue;
            return false;
        }
        return true;
    }

    private PathQuery getPathQuery() {
        String xml = new QueryRequestParser(this.im.getQueryStore(), this.request).getQueryXml();
        PathQueryBuilder pqb = this.getQueryBuilder(xml);
        PathQuery query = pqb.getQuery();
        return query;
    }
}

