/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.biojava;

import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.DNASequence;
import org.biojava.nbio.core.sequence.ProteinSequence;
import org.biojava.nbio.core.sequence.RNASequence;
import org.biojava.nbio.core.sequence.compound.AmbiguityDNACompoundSet;
import org.biojava.nbio.core.sequence.template.AbstractSequence;
import org.biojava.nbio.core.sequence.template.CompoundSet;
import org.intermine.bio.web.biojava.BioSequence;
import org.intermine.bio.web.biojava.BioSequenceFactory;
import org.intermine.model.bio.BioEntity;
import org.intermine.model.bio.Protein;
import org.intermine.model.bio.SequenceFeature;

public abstract class BioSequenceFactory {
    private BioSequenceFactory() {
    }

    public static BioSequence make(SequenceFeature feature) throws CompoundNotFoundException {
        if (feature.getSequence() == null) {
            return null;
        }
        String residues = feature.getSequence().getResidues().toString().toLowerCase();
        return new BioSequence((AbstractSequence)new DNASequence(residues), (BioEntity)feature);
    }

    public static BioSequence makeWithTranslation(SequenceFeature feature) throws CompoundNotFoundException {
        if (feature.getSequence() == null) {
            return null;
        }
        String residues = feature.getSequence().getResidues().toString().toLowerCase();
        return new BioSequence((AbstractSequence)new DNASequence(residues).getRNASequence().getProteinSequence(), (BioEntity)feature);
    }

    public static BioSequence make(Protein protein) throws CompoundNotFoundException {
        if (protein.getSequence() == null) {
            return null;
        }
        String residues = protein.getSequence().getResidues().toString();
        return new BioSequence((AbstractSequence)new ProteinSequence(residues), (BioEntity)protein);
    }

    public static BioSequence make(BioEntity bioEnt, SequenceType type) throws CompoundNotFoundException {
        if (bioEnt instanceof Protein) {
            Protein protein = (Protein)bioEnt;
            if (protein.getSequence() == null || protein.getSequence().getResidues() == null) {
                return null;
            }
            String residues = protein.getSequence().getResidues().toString();
            return new BioSequence((AbstractSequence)new ProteinSequence(residues), (BioEntity)protein);
        }
        if (type.equals((Object)SequenceType.PROTEIN)) {
            SequenceFeature feature = (SequenceFeature)bioEnt;
            if (feature.getSequence() == null || feature.getSequence().getResidues() == null) {
                return null;
            }
            String residues = feature.getSequence().getResidues().toString();
            return new BioSequence((AbstractSequence)new ProteinSequence(residues), (BioEntity)feature);
        }
        if (type.equals((Object)SequenceType.DNA)) {
            SequenceFeature feature = (SequenceFeature)bioEnt;
            if (feature.getSequence() == null || feature.getSequence().getResidues() == null) {
                return null;
            }
            String residues = feature.getSequence().getResidues().toString().toLowerCase();
            return new BioSequence((AbstractSequence)new DNASequence(residues, (CompoundSet)AmbiguityDNACompoundSet.getDNACompoundSet()), (BioEntity)feature);
        }
        if (type.equals((Object)SequenceType.RNA)) {
            SequenceFeature feature = (SequenceFeature)bioEnt;
            if (feature.getSequence() == null || feature.getSequence().getResidues() == null) {
                return null;
            }
            String residues = feature.getSequence().getResidues().toString().toLowerCase();
            return new BioSequence((AbstractSequence)new RNASequence(residues), (BioEntity)feature);
        }
        throw new RuntimeException("Sequence type not defined. Choices are PROTEIN, DNA, RNA.");
    }
}

