/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.displayer;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.query.PathQueryExecutor;
import org.intermine.api.results.ExportResultsIterator;
import org.intermine.api.results.ResultElement;
import org.intermine.metadata.Model;
import org.intermine.model.InterMineObject;
import org.intermine.model.bio.Gene;
import org.intermine.model.bio.Protein;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.pathquery.Constraints;
import org.intermine.pathquery.OrderDirection;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.displayer.ReportDisplayer;
import org.intermine.web.logic.config.ReportDisplayerConfig;
import org.intermine.web.logic.results.ReportObject;
import org.intermine.web.logic.session.SessionMethods;

public class UniProtCommentsDisplayer
extends ReportDisplayer {
    protected static final Logger LOG = Logger.getLogger(UniProtCommentsDisplayer.class);
    private final String[] allowedCommentTypes = new String[]{"similarity", "function", "tissue specificity", "subcellular location", "catalytic activity", "disease", "developmental stage", "pathway", "pharmaceutical"};

    public UniProtCommentsDisplayer(ReportDisplayerConfig config, InterMineAPI im) {
        super(config, im);
    }

    public void display(HttpServletRequest request, ReportObject reportObject) {
        InterMineObject object = reportObject.getObject();
        HashMap<String, Object> result = new HashMap<String, Object>();
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)session);
        Model model = im.getModel();
        PathQuery query = new PathQuery(model);
        if (object instanceof Gene) {
            ExportResultsIterator values;
            Gene gene = (Gene)object;
            String geneID = String.valueOf(gene.getId());
            query = this.geneCommentsQuery(geneID, query);
            Profile profile = SessionMethods.getProfile((HttpSession)session);
            PathQueryExecutor executor = im.getPathQueryExecutor(profile);
            try {
                values = executor.execute(query);
            }
            catch (ObjectStoreException e) {
                throw new RuntimeException(e);
            }
            result.put("gene", this.geneComments2(values));
        } else if (object instanceof Protein) {
            ExportResultsIterator values;
            Protein protein = (Protein)object;
            String proteinID = String.valueOf(protein.getId());
            query = this.proteinCommentsQuery(proteinID, query);
            Profile profile = SessionMethods.getProfile((HttpSession)session);
            PathQueryExecutor executor = im.getPathQueryExecutor(profile);
            try {
                values = executor.execute(query);
            }
            catch (ObjectStoreException e) {
                throw new RuntimeException(e);
            }
            result.put("protein", this.proteinComments2(values));
        }
        request.setAttribute("response", result);
    }

    private Object geneComments2(ExportResultsIterator values) {
        int posCommentText = 0;
        int posProteinID = 1;
        int posObjectID = 2;
        int posCommentType = 3;
        LinkedHashMap<String, HashMap> result = new LinkedHashMap<String, HashMap>();
        while (values.hasNext()) {
            HashMap proteins;
            List row = values.next();
            HashMap columns = new HashMap();
            String commentText = ((ResultElement)row.get(posCommentText)).getField().toString();
            if (result.containsKey(commentText)) {
                columns = (HashMap)result.get(commentText);
                proteins = (HashMap)columns.get("proteins");
                proteins.put(((ResultElement)row.get(posObjectID)).getField().toString(), ((ResultElement)row.get(posProteinID)).getField().toString());
                columns.put("proteins", proteins);
                continue;
            }
            proteins = new HashMap();
            proteins.put(((ResultElement)row.get(posObjectID)).getField().toString(), ((ResultElement)row.get(posProteinID)).getField().toString());
            columns.put("proteins", proteins);
            columns.put("text", commentText);
            columns.put("type", ((ResultElement)row.get(posCommentType)).getField().toString());
            result.put(commentText, columns);
        }
        return result;
    }

    private Object proteinComments2(ExportResultsIterator values) {
        int posCommentText = 0;
        int posCommentType = 1;
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        while (values.hasNext()) {
            List row = values.next();
            result.put(((ResultElement)row.get(posCommentText)).getField().toString(), ((ResultElement)row.get(posCommentType)).getField().toString());
        }
        return result;
    }

    private PathQuery geneCommentsQuery(String geneID, PathQuery query) {
        query.addViews(new String[]{"Gene.proteins.comments.description", "Gene.proteins.primaryIdentifier", "Gene.proteins.id", "Gene.proteins.comments.type", "Gene.primaryIdentifier"});
        query.addOrderBy("Gene.proteins.comments.type", OrderDirection.ASC);
        query.addConstraint((PathConstraint)Constraints.eq((String)"Gene.id", (String)geneID));
        query.addConstraint((PathConstraint)Constraints.oneOfValues((String)"Gene.proteins.comments.type", Arrays.asList(this.allowedCommentTypes)));
        return query;
    }

    private PathQuery proteinCommentsQuery(String proteinID, PathQuery query) {
        query.addViews(new String[]{"Protein.comments.description", "Protein.comments.type", "Protein.primaryIdentifier"});
        query.addOrderBy("Protein.comments.type", OrderDirection.ASC);
        query.addConstraint((PathConstraint)Constraints.eq((String)"Protein.id", (String)proteinID));
        query.addConstraint((PathConstraint)Constraints.oneOfValues((String)"Protein.comments.type", Arrays.asList(this.allowedCommentTypes)));
        return query;
    }
}

