/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.logic;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.upload.FormFile;
import org.intermine.api.InterMineAPI;
import org.intermine.bio.util.OrganismRepository;
import org.intermine.bio.web.logic.GenomicRegionSearchQueryRunner;
import org.intermine.bio.web.logic.GenomicRegionSearchUtil;
import org.intermine.bio.web.logic.OrganismGenomeBuildLookup;
import org.intermine.bio.web.model.ChromosomeInfo;
import org.intermine.bio.web.model.GenomicRegion;
import org.intermine.bio.web.model.GenomicRegionSearchConstraint;
import org.intermine.bio.web.struts.GenomicRegionSearchForm;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.ConstraintOp;
import org.intermine.metadata.Model;
import org.intermine.metadata.StringUtil;
import org.intermine.model.bio.Organism;
import org.intermine.model.bio.SequenceFeature;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.query.Constraint;
import org.intermine.objectstore.query.ConstraintSet;
import org.intermine.objectstore.query.ContainsConstraint;
import org.intermine.objectstore.query.FromElement;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryField;
import org.intermine.objectstore.query.QueryObjectReference;
import org.intermine.objectstore.query.QueryOrderable;
import org.intermine.objectstore.query.QueryReference;
import org.intermine.objectstore.query.QuerySelectable;
import org.intermine.objectstore.query.Results;
import org.intermine.objectstore.query.ResultsRow;
import org.intermine.pathquery.Constraints;
import org.intermine.pathquery.OrderDirection;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.logic.WebUtil;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.web.logic.session.SessionMethods;
import org.json.JSONObject;

public class GenomicRegionSearchService {
    private InterMineAPI interMineAPI = null;
    private Model model = null;
    private ObjectStore objectStore = null;
    private Properties webProperties = null;
    private WebConfig webConfig = null;
    private Map<String, String> classDescrs = null;
    private static String orgFeatureJSONString = null;
    private static final String GENOMIC_REGION_SEARCH_OPTIONS_DEFAULT = "genomic_region_search_options_default";
    private static final String GENOMIC_REGION_SEARCH_RESULTS_DEFAULT = "genomic_region_search_results_default";
    private static final int READ_AHEAD_CHARS = 10000;
    private GenomicRegionSearchConstraint grsc = null;
    private static Set<String> featureTypesInOrgs = null;
    private static Map<String, List<String>> featureTypeToSOTermMap = null;
    private static Map<String, String> orgTaxonIdMap = null;
    private List<String> selectionInfo = new ArrayList();
    public static final int DEFAULT_REGION_INIT_BATCH_SIZE = 10000;
    private int initBatchSize = 10000;
    private static final String CHROMOSOME_LOCATION_MISSING = "Chromosome location information is missing";
    private static final Logger LOG = Logger.getLogger(GenomicRegionSearchService.class);

    public void init(HttpServletRequest request) {
        this.webProperties = SessionMethods.getWebProperties((ServletContext)request.getSession().getServletContext());
        this.webConfig = SessionMethods.getWebConfig((HttpServletRequest)request);
        this.interMineAPI = SessionMethods.getInterMineAPI((HttpSession)request.getSession());
        this.model = this.interMineAPI.getModel();
        this.objectStore = this.interMineAPI.getObjectStore();
        this.classDescrs = (Map)request.getSession().getServletContext().getAttribute("classDescriptions");
        this.initBatchSize = this.getInitBatchSize();
    }

    public String setupWebData() throws Exception {
        long startTime = System.currentTimeMillis();
        String presetOrganisms = this.webProperties.getProperty("genomicRegionSearch.defaultOrganisms");
        ArrayList<Object> orgList = new ArrayList();
        long stepTime = System.currentTimeMillis();
        Set chrOrgSet = this.getChromosomeInfomationMap().keySet();
        long chrInfoMapTime = System.currentTimeMillis() - stepTime;
        if (chrOrgSet == null || chrOrgSet.size() == 0) {
            return CHROMOSOME_LOCATION_MISSING;
        }
        if (presetOrganisms == null || "".equals(presetOrganisms)) {
            orgList = new ArrayList(chrOrgSet);
        } else {
            List<String> presetOrgList = Arrays.asList(presetOrganisms.split(","));
            ArrayList<String> trimedPresetOrgList = new ArrayList<String>();
            for (String s : presetOrgList) {
                if ("".equals(s.trim())) continue;
                trimedPresetOrgList.add(s.trim());
            }
            TreeSet<String> chrOrgSetCopy = new TreeSet<String>();
            for (String s : chrOrgSet) {
                chrOrgSetCopy.add(s);
            }
            for (String o : trimedPresetOrgList) {
                if (!chrOrgSet.contains(o)) continue;
                chrOrgSetCopy.remove(o);
            }
            trimedPresetOrgList.retainAll(chrOrgSet);
            orgList.addAll(trimedPresetOrgList);
            orgList.addAll(chrOrgSetCopy);
        }
        long orgFeatureTypesTime = 0L;
        long featureTypeSoTermTime = 0L;
        long orgToTaxonTime = 0L;
        if (orgFeatureJSONString == null) {
            List excludedFeatureTypes = this.getExcludedFeatureTypes();
            stepTime = System.currentTimeMillis();
            Map orgFeatureTypes = this.getFeatureTypesForOrgs(orgList, excludedFeatureTypes);
            orgFeatureTypesTime = System.currentTimeMillis() - stepTime;
            stepTime = System.currentTimeMillis();
            this.getFeatureTypeToSOTermMap();
            featureTypeSoTermTime = System.currentTimeMillis() - stepTime;
            stepTime = System.currentTimeMillis();
            this.getOrganismToTaxonMap();
            orgToTaxonTime = System.currentTimeMillis() - stepTime;
            orgFeatureJSONString = this.buildJSONString(orgList, orgFeatureTypes);
        }
        LOG.info((Object)("REGION SEARCH INIT total time: " + (System.currentTimeMillis() - startTime) + "ms - getChromosomeInfomationMap: " + chrInfoMapTime + "ms, getFeatureTypesForOrgs: " + orgFeatureTypesTime + "ms, getFeatureTypeToSOTermMap: " + featureTypeSoTermTime + "ms, getOrganismToTaxonMap: " + orgToTaxonTime + "ms."));
        return orgFeatureJSONString;
    }

    private List<String> getExcludedFeatureTypes() {
        String excludedFeatureTypesProp = this.webProperties.getProperty("genomicRegionSearch.featureTypesExcluded.global");
        List<String> excludedFeatureTypes = new ArrayList<String>();
        excludedFeatureTypes = excludedFeatureTypesProp == null || "".equals(excludedFeatureTypesProp) ? null : Arrays.asList(excludedFeatureTypesProp.split("[, ]+"));
        return excludedFeatureTypes;
    }

    private Map<String, Set<String>> getFeatureTypesForOrgs(List<String> orgList, List<String> excludedFeatureTypes) {
        Query q = new Query();
        q.setDistinct(true);
        QueryClass qcOrg = new QueryClass(Organism.class);
        QueryClass qcFeature = new QueryClass(SequenceFeature.class);
        QueryField qfOrgName = new QueryField(qcOrg, "shortName");
        QueryField qfFeatureClass = new QueryField(qcFeature, "class");
        q.addToSelect((QuerySelectable)qfOrgName);
        q.addToSelect((QuerySelectable)qfFeatureClass);
        q.addFrom((FromElement)qcOrg);
        q.addFrom((FromElement)qcFeature);
        q.addToOrderBy((QueryOrderable)qfOrgName, "ascending");
        ConstraintSet constraints = new ConstraintSet(ConstraintOp.AND);
        q.setConstraint((Constraint)constraints);
        QueryObjectReference organism = new QueryObjectReference(qcFeature, "organism");
        ContainsConstraint ccOrg = new ContainsConstraint((QueryReference)organism, ConstraintOp.CONTAINS, qcOrg);
        constraints.addConstraint((Constraint)ccOrg);
        Results results = this.objectStore.execute(q, this.initBatchSize, true, true, true);
        LinkedHashMap<String, Set<String>> orgFeatureMap = new LinkedHashMap<String, Set<String>>();
        LinkedHashSet<String> featureTypeSet = new LinkedHashSet<String>();
        if (results != null && results.size() > 0) {
            for (ResultsRow row : results) {
                String org = (String)row.get(0);
                String featureType = ((Class)row.get(1)).getSimpleName();
                if ("Chromosome".equals(featureType) || !orgList.contains(org)) continue;
                if (orgFeatureMap.size() < 1) {
                    featureTypeSet.add(featureType);
                    orgFeatureMap.put(org, featureTypeSet);
                    continue;
                }
                if (orgFeatureMap.keySet().contains(org)) {
                    ((Set)orgFeatureMap.get(org)).add(featureType);
                    continue;
                }
                LinkedHashSet<String> s = new LinkedHashSet<String>();
                s.add(featureType);
                orgFeatureMap.put(org, s);
            }
            for (Set ftSet : orgFeatureMap.values()) {
                if (excludedFeatureTypes != null) {
                    ftSet.removeAll(excludedFeatureTypes);
                }
                if (featureTypesInOrgs == null) {
                    featureTypesInOrgs = new HashSet();
                }
                featureTypesInOrgs.addAll(ftSet);
            }
        }
        return orgFeatureMap;
    }

    private String buildJSONString(List<String> orgList, Map<String, Set<String>> resultsMap) {
        ArrayList ft = new ArrayList();
        ArrayList gb = new ArrayList();
        LinkedHashMap<String, List<Object>> ma = new LinkedHashMap<String, List<Object>>();
        for (Map.Entry<String, Set<String>> e : resultsMap.entrySet()) {
            LinkedHashMap<String, Object> mft = new LinkedHashMap<String, Object>();
            LinkedHashMap<String, String> mgb = new LinkedHashMap<String, String>();
            mft.put("organism", e.getKey());
            ArrayList featureTypeAndDespMapList = new ArrayList();
            for (String className : e.getValue()) {
                LinkedHashMap<String, String> featureTypeAndDespMap = new LinkedHashMap<String, String>();
                String des = "description not avaliable";
                if (featureTypeToSOTermMap.containsKey(className)) {
                    des = (String)((List)featureTypeToSOTermMap.get(className)).get(1);
                } else {
                    des = this.classDescrs.get(className) == null ? "description not avaliable" : (String)this.classDescrs.get(className);
                    des = des.replaceAll("'", "&apos;");
                    des = des.replaceAll("\"", "&quot;");
                }
                featureTypeAndDespMap.put("featureType", className);
                featureTypeAndDespMap.put("description", des);
                featureTypeAndDespMapList.add(featureTypeAndDespMap);
            }
            mft.put("features", featureTypeAndDespMapList);
            ft.add(mft);
            mgb.put("organism", e.getKey());
            mgb.put("genomeBuild", OrganismGenomeBuildLookup.getGenomeBuildbyOrgansimAbbreviation((String)e.getKey()) == null ? "not available" : OrganismGenomeBuildLookup.getGenomeBuildbyOrgansimAbbreviation((String)e.getKey()));
            gb.add(mgb);
        }
        ma.put("organisms", orgList);
        ma.put("genomeBuilds", gb);
        ma.put("featureTypes", ft);
        JSONObject jo = new JSONObject(ma);
        String preDataStr = jo.toString();
        return preDataStr;
    }

    public String getOptionsJavascript() {
        String optionsJavascriptName = this.webProperties.getProperty("genomicRegionSearch.optionsJavascript");
        if (optionsJavascriptName == null || "".equals(optionsJavascriptName)) {
            optionsJavascriptName = GENOMIC_REGION_SEARCH_OPTIONS_DEFAULT;
        }
        return optionsJavascriptName;
    }

    public String getResultsJavascript() {
        String resultsJavascriptName = this.webProperties.getProperty("genomicRegionSearch.resultsJavascript");
        if (resultsJavascriptName == null || "".equals(resultsJavascriptName)) {
            resultsJavascriptName = GENOMIC_REGION_SEARCH_RESULTS_DEFAULT;
        }
        return resultsJavascriptName;
    }

    public String getOptionsCss() {
        String optionsCssName = this.webProperties.getProperty("genomicRegionSearch.optionsCss");
        if (optionsCssName == null || "".equals(optionsCssName)) {
            optionsCssName = GENOMIC_REGION_SEARCH_OPTIONS_DEFAULT;
        }
        return optionsCssName;
    }

    public String getResultsCss() {
        String resultsCssName = this.webProperties.getProperty("genomicRegionSearch.resultsCss");
        if (resultsCssName == null || "".equals(resultsCssName)) {
            resultsCssName = GENOMIC_REGION_SEARCH_RESULTS_DEFAULT;
        }
        return resultsCssName;
    }

    private int getInitBatchSize() {
        String initBatchSizeStr = this.webProperties.getProperty("genomicRegionSearch.initBatchSize");
        if (initBatchSizeStr != null && !"".equals(initBatchSizeStr)) {
            try {
                return Integer.parseInt(initBatchSizeStr);
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)("Couldn't read integer value from 'genomicsRegionSearch.initBatchSize' property:" + initBatchSizeStr));
            }
        }
        return 10000;
    }

    public ActionMessage parseGenomicRegionSearchForm(GenomicRegionSearchForm grsForm) throws Exception {
        this.grsc = new GenomicRegionSearchConstraint();
        ActionMessage actmsg = this.parseBasicInput(grsForm);
        if (actmsg != null) {
            return actmsg;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ActionMessage parseBasicInput(GenomicRegionSearchForm grsForm) throws Exception {
        String organism = (String)grsForm.get("organism");
        String[] featureTypes = (String[])grsForm.get("featureTypes");
        String whichInput = (String)grsForm.get("whichInput");
        String dataFormat = (String)grsForm.get("dataFormat");
        FormFile formFile = (FormFile)grsForm.get("fileInput");
        String pasteInput = (String)grsForm.get("pasteInput");
        String extendedRegionSize = (String)grsForm.get("extendedRegionSize");
        boolean strandSpecific = grsForm.get("strandSpecific") != null;
        this.grsc.setOrgName(organism);
        this.grsc.setStrandSpecific(strandSpecific);
        if (Integer.parseInt(extendedRegionSize) < 0) {
            throw new Exception("extendedRegionSize can't be a negative value: " + extendedRegionSize);
        }
        this.grsc.setExtendedRegionSize(Integer.parseInt(extendedRegionSize));
        this.selectionInfo.add("<b>Selected organism: </b><i>" + organism + "</i>");
        if (featureTypes == null) {
            return new ActionMessage("genomicRegionSearch.spanFieldSelection", (Object)"feature types");
        }
        Set ftSet = this.getFeatureTypes(featureTypes, extendedRegionSize);
        this.grsc.setFeatureTypes(ftSet);
        BufferedReader reader = null;
        if ("paste".equals(whichInput)) {
            if (pasteInput == null || pasteInput.length() == 0) return new ActionMessage("genomicRegionSearch.noSpanFile");
            String trimmedText = pasteInput.trim();
            if (trimmedText.length() == 0) {
                return new ActionMessage("genomicRegionSearch.noSpanPaste");
            }
            reader = new BufferedReader(new StringReader(trimmedText));
        } else {
            if (!"file".equals(whichInput)) return new ActionMessage("genomicRegionSearch.spanInputType");
            if (formFile != null && formFile.getFileName() != null && formFile.getFileName().length() > 0) {
                String mimetype = formFile.getContentType();
                if (!"application/octet-stream".equals(mimetype) && !mimetype.startsWith("text")) {
                    return new ActionMessage("genomicRegionSearch.isNotText", (Object)mimetype);
                }
                if (formFile.getFileSize() == 0) {
                    return new ActionMessage("genomicRegionSearch.noSpanFileOrEmpty");
                }
                try {
                    reader = new BufferedReader(new InputStreamReader(formFile.getInputStream()));
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (reader == null) {
            return new ActionMessage("genomicRegionSearch.spanInputType");
        }
        try {
            reader.mark(10000);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        char[] buf = new char[10000];
        LinkedHashSet<String> spanStringSet = new LinkedHashSet<String>();
        try {
            String thisLine;
            int read = reader.read(buf, 0, 10000);
            for (int i = 0; i < read; ++i) {
                if (buf[i] != '\u0000') continue;
                return new ActionMessage("genomicRegionSearch.isNotText", (Object)"binary");
            }
            reader.reset();
            while ((thisLine = reader.readLine()) != null) {
                spanStringSet.add(thisLine);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ArrayList<GenomicRegion> spanList = new ArrayList<GenomicRegion>();
        for (String spanStr : spanStringSet) {
            String start;
            String[] spanItems;
            GenomicRegion aSpan = new GenomicRegion();
            aSpan.setOrganism(this.grsc.getOrgName());
            aSpan.setExtendedRegionSize(this.grsc.getExtendedRegionSize());
            String ddotsRegex = "^[^:]+: ?\\d+(,\\d+)*\\.{2}\\d+(,\\d+)*$";
            String ddotstagRegex = "^[^:]+: ?\\d+(,\\d+)*\\.{2}\\d+(,\\d+)*: ?\\d+$";
            String tabRegex = "^[^\\t\\s]+\\t\\d+(,\\d+)*\\t\\d+(,\\d+)*";
            String dashRegex = "^[^:]+: ?\\d+(,\\d+)*\\-\\d+(,\\d+)*$";
            String snpRegex = "^[^:]+: ?\\d+(,\\d+)*$";
            String emptyLine = "^\\s*$";
            if (Pattern.matches(ddotsRegex, spanStr)) {
                spanStr = spanStr.contains(",") ? spanStr.replaceAll(",", "") : spanStr;
                aSpan.setChr(spanStr.split(":")[0]);
                spanItems = spanStr.split(":")[1].split("\\..");
                start = spanItems[0].trim();
                if ("isInterBaseCoordinate".equals(dataFormat)) {
                    aSpan.setStart(Integer.valueOf(Integer.valueOf(start) + 1));
                } else {
                    aSpan.setStart(Integer.valueOf(start));
                }
                aSpan.setEnd(Integer.valueOf(spanItems[1]));
            } else if (Pattern.matches(ddotstagRegex, spanStr)) {
                spanStr = spanStr.contains(",") ? spanStr.replaceAll(",", "") : spanStr;
                aSpan.setChr(spanStr.split(":")[0]);
                spanItems = spanStr.split(":")[1].split("\\..");
                start = spanItems[0].trim();
                if ("isInterBaseCoordinate".equals(dataFormat)) {
                    aSpan.setStart(Integer.valueOf(Integer.valueOf(start) + 1));
                } else {
                    aSpan.setStart(Integer.valueOf(start));
                }
                aSpan.setEnd(Integer.valueOf(spanItems[1]));
                aSpan.setTag(Integer.valueOf(spanStr.split(":")[2]));
            } else if (Pattern.matches(tabRegex, spanStr)) {
                spanStr = spanStr.contains(",") ? spanStr.replaceAll(",", "") : spanStr;
                spanItems = spanStr.split("\t");
                aSpan.setChr(spanItems[0]);
                if ("isInterBaseCoordinate".equals(dataFormat)) {
                    aSpan.setStart(Integer.valueOf(Integer.valueOf(spanItems[1]) + 1));
                } else {
                    aSpan.setStart(Integer.valueOf(spanItems[1]));
                }
                aSpan.setEnd(Integer.valueOf(spanItems[2]));
            } else if (Pattern.matches(dashRegex, spanStr)) {
                spanStr = spanStr.contains(",") ? spanStr.replaceAll(",", "") : spanStr;
                aSpan.setChr(spanStr.split(":")[0]);
                spanItems = spanStr.split(":")[1].split("-");
                start = spanItems[0].trim();
                if ("isInterBaseCoordinate".equals(dataFormat)) {
                    aSpan.setStart(Integer.valueOf(Integer.valueOf(start) + 1));
                } else {
                    aSpan.setStart(Integer.valueOf(start));
                }
                aSpan.setEnd(Integer.valueOf(spanItems[1]));
            } else if (Pattern.matches(snpRegex, spanStr)) {
                spanStr = spanStr.contains(",") ? spanStr.replaceAll(",", "") : spanStr;
                aSpan.setChr(spanStr.split(":")[0]);
                String start2 = spanStr.split(":")[1].trim();
                if ("isInterBaseCoordinate".equals(dataFormat)) {
                    aSpan.setStart(Integer.valueOf(Integer.valueOf(start2) + 1));
                } else {
                    aSpan.setStart(Integer.valueOf(start2));
                }
                aSpan.setEnd(Integer.valueOf(spanStr.split(":")[1].trim()));
            } else if (!Pattern.matches(emptyLine, spanStr)) {
                return new ActionMessage("genomicRegionSearch.spanInWrongformat", (Object)spanStr);
            }
            spanList.add(aSpan);
        }
        this.grsc.setGenomicRegionList(spanList);
        return null;
    }

    private Set<Class<?>> getFeatureTypes(String[] featureTypes, String extendedRegionSize) {
        HashSet ftSet = new HashSet();
        for (String f : featureTypes) {
            ClassDescriptor cld = this.model.getClassDescriptorByName(f);
            ftSet.add(cld.getType());
            for (ClassDescriptor subCld : this.model.getAllSubs(cld)) {
                ftSet.add(subCld.getType());
            }
        }
        String ftString = "";
        for (String aFeaturetype : featureTypes) {
            aFeaturetype = WebUtil.formatPath((String)aFeaturetype, (InterMineAPI)this.interMineAPI, (WebConfig)this.webConfig);
            ftString = ftString + aFeaturetype + ", ";
        }
        this.selectionInfo.add("<b>Selected feature types: </b>" + ftString.substring(0, ftString.lastIndexOf(", ")));
        if (Integer.parseInt(extendedRegionSize) > 0) {
            if (Integer.parseInt(extendedRegionSize) >= 1000 && Integer.parseInt(extendedRegionSize) < 1000000) {
                this.selectionInfo.add("<b>Extend Regions: </b>" + new DecimalFormat("#.##").format((float)Integer.parseInt(extendedRegionSize) / 1000.0f) + " kbp");
            } else if (Integer.parseInt(extendedRegionSize) >= 1000000) {
                this.selectionInfo.add("<b>Extend Regions: </b>" + new DecimalFormat("#.##").format((float)Integer.parseInt(extendedRegionSize) / 1000000.0f) + " Mbp");
            } else {
                this.selectionInfo.add("<b>Extend Regions: </b>" + extendedRegionSize + "bp");
            }
        }
        return ftSet;
    }

    public Map<GenomicRegion, Query> createQueryList() {
        return GenomicRegionSearchUtil.createQueryList((Collection)this.grsc.getGenomicRegionList(), (int)this.grsc.getExtendedRegionSize(), (String)this.grsc.getOrgName(), (Set)this.grsc.getFeatureTypes(), (boolean)this.grsc.getStrandSpecific());
    }

    public GenomicRegionSearchConstraint getConstraint() {
        return this.grsc;
    }

    public Map<String, Map<String, ChromosomeInfo>> getChromosomeInfomationMap() {
        return GenomicRegionSearchQueryRunner.getChromosomeInfo((InterMineAPI)this.interMineAPI, (int)this.initBatchSize);
    }

    public Map<String, List<String>> getFeatureTypeToSOTermMap() {
        if (featureTypeToSOTermMap == null) {
            featureTypeToSOTermMap = GenomicRegionSearchQueryRunner.getFeatureAndSOInfo((InterMineAPI)this.interMineAPI, (Map)this.classDescrs, (int)this.initBatchSize);
            if (featureTypesInOrgs.size() != featureTypeToSOTermMap.size() || !featureTypesInOrgs.containsAll(featureTypeToSOTermMap.keySet())) {
                HashMap<String, List> newFeatureTypeToSOTermMap = new HashMap<String, List>();
                for (String ft : featureTypesInOrgs) {
                    if (featureTypeToSOTermMap.keySet().contains(ft)) {
                        newFeatureTypeToSOTermMap.put(ft, (List)featureTypeToSOTermMap.get(ft));
                        continue;
                    }
                    ArrayList<String> ftInfo = new ArrayList<String>();
                    ftInfo.add(ft);
                    String des = this.classDescrs.get(ft) == null ? "description not avaliable" : (String)this.classDescrs.get(ft);
                    des = des.replaceAll("'", "&apos;");
                    des = des.replaceAll("\"", "&quot;");
                    ftInfo.add(des);
                    newFeatureTypeToSOTermMap.put(ft, ftInfo);
                }
                featureTypeToSOTermMap = newFeatureTypeToSOTermMap;
            }
        }
        return featureTypeToSOTermMap;
    }

    public Map<String, String> getOrganismToTaxonMap() {
        if (orgTaxonIdMap == null) {
            orgTaxonIdMap = GenomicRegionSearchQueryRunner.getTaxonInfo((InterMineAPI)this.interMineAPI, (int)this.initBatchSize);
        }
        return orgTaxonIdMap;
    }

    public Map<String, List<GenomicRegion>> validateGenomicRegions() throws Exception {
        HashMap<String, List<GenomicRegion>> resultMap = new HashMap<String, List<GenomicRegion>>();
        ArrayList<GenomicRegion> passedSpanList = new ArrayList<GenomicRegion>();
        ArrayList<GenomicRegion> errorSpanList = new ArrayList<GenomicRegion>();
        Map chrInfo = (Map)this.getChromosomeInfomationMap().get(this.grsc.getOrgName());
        if (chrInfo == null) {
            throw new Exception("ChromosomeInfo map should not be null");
        }
        for (GenomicRegion gr : this.grsc.getGenomicRegionList()) {
            ChromosomeInfo ci = null;
            if (gr == null || gr.getChr() == null) continue;
            String chr = gr.getChr().toLowerCase();
            if (chrInfo.containsKey(chr)) {
                ci = (ChromosomeInfo)chrInfo.get(chr);
            } else {
                if (!chr.startsWith("chr") || !chrInfo.containsKey(chr.substring(3))) continue;
                ci = (ChromosomeInfo)chrInfo.get(chr.substring(3));
            }
            boolean passed = false;
            if (gr.getStart() > gr.getEnd()) {
                gr.setChr(ci.getChrPID());
                Integer grStart = gr.getStart();
                Integer grEnd = gr.getEnd();
                gr.setStart(grEnd);
                gr.setEnd(grStart);
                gr.setMinusStrand(Boolean.TRUE);
                if (gr.getStart() < 1) {
                    gr.setStart(Integer.valueOf(1));
                }
                passedSpanList.add(gr);
                passed = true;
            } else {
                gr.setChr(ci.getChrPID());
                if (gr.getStart() < 1) {
                    gr.setStart(Integer.valueOf(1));
                }
                gr.setMinusStrand(Boolean.FALSE);
                passedSpanList.add(gr);
                passed = true;
            }
            if (passed) continue;
            errorSpanList.add(gr);
        }
        resultMap.put("pass", passedSpanList);
        resultMap.put("error", errorSpanList);
        return resultMap;
    }

    public List<String> getSelectionInformation() {
        return this.selectionInfo;
    }

    public String getGenomicRegionOrganismConstraint(String spanUUIDString, Map<GenomicRegionSearchConstraint, String> spanConstraintMap) {
        for (Map.Entry<GenomicRegionSearchConstraint, String> e : spanConstraintMap.entrySet()) {
            if (!e.getValue().equals(spanUUIDString)) continue;
            return e.getKey().getOrgName();
        }
        return null;
    }

    public int getGenomicRegionExtendedSizeConstraint(String spanUUIDString, Map<GenomicRegionSearchConstraint, String> spanConstraintMap) {
        for (Map.Entry<GenomicRegionSearchConstraint, String> e : spanConstraintMap.entrySet()) {
            if (!e.getValue().equals(spanUUIDString)) continue;
            return e.getKey().getExtendedRegionSize();
        }
        return 0;
    }

    public Set<Integer> getGenomicRegionOverlapFeaturesAsSet(String grInfo, Map<GenomicRegion, List<List<String>>> resultMap) throws Exception {
        LinkedHashSet<Integer> featureIdSet = new LinkedHashSet<Integer>();
        GenomicRegion grToExport = (GenomicRegion)GenomicRegionSearchUtil.generateGenomicRegions(Arrays.asList(grInfo)).get(0);
        for (List<String> sf : resultMap.get(grToExport)) {
            featureIdSet.add(Integer.valueOf(sf.get(0)));
        }
        return featureIdSet;
    }

    public Set<Integer> getGenomicRegionOverlapFeaturesByType(String grInfo, Map<GenomicRegion, List<List<String>>> resultMap, String featureType) throws Exception {
        LinkedHashSet<Integer> featureIdSet = new LinkedHashSet<Integer>();
        GenomicRegion grToExport = (GenomicRegion)GenomicRegionSearchUtil.generateGenomicRegions(Arrays.asList(grInfo)).get(0);
        for (List<String> sf : resultMap.get(grToExport)) {
            if (!sf.get(3).equals(featureType)) continue;
            featureIdSet.add(Integer.valueOf(sf.get(0)));
        }
        return featureIdSet;
    }

    public Set<Integer> getAllGenomicRegionOverlapFeaturesByType(Map<GenomicRegion, List<List<String>>> resultMap, String featureType) {
        LinkedHashSet<Integer> featureIdSet = new LinkedHashSet<Integer>();
        for (Map.Entry<GenomicRegion, List<List<String>>> e : resultMap.entrySet()) {
            if (e.getValue() == null) continue;
            for (List<String> sf : e.getValue()) {
                if (!sf.get(3).equals(featureType)) continue;
                featureIdSet.add(Integer.valueOf(sf.get(0)));
            }
        }
        return featureIdSet;
    }

    public String getGenomicRegionOverlapFeaturesAsString(String grInfo, Map<GenomicRegion, List<List<String>>> resultMap) throws Exception {
        Set featureSet = this.getGenomicRegionOverlapFeaturesAsSet(grInfo, resultMap);
        return StringUtil.join((Collection)featureSet, (String)",");
    }

    public String isEmptyFeature(Map<GenomicRegion, List<List<String>>> resultMap) {
        for (List<List<String>> l : resultMap.values()) {
            if (l == null) continue;
            return "hasFeature";
        }
        return "emptyFeature";
    }

    public String generateCreateListHtml(Map<GenomicRegion, List<List<String>>> resultMap) {
        TreeSet<String> ftSet = new TreeSet<String>();
        for (List<List<String>> l : resultMap.values()) {
            if (l == null) continue;
            for (List<String> feature : l) {
                ftSet.add(feature.get(3));
            }
        }
        String clHtml = " Create list by feature type:<select id=\"all-regions\" style=\"margin: 4px 3px\">";
        for (String ft : ftSet) {
            clHtml = clHtml + "<option value=\"" + ft + "\">" + WebUtil.formatPath((String)ft, (InterMineAPI)this.interMineAPI, (WebConfig)this.webConfig) + "</option>";
        }
        clHtml = clHtml + "</select>";
        clHtml = clHtml + "<button onClick=\"javascript:createList('all','all-regions');\">Go</button>";
        return clHtml;
    }

    public String convertResultMapToHTML(Map<GenomicRegion, List<List<String>>> resultMap, Map<GenomicRegion, Map<String, Integer>> resultStat, List<GenomicRegion> genomicRegionList, int fromIdx, int toIdx, HttpSession session) {
        int maxRecordCutOff = 1000;
        if (this.webProperties.getProperty("genomicRegionSearch.maxRecordCutOff") != null) {
            maxRecordCutOff = Integer.valueOf(this.webProperties.getProperty("genomicRegionSearch.maxRecordCutOff"));
        }
        String baseURL = this.webProperties.getProperty("webapp.baseurl");
        String path = this.webProperties.getProperty("webapp.path");
        String galaxyDisplay = this.webProperties.getProperty("galaxy.display");
        String exportChromosomeSegment = this.webProperties.getProperty("genomicRegionSearch.exportChromosomeSegment");
        List<GenomicRegion> subGenomicRegionList = genomicRegionList.subList(fromIdx, toIdx + 1);
        StringBuffer sb = new StringBuffer();
        sb.append("<thead><tr valign=\"middle\">");
        sb.append("<th align=\"center\">Genome Region</th>");
        sb.append("<th align=\"center\">Feature</th>");
        sb.append("<th align=\"center\">Feature Type</th>");
        sb.append("<th align=\"center\">Location</th>");
        sb.append("</tr></thead>");
        sb.append("<tbody>");
        for (GenomicRegion s : subGenomicRegionList) {
            String span;
            List<List<String>> features = resultMap.get(s);
            Map<String, Integer> stat = resultStat.get(s);
            String ftHtml = "";
            Set ftSet = null;
            LinkedHashMap<String, Integer> aboveCutOffFeatureTypeMap = null;
            if (stat != null) {
                ftHtml = this.categorizeFeatureTypes(stat.keySet(), s);
                ftSet = this.getFeatureTypeSetInAlphabeticalOrder(stat.keySet());
                aboveCutOffFeatureTypeMap = new LinkedHashMap<String, Integer>();
                int topCount = stat.values().iterator().next();
                if (topCount >= maxRecordCutOff) {
                    for (Map.Entry<String, Integer> e : stat.entrySet()) {
                        if (e.getValue() <= maxRecordCutOff) break;
                        aboveCutOffFeatureTypeMap.put(e.getKey(), e.getValue());
                    }
                }
            }
            String string = span = s.getExtendedRegionSize() == 0 ? s.getOriginalRegion() : s.getExtendedRegion();
            if (features != null) {
                if (aboveCutOffFeatureTypeMap == null || aboveCutOffFeatureTypeMap.size() == 0) {
                    int length = features.size();
                    this.addFirstFeatures(baseURL, path, galaxyDisplay, exportChromosomeSegment, sb, s, features, ftHtml, ftSet, span, length);
                    for (int i = 1; i < length; ++i) {
                        this.addFeaturesAboveCutoff(baseURL, path, sb, features, i);
                    }
                    continue;
                }
                int length = this.addFeaturesAboveCutoff(galaxyDisplay, exportChromosomeSegment, sb, s, features, ftHtml, ftSet, aboveCutOffFeatureTypeMap, span);
                this.parseFeaturesAboveCutoff(sb, s, aboveCutOffFeatureTypeMap);
                this.parseFeaturesBelowCutoff(baseURL, path, sb, features, aboveCutOffFeatureTypeMap, length);
                continue;
            }
            sb.append("<tr><td><b>" + span + "</b></td><td colspan='3'><i>No overlap features found</i></td></tr>");
        }
        sb.append("</tbody>");
        return sb.toString();
    }

    private void addFirstFeatures(String baseURL, String path, String galaxyDisplay, String exportChromosomeSegment, StringBuffer sb, GenomicRegion s, List<List<String>> features, String ftHtml, Set<String> ftSet, String span, int length) {
        List<String> firstFeature = features.get(0);
        String firstId = firstFeature.get(0);
        String firstPid = firstFeature.get(1);
        String firstSymbol = firstFeature.get(2);
        String firstFeatureType = firstFeature.get(3);
        String firstChr = firstFeature.get(4);
        String firstStart = firstFeature.get(5);
        String firstEnd = firstFeature.get(6);
        String loc = firstChr + ":" + firstStart + ".." + firstEnd;
        String firstSoTerm = WebUtil.formatPath((String)firstFeatureType, (InterMineAPI)this.interMineAPI, (WebConfig)this.webConfig);
        String firstSoTermDes = firstFeatureType;
        if (featureTypeToSOTermMap.get(firstFeatureType) != null) {
            firstSoTermDes = (String)((List)featureTypeToSOTermMap.get(firstFeatureType)).get(1);
        }
        sb.append("<tr><td valign='top' rowspan='" + length + "'>");
        if (this.isJBrowseEnabled()) {
            sb.append("<b><a title='view region in genome browser' target='genome-browser' href='" + this.generateJBrowseURL(s) + "'>" + span + "</a></b>");
        } else {
            sb.append("<b>" + span + "</b>");
        }
        sb.append("<br>");
        if (!"false".equals(exportChromosomeSegment)) {
            sb.append("<span style=\"padding: 10px;\">Export sequence for entire region: <a href='javascript: exportFeatures(\"" + s.getFullRegionInfo() + "\", \"\", \"chrSeg\");'><img title=\"Export sequence for entire region\" class=\"fasta\" src=\"model/images/fasta.gif\"></a></span>");
        }
        sb.append("<br>");
        if (s.getExtendedRegionSize() != 0) {
            String os = s.getOriginalRegion();
            sb.append("<i>Original input: " + os + "</i><br>");
        }
        String facet = "SequenceFeature";
        if (ftSet != null && ftSet.size() == 1) {
            facet = ftSet.iterator().next();
        }
        sb.append("<div style='align:center; padding:8px 0 4px 0;'><span class='tab export-region'><a title='Export features in this region in tab-delimited format' href='javascript: exportFeatures(\"" + s.getFullRegionInfo() + "\", \"" + facet + "\", \"tab\");'></a></span><span class='csv export-region'><a title='Export features in this region in comma-delimited format' href='javascript: exportFeatures(\"" + s.getFullRegionInfo() + "\", \"" + facet + "\", \"csv\");'></a></span><span class='gff3 export-region'><a title='Export features in this region in GFF3 format' href='javascript: exportFeatures(\"" + s.getFullRegionInfo() + "\", \"" + facet + "\", \"gff3\");'></a></span><span class='bed export-region'><a title='Export features in this region in BED format' href='javascript: exportFeatures(\"" + s.getFullRegionInfo() + "\", \"" + facet + "\", \"bed\");'></a></span><span class='fasta export-region'><a title='Export features in this region as individual sequences' href='javascript: exportFeatures(\"" + s.getFullRegionInfo() + "\", \"" + facet + "\", \"sequence\");'></a></span>");
        if (!"false".equals(galaxyDisplay)) {
            sb.append("<span class='galaxy export-region'><a title='Export data to Galaxy' href='javascript: exportToGalaxy(\"" + s.getFullRegionInfo() + "\");'></a></span>");
        }
        sb.append("</div>");
        sb.append(ftHtml);
        sb.append("</td>");
        sb.append("<td><a target='' title='' href='" + baseURL + "/" + path + "/report.do?id=" + firstId + "'>");
        if ((firstSymbol == null || "".equals(firstSymbol)) && (firstPid == null || "".equals(firstPid))) {
            sb.append("<i>unknown identifier</i>");
        } else if ((firstSymbol == null || "".equals(firstSymbol)) && firstPid != null && "".equals(firstPid)) {
            sb.append("<span style='font-size: 11px;'>" + firstPid + "</span>");
        } else if (firstSymbol != null && "".equals(firstSymbol) && (firstPid == null || "".equals(firstPid))) {
            sb.append("<strong>" + firstSymbol + "</strong>");
        } else {
            sb.append("<strong>" + firstSymbol + "</strong>").append(" ").append("<span style='font-size: 11px;'>" + firstPid + "</span>");
        }
        sb.append("</a></td><td>" + firstSoTerm + "<a onclick=\"document.getElementById('ctxHelpTxt').innerHTML='" + firstSoTerm + ": " + firstSoTermDes.replaceAll("&apos;", "\\\\'") + "';document.getElementById('ctxHelpDiv').style.display='';window.scrollTo(0, 0);return false\" title=\"" + firstSoTermDes + "\"><img class=\"tinyQuestionMark\" src=\"images/icons/information-small-blue.png\" alt=\"?\"></a></td><td>" + loc + "</td></tr>");
    }

    private int addFeaturesAboveCutoff(String galaxyDisplay, String exportChromosomeSegment, StringBuffer sb, GenomicRegion s, List<List<String>> features, String ftHtml, Set<String> ftSet, Map<String, Integer> aboveCutOffFeatureTypeMap, String span) {
        int length = features.size();
        String firstFeatureType = aboveCutOffFeatureTypeMap.keySet().iterator().next();
        String firstSoTerm = WebUtil.formatPath((String)firstFeatureType, (InterMineAPI)this.interMineAPI, (WebConfig)this.webConfig);
        String firstSoTermDes = firstFeatureType;
        if (featureTypeToSOTermMap.get(firstFeatureType) != null) {
            firstSoTermDes = (String)((List)featureTypeToSOTermMap.get(firstFeatureType)).get(1);
        }
        int totalDupCount = 0;
        for (String ft : aboveCutOffFeatureTypeMap.keySet()) {
            totalDupCount += aboveCutOffFeatureTypeMap.get(ft).intValue();
        }
        int rowSpan = length - totalDupCount + aboveCutOffFeatureTypeMap.size();
        sb.append("<tr><td valign='top' rowspan='" + rowSpan + "'>");
        if (this.isJBrowseEnabled()) {
            sb.append("<b><a title='view region in genome browser' target='genome-browser' href='" + this.generateJBrowseURL(s) + "'>" + span + "</a></b>");
        } else {
            sb.append("<b>" + span + "</b>");
        }
        sb.append("<br>");
        if (!"false".equals(exportChromosomeSegment)) {
            sb.append("<span style=\"padding: 10px;\">Export sequence for entire region: <a href='javascript: exportFeatures(\"" + s.getFullRegionInfo() + "\", \"\", \"chrSeg\");'><img title=\"export chromosome region as FASTA\" class=\"fasta\" src=\"model/images/fasta.gif\"></a></span>");
        }
        sb.append("<br>");
        if (s.getExtendedRegionSize() != 0) {
            String os = s.getOriginalRegion();
            sb.append("<i>Original input: " + os + "</i><br>");
        }
        String facet = "SequenceFeature";
        if (ftSet != null && ftSet.size() == 1) {
            facet = ftSet.iterator().next();
        }
        sb.append("<div style='align:center; padding:8px 0 4px 0;'><span class='tab export-region'><a title='Export features in this region in tab-delimited format' href='javascript: exportFeatures(\"" + s.getFullRegionInfo() + "\", \"" + facet + "\", \"tab\");'></a></span><span class='csv export-region'><a title='Export features in this region in comma-delimited format' href='javascript: exportFeatures(\"" + s.getFullRegionInfo() + "\", \"" + facet + "\", \"csv\");'></a></span><span class='gff3 export-region'><a title='Export features in this region in GFF3 format' href='javascript: exportFeatures(\"" + s.getFullRegionInfo() + "\", \"" + facet + "\", \"gff3\");'></a></span><span class='bed export-region'><a title='Export features in this region in BED format' href='javascript: exportFeatures(\"" + s.getFullRegionInfo() + "\", \"" + facet + "\", \"bed\");'></a></span><span class='fasta export-region'><a title='Export features in this region as individual sequences' href='javascript: exportFeatures(\"" + s.getFullRegionInfo() + "\", \"" + facet + "\", \"sequence\");'></a></span>");
        if (!"false".equals(galaxyDisplay)) {
            sb.append("<span class='galaxy export-region'><a href='javascript: exportToGalaxy(\"" + s.getFullRegionInfo() + "\");'></a></span>");
        }
        sb.append("</div>");
        sb.append(ftHtml);
        sb.append("</td>");
        int firstRecordCount = aboveCutOffFeatureTypeMap.get(firstFeatureType);
        sb.append("<td colspan='3'><b>" + firstRecordCount + "</b> " + firstSoTerm + "<a onclick=\"document.getElementById('ctxHelpTxt').innerHTML='" + firstSoTerm + ": " + firstSoTermDes.replaceAll("&apos;", "\\\\'") + "';document.getElementById('ctxHelpDiv').style.display='';window.scrollTo(0, 0);return false\" title=\"" + firstSoTermDes + "\"><img class=\"tinyQuestionMark\" src=\"images/icons/information-small-blue.png\" alt=\"?\"></a> records (too many to display all), please <a href=\"javascript: createList('" + s.getFullRegionInfo() + "', " + null + ", '" + firstFeatureType + "');\">create a list</a>");
        if (this.hasJBrowseTrack(firstFeatureType)) {
            String jbrowseUrl = this.generateJBrowseURL(s, Arrays.asList(firstFeatureType));
            sb.append(" or <a target='genome-browser' href='" + jbrowseUrl + "'>view in JBrowse</a>");
        }
        sb.append("</td></tr>");
        return length;
    }

    private void addFeaturesAboveCutoff(String baseURL, String path, StringBuffer sb, List<List<String>> features, int i) {
        String id = features.get(i).get(0);
        String pid = features.get(i).get(1);
        String symbol = features.get(i).get(2);
        String featureType = features.get(i).get(3);
        String chr = features.get(i).get(4);
        String start = features.get(i).get(5);
        String end = features.get(i).get(6);
        String soTerm = WebUtil.formatPath((String)featureType, (InterMineAPI)this.interMineAPI, (WebConfig)this.webConfig);
        String soTermDes = featureType;
        if (featureTypeToSOTermMap.get(featureType) != null) {
            soTermDes = (String)((List)featureTypeToSOTermMap.get(featureType)).get(1);
        }
        String location = chr + ":" + start + ".." + end;
        sb.append("<tr><td><a target='' title='' href='" + baseURL + "/" + path + "/report.do?id=" + id + "'>");
        if ((symbol == null || "".equals(symbol)) && (pid == null || "".equals(pid))) {
            sb.append("<i>unknown identifier</i>");
        } else if ((symbol == null || "".equals(symbol)) && pid != null && "".equals(pid)) {
            sb.append("<span style='font-size: 11px;'>" + pid + "</span>");
        } else if (symbol != null && "".equals(symbol) && (pid == null || "".equals(pid))) {
            sb.append("<strong>" + symbol + "</strong>");
        } else {
            sb.append("<strong>" + symbol + "</strong>").append(" ").append("<span style='font-size: 11px;'>" + pid + "</span>");
        }
        sb.append("</a></td><td>" + soTerm + "<a onclick=\"document.getElementById('ctxHelpTxt').innerHTML='" + soTerm + ": " + soTermDes.replaceAll("&apos;", "\\\\'") + "';document.getElementById('ctxHelpDiv').style.display='';window.scrollTo(0, 0);return false\" title=\"" + soTermDes + "\"><img class=\"tinyQuestionMark\" src=\"images/icons/information-small-blue.png\" alt=\"?\"></a></td><td>" + location + "</td></tr>");
    }

    private void parseFeaturesBelowCutoff(String baseURL, String path, StringBuffer sb, List<List<String>> features, Map<String, Integer> aboveCutOffFeatureTypeMap, int length) {
        for (int i = 0; i < length; ++i) {
            String id = features.get(i).get(0);
            String pid = features.get(i).get(1);
            String symbol = features.get(i).get(2);
            String featureType = features.get(i).get(3);
            String chr = features.get(i).get(4);
            String start = features.get(i).get(5);
            String end = features.get(i).get(6);
            String soTerm = WebUtil.formatPath((String)featureType, (InterMineAPI)this.interMineAPI, (WebConfig)this.webConfig);
            String soTermDes = featureType;
            if (featureTypeToSOTermMap.get(featureType) != null) {
                soTermDes = (String)((List)featureTypeToSOTermMap.get(featureType)).get(1);
            }
            String location = chr + ":" + start + ".." + end;
            if (aboveCutOffFeatureTypeMap.keySet().contains(featureType)) continue;
            sb.append("<tr><td><a target='' title='' href='" + baseURL + "/" + path + "/report.do?id=" + id + "'>");
            if ((symbol == null || "".equals(symbol)) && (pid == null || "".equals(pid))) {
                sb.append("<i>unknown identifier</i>");
            } else if ((symbol == null || "".equals(symbol)) && pid != null && "".equals(pid)) {
                sb.append("<span style='font-size: 11px;'>" + pid + "</span>");
            } else if (symbol != null && "".equals(symbol) && (pid == null || "".equals(pid))) {
                sb.append("<strong>" + symbol + "</strong>");
            } else {
                sb.append("<strong>" + symbol + "</strong>").append(" ").append("<span style='font-size: 11px;'>" + pid + "</span>");
            }
            sb.append("</a></td><td>" + soTerm + "<a onclick=\"document.getElementById('ctxHelpTxt').innerHTML='" + soTerm + ": " + soTermDes.replaceAll("&apos;", "\\\\'") + "';document.getElementById('ctxHelpDiv').style.display='';window.scrollTo(0, 0);return false\" title=\"" + soTermDes + "\"><img class=\"tinyQuestionMark\" src=\"images/icons/information-small-blue.png\" alt=\"?\"></a></td><td>" + location + "</td></tr>");
        }
    }

    private void parseFeaturesAboveCutoff(StringBuffer sb, GenomicRegion s, Map<String, Integer> aboveCutOffFeatureTypeMap) {
        if (aboveCutOffFeatureTypeMap.size() > 1) {
            ArrayList<String> aboveCutOffFeatureTypeList = new ArrayList<String>(aboveCutOffFeatureTypeMap.keySet());
            for (int i = 1; i < aboveCutOffFeatureTypeList.size(); ++i) {
                String featureType = (String)aboveCutOffFeatureTypeList.get(i);
                String soTerm = WebUtil.formatPath((String)featureType, (InterMineAPI)this.interMineAPI, (WebConfig)this.webConfig);
                String soTermDes = featureType;
                if (featureTypeToSOTermMap.get(featureType) != null) {
                    soTermDes = (String)((List)featureTypeToSOTermMap.get(featureType)).get(1);
                }
                int recordCount = aboveCutOffFeatureTypeMap.get(featureType);
                sb.append("<tr><td colspan='3'><b>" + recordCount + "</b> " + soTerm + "<a onclick=\"document.getElementById('ctxHelpTxt').innerHTML='" + soTerm + ": " + soTermDes.replaceAll("&apos;", "\\\\'") + "';document.getElementById('ctxHelpDiv').style.display='';window.scrollTo(0, 0);return false\" title=\"" + soTermDes + "\"><img class=\"tinyQuestionMark\" src=\"images/icons/information-small-blue.png\" alt=\"?\"></a> records (too many to display all), please <a href=\"javascript: createList('" + s.getFullRegionInfo() + "', " + null + ", '" + featureType + "');\">create a list</a></td></tr>");
            }
        }
    }

    public String categorizeFeatureTypes(Set<String> featureSet, GenomicRegion s) {
        String id = s.getChr() + "-" + s.getStart() + "-" + s.getEnd();
        Set ftSet = this.getFeatureTypeSetInAlphabeticalOrder(featureSet);
        if (ftSet == null) {
            return "";
        }
        String ftHtml = "<div>Create List by<select id=\"" + id + "\" style=\"margin: 4px 3px\">";
        for (String ft : ftSet) {
            ftHtml = ftHtml + "<option value=\"" + ft + "\">" + WebUtil.formatPath((String)ft, (InterMineAPI)this.interMineAPI, (WebConfig)this.webConfig) + "</option>";
        }
        ftHtml = ftHtml + "</select>";
        ftHtml = ftHtml + "<button onClick=\"javascript: createList('" + s.getFullRegionInfo() + "', '" + id + "');\">Go</button>";
        ftHtml = ftHtml + "</div>";
        return ftHtml;
    }

    public Set<String> getFeatureTypeSetInAlphabeticalOrder(Set<String> featureSet) {
        return new TreeSet<String>(featureSet);
    }

    protected String getMatchedBaseCount(GenomicRegion gr, List<String> r) {
        int spanStart = gr.getStart();
        int spanEnd = gr.getEnd();
        int featureStart = Integer.valueOf(r.get(3));
        int featureEnd = Integer.valueOf(r.get(4));
        int matchedBaseCount = 0;
        if (featureStart <= spanStart && featureEnd >= spanStart && featureEnd <= spanEnd) {
            matchedBaseCount = featureEnd - spanStart + 1;
        }
        if (featureStart >= spanStart && featureStart <= spanEnd && featureEnd >= spanEnd) {
            matchedBaseCount = spanEnd - featureStart + 1;
        }
        if (featureStart >= spanStart && featureEnd <= spanEnd) {
            matchedBaseCount = featureEnd - featureStart + 1;
        }
        if (featureStart <= spanStart && featureEnd >= spanEnd) {
            matchedBaseCount = spanEnd - spanStart + 1;
        }
        return String.valueOf(matchedBaseCount);
    }

    public PathQuery getExportFeaturesQuery(Set<Integer> featureIds, String featureType, Set<String> views, List<String> sortOrder) {
        PathQuery q = new PathQuery(this.model);
        String path = featureType;
        if (views == null) {
            q.addView(path + ".primaryIdentifier");
            q.addView(path + ".symbol");
            q.addView(path + ".chromosomeLocation.locatedOn.primaryIdentifier");
            q.addView(path + ".chromosomeLocation.start");
            q.addView(path + ".chromosomeLocation.end");
            q.addView(path + ".organism.name");
            q.addOrderBy(path + ".chromosomeLocation.start", OrderDirection.ASC);
        } else {
            for (String view : views) {
                q.addView(view.trim().replace("{0}", path));
            }
            String orderPath = sortOrder.get(0);
            String direction = sortOrder.get(1);
            if ("asc".equals(direction)) {
                q.addOrderBy(orderPath.trim().replace("{0}", path), OrderDirection.ASC);
            } else if ("desc".equals(direction)) {
                q.addOrderBy(orderPath.trim().replace("{0}", path), OrderDirection.DESC);
            }
        }
        q.addConstraint((PathConstraint)Constraints.inIds((String)featureType, featureIds), "A");
        return q;
    }

    public Set<String> getTaxonIds(Set<String> organisms) {
        HashSet<String> taxIds = new HashSet<String>();
        for (String org : organisms) {
            taxIds.add((String)this.getOrganismToTaxonMap().get(org));
        }
        return taxIds;
    }

    public boolean isJBrowseEnabled() {
        String display = this.webProperties.getProperty("genomicRegionSearch.jbrowse.display");
        return display != null && "true".equals(display = display.trim());
    }

    public Map<String, String> getJBrowseTracks() {
        String jbTracks = this.webProperties.getProperty("genomicRegionSearch.jbrowse.tracks").trim();
        if (jbTracks == null || "".equals(jbTracks)) {
            return null;
        }
        String[] tracks = jbTracks.split("\\|");
        HashMap<String, String> trackMap = new HashMap<String, String>();
        for (String track : tracks) {
            trackMap.put(track.split(":")[1], track.split(":")[0]);
        }
        return trackMap;
    }

    public boolean hasJBrowseTrack(String featureType) {
        return this.isJBrowseEnabled() && this.getJBrowseTracks().get(featureType.toLowerCase()) != null;
    }

    public String generateJBrowseURL(GenomicRegion s, List<String> featureTypes) {
        String taxonId = OrganismRepository.getOrganismRepository().getOrganismDataByShortName(s.getOrganism()).getTaxonId();
        String orgPrefix = this.webProperties.getProperty("genomicRegionSearch.jbrowse." + taxonId).trim();
        String chrPattern = this.webProperties.getProperty("genomicRegionSearch.jbrowse.chrPattern").trim();
        chrPattern = chrPattern.replace("{0}", orgPrefix);
        chrPattern = chrPattern.replace("{1}", s.getChr());
        String jbrowseBaseUrl = this.webProperties.getProperty("genomicRegionSearch.jbrowse.url").trim();
        String jbUrl = s.getExtendedRegionSize() == 0 ? jbrowseBaseUrl + "?loc=" + chrPattern + ":" + s.getStart() + ".." + s.getEnd() : jbrowseBaseUrl + "?loc=" + chrPattern + ":" + s.getExtendedStart() + ".." + s.getExtendedEnd();
        ArrayList<Object> tracks = new ArrayList();
        Map trackMap = this.getJBrowseTracks();
        if (trackMap != null) {
            if (featureTypes == null) {
                tracks = new ArrayList(trackMap.values());
            } else {
                for (String featureType : featureTypes) {
                    if (!trackMap.keySet().contains(featureType.toLowerCase())) continue;
                    tracks.add((String)trackMap.get(featureType.toLowerCase()));
                }
            }
            if (tracks.size() > 0) {
                jbUrl = jbUrl + "&tracks=" + StringUtil.join(tracks, (String)",");
            }
        }
        return jbUrl;
    }

    public String generateJBrowseURL(GenomicRegion s) {
        return this.generateJBrowseURL(s, null);
    }
}

