/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.querybuilder;

import org.intermine.metadata.AttributeDescriptor;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.pathquery.Path;

public class DisplayPath {
    Path path;

    public DisplayPath(Path path) {
        this.path = path;
    }

    public Path getPath() {
        return this.path;
    }

    public int getIndentation() {
        return this.path.getElements().size();
    }

    public String getFriendlyName() {
        if (this.path.isRootPath()) {
            return this.path.getNoConstraintsString();
        }
        return this.path.getLastElement();
    }

    public FieldDescriptor getFieldDescriptor() {
        return this.path.getEndFieldDescriptor();
    }

    public boolean isAttribute() {
        return this.path.endIsAttribute();
    }

    public boolean isReference() {
        return this.path.endIsReference();
    }

    public boolean isCollection() {
        return this.path.endIsCollection();
    }

    public boolean isPrimitive() {
        if (this.path.endIsAttribute()) {
            AttributeDescriptor attDescriptor = (AttributeDescriptor)this.path.getEndFieldDescriptor();
            return attDescriptor.isPrimitive();
        }
        return false;
    }

    public String getPathString() {
        return this.path.getNoConstraintsString();
    }

    public String getFieldName() {
        if (this.path.isRootPath()) {
            return null;
        }
        return this.path.getLastElement();
    }

    public String getType() {
        return this.path.getEndType().getSimpleName();
    }

    public DisplayPath getParent() {
        if (this.path.isRootPath()) {
            return null;
        }
        return new DisplayPath(this.path.getPrefix());
    }

    public String getLastClassName() {
        return this.path.getLastClassDescriptor().getUnqualifiedName();
    }

    public String toString() {
        return this.path.toString();
    }
}

