/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.widget;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.intermine.api.profile.InterMineBag;
import org.intermine.metadata.ConstraintOp;
import org.intermine.metadata.TypeUtil;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.query.BagConstraint;
import org.intermine.objectstore.query.Constraint;
import org.intermine.objectstore.query.ConstraintSet;
import org.intermine.objectstore.query.ContainsConstraint;
import org.intermine.objectstore.query.FromElement;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryCollectionReference;
import org.intermine.objectstore.query.QueryEvaluable;
import org.intermine.objectstore.query.QueryExpression;
import org.intermine.objectstore.query.QueryField;
import org.intermine.objectstore.query.QueryFunction;
import org.intermine.objectstore.query.QueryNode;
import org.intermine.objectstore.query.QueryObjectReference;
import org.intermine.objectstore.query.QueryOrderable;
import org.intermine.objectstore.query.QueryReference;
import org.intermine.objectstore.query.QuerySelectable;
import org.intermine.objectstore.query.QueryValue;
import org.intermine.objectstore.query.SimpleConstraint;
import org.intermine.pathquery.PathConstraint;
import org.intermine.web.logic.widget.CorrectionCoefficient;
import org.intermine.web.logic.widget.WidgetLdr;
import org.intermine.web.logic.widget.config.EnrichmentWidgetConfig;
import org.intermine.web.logic.widget.config.WidgetConfig;
import org.intermine.web.logic.widget.config.WidgetConfigUtil;

public class EnrichmentWidgetImplLdr
extends WidgetLdr {
    private EnrichmentWidgetConfig config;
    private String action;
    private InterMineBag populationBag;
    private boolean extraCorrectionCoefficient;
    private CorrectionCoefficient correctionCoefficient;
    private String populationIds;

    public EnrichmentWidgetImplLdr(InterMineBag bag, InterMineBag populationBag, ObjectStore os, EnrichmentWidgetConfig config, String filter, boolean extraCorrectionCoefficient, CorrectionCoefficient correctionCoefficient, String ids, String populationIds) {
        super(bag, os, filter, (WidgetConfig)config, ids);
        this.populationBag = populationBag;
        this.extraCorrectionCoefficient = extraCorrectionCoefficient;
        this.correctionCoefficient = correctionCoefficient;
        this.config = config;
        this.populationIds = populationIds;
    }

    public Query getQuery(String action, List<String> keys) {
        Object idArray;
        this.action = action;
        this.queryClassInQuery = new HashMap();
        String key = this.startClass.getType().getSimpleName();
        this.queryClassInQuery.put(key, this.startClass);
        Query query = new Query();
        ConstraintSet cs = new ConstraintSet(ConstraintOp.AND);
        query.setConstraint((Constraint)cs);
        query.addFrom((FromElement)this.startClass);
        QueryField qfEnrich = null;
        QueryField qfEnrichId = null;
        qfEnrich = this.createQueryFieldByPath(this.config.getEnrich(), query, false);
        qfEnrichId = this.config.getEnrichIdentifier() != null ? this.createQueryFieldByPath(this.config.getEnrichIdentifier(), query, false) : qfEnrich;
        if (keys != null) {
            cs.addConstraint((Constraint)new BagConstraint((QueryNode)qfEnrichId, ConstraintOp.IN, keys));
        }
        QueryField qfStartClassId = new QueryField(this.startClass, "id");
        if (!action.startsWith("population")) {
            if (this.bag != null) {
                cs.addConstraint((Constraint)new BagConstraint((QueryNode)qfStartClassId, ConstraintOp.IN, this.bag.getOsb()));
            } else if (this.ids != null) {
                idArray = this.ids.split(",");
                LinkedHashSet<Integer> idsCollection = new LinkedHashSet<Integer>();
                for (Object id : idArray) {
                    try {
                        idsCollection.add(Integer.valueOf(((String)id).trim()));
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("List of IDs contains invalid integer: " + (String)id, e);
                    }
                }
                cs.addConstraint((Constraint)new BagConstraint((QueryNode)qfStartClassId, ConstraintOp.IN, idsCollection));
            }
        } else if (this.populationBag != null || this.populationIds != null) {
            if (this.populationBag != null) {
                cs.addConstraint((Constraint)new BagConstraint((QueryNode)qfStartClassId, ConstraintOp.IN, this.populationBag.getOsb()));
            } else if (this.populationIds != null) {
                idArray = this.populationIds.split(",");
                List idCollection = Arrays.asList(idArray);
                cs.addConstraint((Constraint)new BagConstraint((QueryNode)qfStartClassId, ConstraintOp.IN, idCollection));
            }
        }
        for (PathConstraint pathConstraint : this.config.getPathConstraints()) {
            this.addConstraint(pathConstraint, query);
        }
        query.setDistinct(true);
        Query subQ = query;
        Query mainQuery = new Query();
        mainQuery.setDistinct(false);
        QueryFunction qfCount = new QueryFunction();
        QueryField qfCorrection = null;
        if (this.extraCorrectionCoefficient && this.correctionCoefficient.isApplicable()) {
            qfCorrection = this.correctionCoefficient.updateQueryWithCorrectionCoefficient(subQ, this.startClass);
        }
        if ("export".equals(action)) {
            subQ.addToSelect((QuerySelectable)qfEnrichId);
            subQ.addToSelect((QuerySelectable)new QueryField(this.startClass, this.config.getStartClassDisplay()));
            subQ.addToSelect((QuerySelectable)qfStartClassId);
            subQ.addToOrderBy((QueryOrderable)qfEnrichId);
            return subQ;
        }
        if ("analysed".equals(action)) {
            subQ.addToSelect((QuerySelectable)qfStartClassId);
            return subQ;
        }
        if (action.endsWith("Total")) {
            subQ.addToSelect((QuerySelectable)qfStartClassId);
            mainQuery.addFrom((FromElement)subQ);
            mainQuery.addToSelect((QuerySelectable)qfCount);
            if (action.startsWith("population") && qfCorrection != null) {
                this.correctionCoefficient.updatePopulationQuery(mainQuery, subQ, qfCorrection);
            }
        } else {
            subQ.addToSelect((QuerySelectable)qfStartClassId);
            subQ.addToSelect((QuerySelectable)qfEnrichId);
            if (qfEnrichId != qfEnrich) {
                subQ.addToSelect((QuerySelectable)qfEnrich);
            }
            mainQuery.addFrom((FromElement)subQ);
            QueryField outerQfEnrichId = new QueryField(subQ, (QueryEvaluable)qfEnrichId);
            mainQuery.addToSelect((QuerySelectable)outerQfEnrichId);
            mainQuery.addToGroupBy((QueryNode)outerQfEnrichId);
            mainQuery.addToSelect((QuerySelectable)qfCount);
            if ("sample".equals(action)) {
                if (qfEnrichId != qfEnrich) {
                    QueryField outerQfEnrich = new QueryField(subQ, (QueryEvaluable)qfEnrich);
                    mainQuery.addToSelect((QuerySelectable)outerQfEnrich);
                    mainQuery.addToGroupBy((QueryNode)outerQfEnrich);
                } else {
                    mainQuery.addToSelect((QuerySelectable)outerQfEnrichId);
                }
            } else if ("population".equals(action) && qfCorrection != null) {
                this.correctionCoefficient.updatePopulationQuery(mainQuery, subQ, qfCorrection);
            }
        }
        return mainQuery;
    }

    private void addConstraint(PathConstraint pc, Query query) {
        boolean isListConstraint = WidgetConfigUtil.isListConstraint((PathConstraint)pc);
        boolean isFilterConstraint = WidgetConfigUtil.isFilterConstraint((WidgetConfig)this.config, (PathConstraint)pc);
        QueryValue queryValue = null;
        if (!isFilterConstraint && !isListConstraint) {
            queryValue = this.buildQueryValue(pc);
        }
        if (isFilterConstraint && !"All".equalsIgnoreCase(this.filter)) {
            queryValue = new QueryValue((Object)this.filter);
        }
        QueryClass qc = this.startClass;
        QueryField qfConstraint = null;
        QueryClass qcConstraint = null;
        ConstraintSet cs = (ConstraintSet)query.getConstraint();
        String[] pathsConstraint = pc.getPath().split("\\.");
        Query subQuery = new Query();
        ConstraintSet csSubQuery = new ConstraintSet(ConstraintOp.AND);
        subQuery.setConstraint((Constraint)csSubQuery);
        for (int index = 0; index < pathsConstraint.length; ++index) {
            QueryObjectReference qr;
            if (index == pathsConstraint.length - 1) {
                qfConstraint = new QueryField(qc, pathsConstraint[index]);
                if (isListConstraint) {
                    if (!this.action.startsWith("population")) continue;
                    subQuery.addToSelect((QuerySelectable)qfConstraint);
                    subQuery.addToOrderBy((QueryOrderable)qfConstraint);
                    subQuery.addFrom((FromElement)this.startClass);
                    subQuery.addFrom((FromElement)qcConstraint);
                    QueryField qfStartClassId = new QueryField(this.startClass, "id");
                    if (this.bag != null) {
                        csSubQuery.addConstraint((Constraint)new BagConstraint((QueryNode)qfStartClassId, ConstraintOp.IN, this.bag.getOsb()));
                    } else if (this.ids != null) {
                        String[] idArray = this.ids.split(",");
                        LinkedHashSet<Integer> idsCollection = new LinkedHashSet<Integer>();
                        for (String intermineId : idArray) {
                            try {
                                idsCollection.add(Integer.valueOf(intermineId.trim()));
                            }
                            catch (NumberFormatException e) {
                                throw new RuntimeException("List of IDs contains invalid integer: " + intermineId, e);
                            }
                        }
                        csSubQuery.addConstraint((Constraint)new BagConstraint((QueryNode)qfStartClassId, ConstraintOp.IN, idsCollection));
                    }
                    QueryField outerQFConstraint = new QueryField(subQuery, (QueryEvaluable)qfConstraint);
                    cs.addConstraint((Constraint)new SimpleConstraint((QueryEvaluable)qfConstraint, ConstraintOp.EQUALS, (QueryEvaluable)outerQFConstraint));
                    query.addFrom((FromElement)subQuery);
                    continue;
                }
                if (queryValue == null) continue;
                if (!"null".equalsIgnoreCase(queryValue.getValue().toString())) {
                    Object qe = null;
                    qe = isFilterConstraint || isListConstraint || queryValue.getValue() instanceof Boolean ? qfConstraint : new QueryExpression(6, (QueryEvaluable)qfConstraint);
                    cs.addConstraint((Constraint)new SimpleConstraint((QueryEvaluable)qe, pc.getOp(), (QueryEvaluable)queryValue));
                    continue;
                }
                ConstraintOp op = pc.getOp().equals(ConstraintOp.EQUALS) ? ConstraintOp.IS_NULL : ConstraintOp.IS_NOT_NULL;
                cs.addConstraint((Constraint)new SimpleConstraint((QueryEvaluable)qfConstraint, op));
                continue;
            }
            try {
                qr = new QueryObjectReference(qc, pathsConstraint[index]);
                qcConstraint = new QueryClass(new Class[]{qr.getType()});
            }
            catch (IllegalArgumentException e) {
                qr = new QueryCollectionReference(qc, pathsConstraint[index]);
                qcConstraint = new QueryClass(TypeUtil.getElementType((Class)qc.getType(), (String)pathsConstraint[index]));
            }
            String partialPath = this.createAttributePath(pathsConstraint, index);
            if (!this.queryClassInQuery.containsKey(partialPath)) {
                qc = qcConstraint;
                query.addFrom((FromElement)qc);
                cs.addConstraint((Constraint)new ContainsConstraint((QueryReference)qr, ConstraintOp.CONTAINS, qc));
                if (isListConstraint && this.action.startsWith("population")) {
                    csSubQuery.addConstraint((Constraint)new ContainsConstraint((QueryReference)qr, ConstraintOp.CONTAINS, qc));
                }
                this.queryClassInQuery.put(partialPath, qc);
                continue;
            }
            qc = (QueryClass)this.queryClassInQuery.get(partialPath);
        }
    }

    public Query getSampleQuery(boolean calcTotal) {
        String actionLocal = calcTotal ? "sampleTotal" : "sample";
        return this.getQuery(actionLocal, null);
    }

    public Query getPopulationQuery(boolean calcTotal) {
        String actionLocal = calcTotal ? "populationTotal" : "population";
        return this.getQuery(actionLocal, null);
    }

    public Query getExportQuery(List<String> keys) {
        return this.getQuery("export", keys);
    }
}

