/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.intermine.api.results.ResultElement;
import org.intermine.api.results.WebTable;
import org.intermine.api.results.flatouterjoins.MultiRowValue;
import org.intermine.objectstore.query.ResultsRow;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.logic.query.QueryMonitorTimeout;
import org.intermine.web.logic.results.PagedTable;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.ForwardParameters;
import org.intermine.web.struts.InterMineAction;

public class PollQueryAction
extends InterMineAction {
    protected static final Logger LOG = Logger.getLogger(PollQueryAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        String qid = request.getParameter("qid");
        String trail = request.getParameter("trail");
        String queryBuilder = request.getParameter("queryBuilder");
        boolean followSingleResult = "followSingleResult".equals(mapping.getParameter());
        request.setAttribute("trail", (Object)trail);
        request.setAttribute("queryBuilder", (Object)queryBuilder);
        if (StringUtils.isEmpty((String)qid)) {
            this.recordError(new ActionMessage("errors.pollquery.emptyqid", (Object)qid), request);
            return mapping.findForward("error");
        }
        QueryMonitorTimeout controller = (QueryMonitorTimeout)SessionMethods.getRunningQueryController((String)qid, (HttpSession)session);
        if (controller == null) {
            LOG.debug((Object)("invalid qid " + qid + " redirecting as if cancelled"));
            return mapping.findForward("cancelled");
        }
        controller.tickle();
        if (controller.isCancelledWithError()) {
            LOG.debug((Object)("query qid " + qid + " error"));
            return mapping.findForward("failure");
        }
        if (controller.isCancelled()) {
            LOG.debug((Object)("query qid " + qid + " cancelled"));
            this.recordError(new ActionMessage("errors.pollquery.cancelled", (Object)qid), request);
            return mapping.findForward("cancelled");
        }
        if (controller.isCompleted()) {
            PagedTable pr = SessionMethods.getResultsTable((HttpSession)session, (String)("results." + qid));
            if (followSingleResult) {
                WebTable webResults = pr.getAllRows();
                Object cell = null;
                Integer forwardId = null;
                if (webResults.size() == 1 && (cell = ((MultiRowValue)((ResultsRow)webResults.getResultElements(0).get(0)).get(0)).getValue()) instanceof ResultElement) {
                    forwardId = ((ResultElement)cell).getId();
                }
                for (int i = 1; i < webResults.size() && forwardId != null; ++i) {
                    cell = webResults.getResultElements(i).get(0);
                    if (!(cell instanceof ResultElement) || forwardId.equals(((ResultElement)cell).getId())) continue;
                    forwardId = null;
                }
                if (forwardId != null) {
                    trail = trail != null ? trail + "%7C" + forwardId : "%7C" + forwardId;
                    String url = "/report.do?id=" + forwardId + "&trail=" + trail;
                    return new ActionForward(url, true);
                }
            }
            trail = trail != null ? trail + "%7Cresults." + qid : "%7Cresults." + qid;
            PathQuery pq = null;
            pq = pr != null && pr.getPathQuery() != null ? pr.getPathQuery() : controller.getPathQuery();
            if (pq != null) {
                request.setAttribute("query", (Object)pq);
            }
            ForwardParameters fp = new ForwardParameters(mapping.findForward("results")).addParameter("trail", trail).addParameter("table", "results." + qid);
            if (queryBuilder != null) {
                fp.addParameter("queryBuilder", queryBuilder);
            }
            return fp.forward();
        }
        request.setAttribute("qid", (Object)qid);
        request.setAttribute("trail", (Object)trail);
        if (controller.getTickleCount() < 4) {
            request.setAttribute("POLL_REFRESH_SECONDS", (Object)new Integer(1));
        } else {
            request.setAttribute("POLL_REFRESH_SECONDS", (Object)new Integer(2));
        }
        int imgnum = (controller.getTickleCount() + 1) % 4 + 1;
        if (controller.getTickleCount() < 4) {
            request.setAttribute("imgnum", (Object)new Integer(1));
        } else {
            request.setAttribute("imgnum", (Object)new Integer(imgnum));
        }
        request.setAttribute("POLL_ACTION_NAME", (Object)mapping.getPath());
        return mapping.findForward("waiting");
    }
}

