/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.query.WebResultsExecutor;
import org.intermine.api.results.WebTable;
import org.intermine.metadata.StringUtil;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.pathquery.OrderElement;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathQuery;
import org.intermine.template.SwitchOffAbility;
import org.intermine.template.TemplateQuery;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.web.logic.export.ExportException;
import org.intermine.web.logic.export.http.TableExporterFactory;
import org.intermine.web.logic.export.http.TableHttpExporter;
import org.intermine.web.logic.results.PagedTable;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.InterMineAction;
import org.intermine.web.struts.TableExportForm;

public class TableExportAction
extends InterMineAction {
    protected static final Logger LOG = Logger.getLogger(TableExportAction.class);
    private static final String ERROR_MSG = "Export failed.";

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        TableExportForm tef = (TableExportForm)form;
        if (tef.getPathsString().trim().isEmpty()) {
            response.setContentType("text/plain");
            ServletOutputStream out = response.getOutputStream();
            PrintWriter writer = new PrintWriter((OutputStream)out);
            writer.println("Export failed. No columns added.");
            writer.flush();
            writer.close();
            return null;
        }
        String type = tef.getType();
        String table = tef.getTable();
        String pathsString = tef.getPathsString();
        PagedTable pt = null;
        try {
            List<String> newPathList;
            WebConfig webConfig = SessionMethods.getWebConfig((HttpServletRequest)request);
            TableExporterFactory factory = new TableExporterFactory(webConfig);
            TableHttpExporter exporter = factory.getExporter(type);
            pt = SessionMethods.getResultsTable((HttpSession)session, (String)table);
            this.checkTable(pt);
            PathQuery pathQuery = pt.getPathQuery();
            List oldPathList = pathQuery.getView();
            try {
                newPathList = !pathsString.contains("[]=") ? Arrays.asList(pathsString.split(" ")) : new ArrayList(StringUtil.serializedSortOrderToMap((String)pathsString).keySet());
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Error while converting " + pathsString, e);
            }
            HashSet<String> unionPathSet = new HashSet<String>();
            unionPathSet.addAll(oldPathList);
            unionPathSet.addAll(newPathList);
            ArrayList<Path> newPatCollection = new ArrayList<Path>();
            for (String string : newPathList) {
                newPatCollection.add(pathQuery.makePath(string));
            }
            ArrayList<Path> unionPathCollection = new ArrayList<Path>();
            for (String pathString : unionPathSet) {
                unionPathCollection.add(pathQuery.makePath(pathString));
            }
            PagedTable pagedTable = this.reorderPagedTable(pathQuery, unionPathSet, request);
            exporter.export(pagedTable, request, response, tef, unionPathCollection, newPatCollection);
            return null;
        }
        catch (RuntimeException e) {
            return this.processException(mapping, request, response, e);
        }
    }

    private void checkTable(PagedTable pt) {
        if (pt == null) {
            throw new ExportException("Export failed: result is null.");
        }
        if (pt.getExactSize() > pt.getMaxRetrievableIndex()) {
            throw new ExportException("Result is too big for export. Table for export can have at the most " + pt.getMaxRetrievableIndex() + " rows.");
        }
    }

    private PagedTable reorderPagedTable(PathQuery pathQuery, Collection<String> newViews, HttpServletRequest request) throws ObjectStoreException {
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)session);
        PathQuery newPathQuery = new PathQuery(pathQuery);
        if (pathQuery instanceof TemplateQuery) {
            TemplateQuery templateQuery = (TemplateQuery)pathQuery.clone();
            Map map = templateQuery.getConstraintSwitchOffAbility();
            for (Map.Entry entry : map.entrySet()) {
                if (((SwitchOffAbility)entry.getValue()).compareTo((Enum)SwitchOffAbility.OFF) != 0) continue;
                newPathQuery.removeConstraint((PathConstraint)entry.getKey());
            }
        }
        newPathQuery.clearView();
        newPathQuery.addViews(newViews);
        for (OrderElement orderElement : newPathQuery.getOrderBy()) {
            if (newPathQuery.getView().contains(orderElement.getOrderPath())) continue;
            newPathQuery.removeOrderBy(orderElement.getOrderPath());
        }
        for (Map.Entry entry : newPathQuery.getOuterMap().entrySet()) {
            if (!((Boolean)entry.getValue()).equals(Boolean.TRUE)) continue;
            String joinPath = (String)entry.getKey();
            boolean outherJoinStatusRelevant = false;
            for (String viewPath : newPathQuery.getView()) {
                if (!viewPath.startsWith(joinPath)) continue;
                outherJoinStatusRelevant = true;
                break;
            }
            if (outherJoinStatusRelevant) continue;
            newPathQuery.setOuterJoinStatus(joinPath, null);
        }
        Profile profile = SessionMethods.getProfile((HttpSession)session);
        WebResultsExecutor webResultsExecutor = im.getWebResultsExecutor(profile);
        return new PagedTable((WebTable)webResultsExecutor.execute(newPathQuery));
    }

    private ActionForward processException(ActionMapping mapping, HttpServletRequest request, HttpServletResponse response, RuntimeException e) throws IOException {
        LOG.error((Object)ERROR_MSG, (Throwable)e);
        String msg = null;
        if (e instanceof ExportException) {
            msg = e.getMessage();
            if (msg == null || msg.length() == 0) {
                msg = ERROR_MSG;
            }
        } else {
            msg = ERROR_MSG;
        }
        if (!response.isCommitted()) {
            PrintWriter writer = null;
            response.reset();
            try {
                response.getWriter();
                this.recordError(new ActionMessage("errors.export.displayonlyparameters", (Object)msg), request);
                return mapping.findForward("error");
            }
            catch (IllegalStateException ex) {
                ServletOutputStream out = response.getOutputStream();
                writer = new PrintWriter((OutputStream)out);
                writer.println(msg);
                writer.flush();
            }
        } else {
            try {
                PrintWriter writer = response.getWriter();
                writer.println(msg);
                writer.flush();
            }
            catch (IllegalStateException ex) {
                ServletOutputStream out = response.getOutputStream();
                PrintWriter writer = new PrintWriter((OutputStream)out);
                writer.println(msg);
                writer.flush();
            }
        }
        return null;
    }

    protected PagedTable getPagedTable(HttpServletRequest request, HttpSession session) {
        return SessionMethods.getResultsTable((HttpSession)session, (String)request.getParameter("table"));
    }
}

