/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.BagManager;
import org.intermine.api.profile.BadTemplateException;
import org.intermine.api.profile.Profile;
import org.intermine.api.template.ApiTemplate;
import org.intermine.api.util.NameUtil;
import org.intermine.template.TemplateQuery;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.ForwardParameters;
import org.intermine.web.struts.InterMineAction;
import org.intermine.web.struts.TemplatesImportForm;

public class TemplatesImportAction
extends InterMineAction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)session);
        Profile profile = SessionMethods.getProfile((HttpSession)session);
        TemplatesImportForm tif = (TemplatesImportForm)form;
        int deleted = 0;
        int imported = 0;
        int renamed = 0;
        BagManager bagManager = im.getBagManager();
        Map templates = tif.getQueryMap(bagManager, profile);
        try {
            profile.disableSaving();
            HashSet templateNames = new HashSet(profile.getSavedTemplates().keySet());
            if (tif.isOverwriting() && templateNames.size() > 0) {
                for (String templateName : templateNames) {
                    profile.deleteTemplate(templateName, im.getTrackerDelegate(), tif.isDeleteTracks());
                    ++deleted;
                }
            }
            boolean validConstraints = true;
            boolean validTemplate = true;
            for (TemplateQuery template : templates.values()) {
                String updatedName;
                ApiTemplate apiTemplate = new ApiTemplate(template);
                String templateName = apiTemplate.getName();
                if (!templateName.equals(updatedName = NameUtil.validateName(profile.getSavedTemplates().keySet(), (String)templateName))) {
                    apiTemplate = this.renameTemplate(updatedName, apiTemplate);
                }
                if (template.validateLookupConstraints() && !template.getEditableConstraints().isEmpty()) {
                    try {
                        profile.saveTemplate(apiTemplate.getName(), apiTemplate);
                    }
                    catch (BadTemplateException bte) {
                        validTemplate = false;
                        continue;
                    }
                    ++imported;
                    continue;
                }
                validConstraints = false;
            }
            this.recordMessage(new ActionMessage("importTemplates.done", (Object)new Integer(deleted), (Object)new Integer(imported), (Object)new Integer(renamed)), request);
            if (!validConstraints) {
                this.recordError(new ActionMessage("importTemplates.error.noneditablelookup"), request);
            }
            if (!validTemplate) {
                this.recordError(new ActionMessage("importTemplates.error.invalidname"), request);
            }
            ActionForward actionForward = new ForwardParameters(mapping.findForward("mymine")).addParameter("subtab", "templates").forward();
            return actionForward;
        }
        finally {
            profile.enableSaving();
        }
    }

    private ApiTemplate renameTemplate(String newName, ApiTemplate template) {
        ApiTemplate newTemplate = template.clone();
        newTemplate.setName(newName);
        return newTemplate;
    }
}

