/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.tags.table;

import java.io.IOException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.SimpleTagSupport;

public class NavigationBarTag
extends SimpleTagSupport {
    private String baseLink;
    private Integer pageSize;
    private Integer currentPage;
    private boolean nextEnabled = false;

    public boolean isNextEnabled() {
        return this.nextEnabled;
    }

    public void setNextEnabled(boolean nextEnabled) {
        this.nextEnabled = nextEnabled;
    }

    public void doTag() throws IOException {
        JspWriter writer = this.getJspContext().getOut();
        writer.print("<span class=\"navigationBar\" style=\"white-space:nowrap;\">");
        writer.print(this.getLinkHtml("< Previous", this.getPreviousLink(this.currentPage.intValue())));
        writer.print("&nbsp;");
        writer.print(this.currentPage + 1);
        writer.print("&nbsp;");
        writer.print(this.getLinkHtml("Next >", this.getNextLink(this.currentPage.intValue())));
        writer.print("</span>");
    }

    public String getBaseLink() {
        return this.baseLink;
    }

    public Integer getCurrentPage() {
        return this.currentPage;
    }

    private String getLinkHtml(String title, String url) {
        if (url != null) {
            String ret = "<a  href=\"" + url + "\">" + title + "</a>";
            return ret;
        }
        return title;
    }

    public String getNextLink(int pageIndex) {
        if (this.nextEnabled) {
            return this.getPageLink(pageIndex + 1);
        }
        return null;
    }

    public String getPageLink(int pageIndex) {
        return this.baseLink + "&start=" + pageIndex * this.pageSize + "&size=" + this.pageSize;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getPreviousLink(int pageIndex) {
        if (pageIndex > 0) {
            return this.getPageLink(pageIndex - 1);
        }
        return null;
    }

    public void setBaseLink(String baseLink) {
        this.baseLink = baseLink;
    }

    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String toString() {
        String ret = "<span class=\"navigationBar\" style=\"white-space:nowrap;\">";
        ret = ret + this.getLinkHtml("< Previous", this.getPreviousLink(this.currentPage.intValue()));
        ret = ret + "&nbsp;";
        ret = ret + (this.currentPage + 1);
        ret = ret + "&nbsp;";
        ret = ret + this.getLinkHtml("Next >", this.getNextLink(this.currentPage.intValue()));
        ret = ret + "</span>";
        return ret;
    }
}

