/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.lists;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.webservice.server.Format;
import org.intermine.webservice.server.WebService;
import org.intermine.webservice.server.core.ListManager;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.ResourceNotFoundException;
import org.intermine.webservice.server.lists.AvailableListsService;
import org.intermine.webservice.server.lists.FlatListFormatter;
import org.intermine.webservice.server.lists.HtmlListFormatter;
import org.intermine.webservice.server.lists.JSONListFormatter;
import org.intermine.webservice.server.lists.ListFormatter;

public class AvailableListsService
extends WebService {
    public AvailableListsService(InterMineAPI im) {
        super(im);
    }

    protected void execute() throws Exception {
        Collection lists = this.getLists();
        ListFormatter formatter = this.getFormatter();
        formatter.setSize(lists.size());
        this.output.setHeaderAttributes(this.getHeaderAttributes());
        for (InterMineBag list : lists) {
            if (list == null) continue;
            this.output.addResultItem(formatter.format(list));
        }
    }

    protected Collection<InterMineBag> getLists() {
        ListManager listManager = new ListManager(this.im, this.getPermission().getProfile());
        String nameFilter = this.getOptionalParameter("name");
        if (nameFilter == null) {
            return listManager.getLists();
        }
        return this.getListsMatching(listManager, nameFilter);
    }

    private Filter getFilterType(String term) {
        if (term == null) {
            throw new IllegalArgumentException("term must not be null");
        }
        if (term.startsWith("*") && term.endsWith("*")) {
            return Filter.CONTAINS;
        }
        if (term.startsWith("*")) {
            return Filter.SUFFIX;
        }
        if (term.endsWith("*")) {
            return Filter.PREFIX;
        }
        return Filter.EXACT;
    }

    protected Collection<InterMineBag> getListsMatching(ListManager listManager, String nameFilter) {
        if (nameFilter == null) {
            throw new IllegalArgumentException("nameFilter must not be null");
        }
        nameFilter = nameFilter.trim();
        Filter type = this.getFilterType(nameFilter);
        String term = StringUtils.strip((String)nameFilter, (String)"*");
        LinkedHashSet<InterMineBag> ret = new LinkedHashSet<InterMineBag>();
        for (InterMineBag bag : listManager.getLists()) {
            boolean suitable = false;
            if (bag != null) {
                String bagName = StringUtils.defaultString((String)bag.getName(), (String)"");
                switch (1.$SwitchMap$org$intermine$webservice$server$lists$AvailableListsService$Filter[type.ordinal()]) {
                    case 1: {
                        suitable = term.equals(bagName);
                        break;
                    }
                    case 2: {
                        suitable = bagName.startsWith(term);
                        break;
                    }
                    case 3: {
                        suitable = bagName.endsWith(term);
                        break;
                    }
                    case 4: {
                        suitable = bagName.contains(term);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("someone has gone and expanded this enum");
                    }
                }
            }
            if (!suitable) continue;
            ret.add(bag);
        }
        if (ret.isEmpty()) {
            throw new ResourceNotFoundException("No lists matched " + nameFilter);
        }
        return ret;
    }

    protected Format getDefaultFormat() {
        return Format.JSON;
    }

    protected boolean canServe(Format format) {
        return format == Format.JSON || format == Format.HTML || format == Format.TEXT || Format.FLAT_FILES.contains(format);
    }

    private Map<String, Object> getHeaderAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (this.formatIsJSON()) {
            attributes.put("intro", "\"lists\":[");
            attributes.put("outro", "]");
        }
        if (this.formatIsJSONP()) {
            attributes.put("callback", this.getCallback());
        } else if (this.getFormat() == Format.HTML) {
            attributes.put("headers", Arrays.asList("Id", "Name", "Type", "Description", "Size"));
        }
        return attributes;
    }

    private ListFormatter getFormatter() {
        boolean jsDates = Boolean.parseBoolean(this.request.getParameter("jsDates"));
        if (this.formatIsJSON()) {
            Profile profile = this.getPermission().getProfile();
            return new JSONListFormatter(this.im, profile, jsDates);
        }
        if (this.formatIsFlatFile() || Format.TEXT == this.getFormat()) {
            return new FlatListFormatter();
        }
        if (Format.HTML == this.getFormat()) {
            return new HtmlListFormatter();
        }
        throw new BadRequestException("Unknown request format");
    }
}

