/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web;

import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.actions.TilesAction;
import org.intermine.api.InterMineAPI;
import org.intermine.api.mines.FriendlyMineManager;
import org.intermine.api.mines.Mine;
import org.intermine.api.profile.InterMineBag;
import org.intermine.bio.util.BioUtil;
import org.intermine.metadata.StringUtil;
import org.intermine.metadata.TypeUtil;
import org.intermine.objectstore.ObjectStore;
import org.intermine.web.logic.bag.BagHelper;
import org.intermine.web.logic.session.SessionMethods;

public class FriendlyMineLinkController
extends TilesAction {
    private static final String IDENTIFIER = "primaryIdentifier";
    private static final String ALTERNATIVE_IDENTIFIER = "ensemblIdentifier";

    public ActionForward execute(ComponentContext context, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        InterMineBag bag = (InterMineBag)request.getAttribute("bag");
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)request.getSession());
        Collection organismsInBag = BioUtil.getOrganisms((ObjectStore)im.getObjectStore(), (String)bag.getType(), (List)bag.getContentsAsIds(), (boolean)false, (String)"shortName");
        String organisms = null;
        if (!organismsInBag.isEmpty()) {
            organisms = StringUtil.join((Collection)organismsInBag, (String)",");
        }
        String identifierField = FriendlyMineLinkController.getIdentifierField(bag);
        String identifierList = BagHelper.getAttributesFromBag((InterMineBag)bag, (ObjectStore)im.getObjectStore(), (String)"", (String)identifierField);
        request.setAttribute("identifiers", (Object)identifierList);
        if (StringUtils.isNotEmpty((String)organisms)) {
            request.setAttribute("organisms", (Object)organisms);
        }
        HttpSession session = request.getSession();
        ServletContext servletContext = session.getServletContext();
        Properties webProperties = SessionMethods.getWebProperties((ServletContext)servletContext);
        FriendlyMineManager linkManager = FriendlyMineManager.getInstance((InterMineAPI)im, (Properties)webProperties);
        Collection mines = linkManager.getFriendlyMines();
        Mine localMine = linkManager.getLocalMine();
        request.setAttribute("mines", (Object)mines);
        request.setAttribute("localMine", (Object)localMine);
        return null;
    }

    private static String getIdentifierField(InterMineBag bag) {
        Class<?> c = null;
        try {
            c = Class.forName(bag.getQualifiedType());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        if (TypeUtil.getFieldInfo(c, (String)ALTERNATIVE_IDENTIFIER) != null) {
            return ALTERNATIVE_IDENTIFIER;
        }
        return IDENTIFIER;
    }
}

