/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.displayer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.query.PathQueryExecutor;
import org.intermine.api.results.ExportResultsIterator;
import org.intermine.api.results.ResultElement;
import org.intermine.metadata.Model;
import org.intermine.model.InterMineObject;
import org.intermine.model.bio.BioEntity;
import org.intermine.model.bio.OntologyTerm;
import org.intermine.model.bio.Organism;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.pathquery.Constraints;
import org.intermine.pathquery.OrderDirection;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.displayer.ReportDisplayer;
import org.intermine.web.logic.config.ReportDisplayerConfig;
import org.intermine.web.logic.results.ReportObject;
import org.intermine.web.logic.session.SessionMethods;

public class GeneOntologyDisplayer
extends ReportDisplayer {
    public static final Set<String> ONTOLOGIES = new HashSet<String>();
    private static final Map<String, String> EVIDENCE_CODES = new HashMap<String, String>();
    private Map<String, Boolean> organismCache = new HashMap<String, Boolean>();

    public GeneOntologyDisplayer(ReportDisplayerConfig config, InterMineAPI im) {
        super(config, im);
    }

    public void display(HttpServletRequest request, ReportObject reportObject) {
        Profile profile = SessionMethods.getProfile((HttpSession)request.getSession());
        boolean goLoadedForOrganism = true;
        String organismName = GeneOntologyDisplayer.getOrganismName(reportObject);
        if (organismName != null) {
            goLoadedForOrganism = this.isGoLoadedForOrganism(organismName, profile);
        }
        if (!goLoadedForOrganism) {
            String noGoMessage = "No Gene Ontology annotation loaded for " + organismName;
            request.setAttribute("noGoMessage", (Object)noGoMessage);
        } else {
            ExportResultsIterator result;
            Model model = this.im.getModel();
            PathQueryExecutor executor = this.im.getPathQueryExecutor(profile);
            InterMineObject object = reportObject.getObject();
            String primaryIdentifier = null;
            try {
                primaryIdentifier = (String)object.getFieldValue("primaryIdentifier");
            }
            catch (IllegalAccessException e) {
                return;
            }
            if (StringUtils.isEmpty((String)primaryIdentifier)) {
                return;
            }
            PathQuery query = GeneOntologyDisplayer.buildQuery(model, new Integer(reportObject.getId()));
            try {
                result = executor.execute(query);
            }
            catch (ObjectStoreException e) {
                throw new RuntimeException(e);
            }
            HashMap<String, Map<OntologyTerm, Set<String>>> goTermsByOntology = new HashMap<String, Map<OntologyTerm, Set<String>>>();
            while (result.hasNext()) {
                List row = result.next();
                String parentTerm = (String)((ResultElement)row.get(0)).getField();
                parentTerm = parentTerm.replaceAll("_", " ");
                OntologyTerm term = (OntologyTerm)((ResultElement)row.get(1)).getObject();
                String code = (String)((ResultElement)row.get(2)).getField();
                GeneOntologyDisplayer.addToOntologyMap(goTermsByOntology, parentTerm, term, code);
            }
            for (String ontology : ONTOLOGIES) {
                String parentTerm = ontology.replaceAll("_", " ");
                if (goTermsByOntology.containsKey(parentTerm)) continue;
                goTermsByOntology.put(parentTerm, null);
            }
            request.setAttribute("goTerms", goTermsByOntology);
            request.setAttribute("codes", EVIDENCE_CODES);
        }
    }

    private static void addToOntologyMap(Map<String, Map<OntologyTerm, Set<String>>> goTermsByOntology, String namespace, OntologyTerm term, String evidenceCode) {
        Set<String> codes;
        Map<OntologyTerm, Set<String>> termToEvidence = goTermsByOntology.get(namespace);
        if (termToEvidence == null) {
            termToEvidence = new HashMap<OntologyTerm, Set<String>>();
            goTermsByOntology.put(namespace, termToEvidence);
        }
        if ((codes = termToEvidence.get(term)) == null) {
            codes = new HashSet<String>();
            termToEvidence.put(term, codes);
        }
        codes.add(evidenceCode);
    }

    private static PathQuery buildQuery(Model model, Integer geneId) {
        PathQuery q = new PathQuery(model);
        q.addViews(new String[]{"Gene.goAnnotation.ontologyTerm.parents.name", "Gene.goAnnotation.ontologyTerm.name", "Gene.goAnnotation.evidence.code.code"});
        q.addOrderBy("Gene.goAnnotation.ontologyTerm.parents.name", OrderDirection.ASC);
        q.addOrderBy("Gene.goAnnotation.ontologyTerm.name", OrderDirection.ASC);
        q.addConstraint((PathConstraint)Constraints.oneOfValues((String)"Gene.goAnnotation.ontologyTerm.parents.name", ONTOLOGIES));
        q.addConstraint((PathConstraint)Constraints.isNull((String)"Gene.goAnnotation.qualifier"));
        q.addConstraint((PathConstraint)Constraints.eq((String)"Gene.id", (String)("" + geneId)));
        return q;
    }

    private static String getOrganismName(ReportObject reportObject) {
        Organism organism = ((BioEntity)reportObject.getObject()).getOrganism();
        if (organism != null) {
            if (!StringUtils.isBlank((String)organism.getName())) {
                return organism.getName();
            }
            if (organism.getTaxonId() != null) {
                return "" + organism.getTaxonId();
            }
        }
        return null;
    }

    private boolean isGoLoadedForOrganism(String organismField, Profile profile) {
        if (!this.organismCache.containsKey(organismField)) {
            ExportResultsIterator result;
            PathQuery q = new PathQuery(this.im.getModel());
            q.addViews(new String[]{"Gene.goAnnotation.ontologyTerm.name"});
            if (StringUtils.isNumeric((String)organismField)) {
                q.addConstraint((PathConstraint)Constraints.eq((String)"Gene.organism.taxonId", (String)organismField));
            } else {
                q.addConstraint((PathConstraint)Constraints.eq((String)"Gene.organism.name", (String)organismField));
            }
            PathQueryExecutor executor = this.im.getPathQueryExecutor(profile);
            try {
                result = executor.execute(q, 0, 1);
            }
            catch (ObjectStoreException e) {
                throw new RuntimeException(e);
            }
            this.organismCache.put(organismField, result.hasNext());
        }
        return this.organismCache.get(organismField);
    }

    static {
        ONTOLOGIES.add("biological_process");
        ONTOLOGIES.add("molecular_function");
        ONTOLOGIES.add("cellular_component");
        EVIDENCE_CODES.put("EXP", "Inferred from Experiment");
        EVIDENCE_CODES.put("IDA", "Inferred from Direct Assay");
        EVIDENCE_CODES.put("IPI", "Inferred from Physical Interaction");
        EVIDENCE_CODES.put("IMP", "Inferred from Mutant Phenotype");
        EVIDENCE_CODES.put("IGI", "Inferred from Genetic Interaction");
        EVIDENCE_CODES.put("IEP", "Inferred from Expression Pattern");
        EVIDENCE_CODES.put("ISS", "Inferred from Sequence or Structural Similarity");
        EVIDENCE_CODES.put("ISO", "Inferred from Sequence Orthology");
        EVIDENCE_CODES.put("ISA", "Inferred from Sequence Alignment");
        EVIDENCE_CODES.put("ISM", "Inferred from Sequence Model");
        EVIDENCE_CODES.put("IGC", "Inferred from Genomic Context");
        EVIDENCE_CODES.put("RCA", "Inferred from Reviewed Computational Analysis");
        EVIDENCE_CODES.put("TAS", "Traceable Author Statement");
        EVIDENCE_CODES.put("NAS", "Non-traceable Author Statement");
        EVIDENCE_CODES.put("IC", "Inferred by Curator");
        EVIDENCE_CODES.put("ND", "No biological Data available");
        EVIDENCE_CODES.put("IEA", "Inferred from Electronic Annotation");
        EVIDENCE_CODES.put("NR", "Not Recorded ");
    }
}

