/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.displayer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.bio.web.model.GeneModelCache;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.model.FastPathObject;
import org.intermine.model.InterMineObject;
import org.intermine.model.bio.SequenceFeature;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.proxy.LazyCollection;
import org.intermine.objectstore.proxy.ProxyReference;
import org.intermine.util.DynamicUtil;
import org.intermine.web.displayer.ReportDisplayer;
import org.intermine.web.logic.config.ReportDisplayerConfig;
import org.intermine.web.logic.pathqueryresult.PathQueryResultHelper;
import org.intermine.web.logic.results.InlineResultsTable;
import org.intermine.web.logic.results.ReportObject;
import org.intermine.web.logic.session.SessionMethods;

public class RegulatoryRegionsDisplayer
extends ReportDisplayer {
    private Integer maxCount = 30;
    protected static final Logger LOG = Logger.getLogger(RegulatoryRegionsDisplayer.class);

    public RegulatoryRegionsDisplayer(ReportDisplayerConfig config, InterMineAPI im) {
        super(config, im);
    }

    public void display(HttpServletRequest request, ReportObject reportObject) {
        TreeMap<String, Integer> regionCounts = new TreeMap<String, Integer>();
        TreeMap<String, InlineResultsTable> regionTables = new TreeMap<String, InlineResultsTable>();
        SequenceFeature startRegion = (SequenceFeature)reportObject.getObject();
        Set<Integer> geneModelIds = GeneModelCache.getGeneModelIds((InterMineObject)startRegion, this.im.getModel());
        try {
            Collection regulatoryRegions = (Collection)startRegion.getFieldValue("regulatoryRegions");
            for (InterMineObject region : regulatoryRegions) {
                if (geneModelIds.contains(region.getId())) continue;
                this.incrementCount(regionCounts, region);
            }
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)("Error accessing regulatoryRegions collection for region: " + startRegion.getPrimaryIdentifier() + ", " + startRegion.getId()));
        }
        request.setAttribute("regionCounts", regionCounts);
        for (FieldDescriptor fd : reportObject.getClassDescriptor().getAllFieldDescriptors()) {
            if (!"regulatoryRegions".equals(fd.getName()) || !fd.isCollection()) continue;
            Collection collection = null;
            try {
                collection = (Collection)reportObject.getObject().getFieldValue("regulatoryRegions");
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            List lt = PathQueryResultHelper.queryForTypesInCollection((InterMineObject)reportObject.getObject(), (String)"regulatoryRegions", (ObjectStore)this.im.getObjectStore());
            List collectionList = collection instanceof List ? (ArrayList)collection : (collection instanceof LazyCollection ? ((LazyCollection)collection).asList() : new ArrayList(collection));
            block6: for (Class c : lt) {
                Iterator resultsIter = collectionList.iterator();
                ArrayList<InterMineObject> s = new ArrayList<InterMineObject>();
                String type = null;
                Integer count = this.maxCount;
                while (resultsIter.hasNext() && count > 0) {
                    InterMineObject imObj;
                    Class imObjClass;
                    Object o = resultsIter.next();
                    if (o instanceof ProxyReference) {
                        o = ((ProxyReference)o).getObject();
                    }
                    if (!c.equals(imObjClass = DynamicUtil.getSimpleClass((FastPathObject)(imObj = (InterMineObject)o)))) continue;
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count - 1);
                    s.add(imObj);
                    type = DynamicUtil.getSimpleClass((FastPathObject)((FastPathObject)s.get(0))).getSimpleName();
                    if (regionCounts.containsKey(type)) continue;
                    continue block6;
                }
                if (s.size() <= 0) continue;
                ArrayList<Class> lc = new ArrayList<Class>();
                lc.add(c);
                InlineResultsTable t = new InlineResultsTable(s, fd.getClassDescriptor().getModel(), SessionMethods.getWebConfig((HttpServletRequest)request), (Map)this.im.getClassKeys(), s.size(), false, lc);
                regionTables.put(type, t);
            }
        }
        request.setAttribute("regionTables", regionTables);
    }

    private void incrementCount(Map<String, Integer> regionCounts, InterMineObject feature) {
        String type = DynamicUtil.getSimpleClass((FastPathObject)feature).getSimpleName();
        Integer count = regionCounts.get(type);
        if (count == null) {
            count = new Integer(0);
            regionCounts.put(type, count);
        }
        regionCounts.put(type, new Integer(count + 1));
    }
}

