/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.export;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.intermine.api.results.ExportResultsIterator;
import org.intermine.bio.web.export.GFF3Exporter;
import org.intermine.bio.web.struts.GFF3ExportForm;
import org.intermine.metadata.StringUtil;
import org.intermine.model.bio.SequenceFeature;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.logic.export.ExportException;
import org.intermine.web.logic.export.ExportHelper;
import org.intermine.web.logic.export.ResponseUtil;
import org.intermine.web.logic.export.http.HttpExportUtil;
import org.intermine.web.logic.export.http.HttpExporterBase;
import org.intermine.web.logic.export.http.TableHttpExporter;
import org.intermine.web.logic.results.PagedTable;
import org.intermine.web.struts.TableExportForm;

public class GFF3HttpExporter
extends HttpExporterBase
implements TableHttpExporter {
    public static final int BIG_BATCH_SIZE = 10000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(PagedTable pt, HttpServletRequest request, HttpServletResponse response, TableExportForm form, Collection<Path> unionPathCollection, Collection<Path> newPathCollection) {
        block16: {
            boolean doGzip = form != null && form.getDoGzip();
            HttpSession session = request.getSession();
            ServletContext servletContext = session.getServletContext();
            Set<String> organisms = null;
            boolean makeUcscCompatible = false;
            if (form != null && form instanceof GFF3ExportForm) {
                organisms = ((GFF3ExportForm)form).getOrganisms();
                makeUcscCompatible = ((GFF3ExportForm)form).makeUcscCompatible();
            }
            if (doGzip) {
                ResponseUtil.setGzippedHeader((HttpServletResponse)response, (String)("table" + StringUtil.uniqueString() + ".gff3.gz"));
            } else {
                GFF3HttpExporter.setGFF3Header(response);
            }
            List indexes = ExportHelper.getClassIndexes((List)ExportHelper.getColumnClasses((PagedTable)pt), SequenceFeature.class);
            Properties props = (Properties)servletContext.getAttribute("WEB_PROPERTIES");
            String sourceName = props.getProperty("project.title");
            try {
                Object out = response.getOutputStream();
                if (doGzip) {
                    out = new GZIPOutputStream((OutputStream)out);
                }
                PrintWriter writer = HttpExportUtil.getPrintWriterForClient((HttpServletRequest)request, (OutputStream)out);
                LinkedList<String> paths = new LinkedList<String>();
                if (newPathCollection != null) {
                    for (Path path : newPathCollection) {
                        paths.add(path.toStringNoConstraints());
                    }
                } else {
                    PathQuery pq = pt.getPathQuery();
                    List views = pq.getView();
                    for (String view : views) {
                        paths.add(pq.makePath(view).toStringNoConstraints());
                    }
                }
                GFF3HttpExporter.removeFirstItemInPaths(paths);
                GFF3Exporter exporter = new GFF3Exporter(writer, indexes, GFF3HttpExporter.getSoClassNames(servletContext), paths, sourceName, organisms, makeUcscCompatible);
                ExportResultsIterator iter = null;
                try {
                    iter = this.getResultRows(pt, request);
                    iter.goFaster();
                    exporter.export((Iterator)iter, unionPathCollection, newPathCollection);
                    if (!(out instanceof GZIPOutputStream)) break block16;
                    try {
                        ((GZIPOutputStream)out).finish();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                finally {
                    if (iter != null) {
                        iter.releaseGoFaster();
                    }
                }
            }
            catch (Exception e) {
                throw new ExportException("Export failed", e);
            }
        }
    }

    private static void removeFirstItemInPaths(List<String> paths) {
        for (int i = 0; i < paths.size(); ++i) {
            String path = paths.get(i);
            paths.set(i, path.substring(path.indexOf(".") + 1, path.length()));
        }
    }

    private static void setGFF3Header(HttpServletResponse response) {
        ResponseUtil.setTabHeader((HttpServletResponse)response, (String)("table" + StringUtil.uniqueString() + ".gff3"));
    }

    public List<Path> getInitialExportPaths(PagedTable pt) {
        return ExportHelper.getColumnPaths((PagedTable)pt);
    }

    private static Map<String, String> getSoClassNames(ServletContext servletContext) throws ServletException {
        Properties soNameProperties;
        String soClassNames = "SO_CLASS_NAMES";
        if (servletContext.getAttribute("SO_CLASS_NAMES") == null) {
            soNameProperties = new Properties();
            try {
                InputStream is = servletContext.getResourceAsStream("/WEB-INF/soClassName.properties");
                soNameProperties.load(is);
            }
            catch (Exception e) {
                throw new ServletException("Error loading so class name mapping file", (Throwable)e);
            }
            servletContext.setAttribute("SO_CLASS_NAMES", (Object)soNameProperties);
        } else {
            soNameProperties = (Properties)servletContext.getAttribute("SO_CLASS_NAMES");
        }
        return new HashMap<Object, Object>(soNameProperties);
    }

    public boolean canExport(PagedTable pt) {
        return GFF3Exporter.canExportStatic(ExportHelper.getColumnClasses((PagedTable)pt));
    }

    public List<Path> getExportClassPaths(PagedTable pt) {
        return new ArrayList<Path>();
    }
}

