/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.logic;

import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.intermine.bio.web.model.GenomicRegion;
import org.intermine.bio.web.model.GenomicRegionSearchConstraint;

public class LiftOverService {
    private static final Logger LOG = Logger.getLogger(LiftOverService.class);
    private static final Map<String, String> ORGANISM_COMMON_NAME_MAP;

    public String doLiftOver(GenomicRegionSearchConstraint grsc, String org, String genomeVersionSource, String genomeVersionTarget, String liftOverServerURL) {
        String liftOverResponse;
        List<GenomicRegion> genomicRegionList = grsc.getGenomicRegionList();
        String coords = this.converToBED(genomicRegionList);
        String organism = ORGANISM_COMMON_NAME_MAP.get(org);
        try {
            String data = URLEncoder.encode("coords", "UTF-8") + "=" + URLEncoder.encode(coords, "UTF-8");
            data = data + "&" + URLEncoder.encode("source", "UTF-8") + "=" + URLEncoder.encode(genomeVersionSource, "UTF-8");
            data = data + "&" + URLEncoder.encode("target", "UTF-8") + "=" + URLEncoder.encode(genomeVersionTarget, "UTF-8");
            URL url = !liftOverServerURL.endsWith("/") ? new URL(liftOverServerURL + "/" + organism) : new URL(liftOverServerURL + organism);
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(data);
            wr.flush();
            wr.close();
            liftOverResponse = new String(IOUtils.toCharArray((InputStream)conn.getInputStream()));
            LOG.info((Object)("LiftOver response message: \n" + liftOverResponse));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return liftOverResponse;
    }

    private String converToBED(List<GenomicRegion> genomicRegionList) {
        StringBuffer coords = new StringBuffer();
        for (GenomicRegion gr : genomicRegionList) {
            coords.append(gr.getChr()).append("\t").append(gr.getStart()).append("\t").append(gr.getEnd()).append("\n");
        }
        return coords.toString();
    }

    static {
        HashMap<String, String> tempMap = new HashMap<String, String>();
        tempMap.put("H. sapiens", "human");
        tempMap.put("M. musculus", "mouse");
        tempMap.put("D. melanogaster", "fly");
        tempMap.put("C. elegans", "worm");
        ORGANISM_COMMON_NAME_MAP = Collections.unmodifiableMap(tempMap);
    }
}

