/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.logic;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionMessage;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.api.query.PathQueryExecutor;
import org.intermine.api.results.ExportResultsIterator;
import org.intermine.api.results.ResultElement;
import org.intermine.metadata.Model;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.pathquery.Constraints;
import org.intermine.pathquery.OrderDirection;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.logic.bag.BagConverter;
import org.intermine.web.logic.config.WebConfig;

public class OrthologueConverter
extends BagConverter {
    private Model model;

    public OrthologueConverter(InterMineAPI im, WebConfig webConfig) {
        super(im, webConfig);
        this.model = im.getModel();
    }

    private PathQuery constructPathQuery(String organismName) {
        PathQuery q = new PathQuery(this.model);
        if (StringUtils.isNotEmpty((String)organismName)) {
            q.addConstraint((PathConstraint)Constraints.eq((String)"Gene.homologues.homologue.organism.shortName", (String)organismName));
        }
        q.addConstraint((PathConstraint)Constraints.neq((String)"Gene.homologues.type", (String)"paralogue"));
        return q;
    }

    public List<Integer> getConvertedObjectIds(Profile profile, String bagType, List<Integer> bagList, String organismName) throws ObjectStoreException {
        PathQuery pathQuery = this.constructPathQuery(organismName);
        pathQuery.addConstraint((PathConstraint)Constraints.inIds((String)"Gene", bagList));
        pathQuery.addView("Gene.homologues.homologue.id");
        PathQueryExecutor executor = this.im.getPathQueryExecutor(profile);
        ExportResultsIterator it = executor.execute(pathQuery);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        while (it.hasNext()) {
            List row = it.next();
            ids.add((Integer)((ResultElement)row.get(0)).getField());
        }
        return ids;
    }

    public Map<String, String> getCounts(Profile profile, InterMineBag bag) throws ObjectStoreException {
        PathQuery pathQuery = this.constructPathQuery(null);
        pathQuery.addConstraint((PathConstraint)Constraints.inIds((String)"Gene", (Collection)bag.getContentsAsIds()));
        pathQuery.addView("Gene.homologues.homologue.organism.shortName");
        pathQuery.addView("Gene.homologues.homologue.id");
        pathQuery.addOrderBy("Gene.homologues.homologue.organism.shortName", OrderDirection.ASC);
        PathQueryExecutor executor = this.im.getPathQueryExecutor(profile);
        ExportResultsIterator it = executor.execute(pathQuery);
        LinkedHashMap<String, String> results = new LinkedHashMap<String, String>();
        while (it.hasNext()) {
            List row = it.next();
            String homologue = (String)((ResultElement)row.get(0)).getField();
            String count = (String)results.get(homologue);
            if (count == null) {
                count = "0";
            }
            int plusOne = Integer.parseInt(count);
            results.put(homologue, String.valueOf(++plusOne));
        }
        return results;
    }

    public ActionMessage getActionMessage(String externalids, int convertedSize, String type, String parameter) throws UnsupportedEncodingException {
        if (StringUtils.isEmpty((String)parameter)) {
            return null;
        }
        PathQuery q = new PathQuery(this.model);
        q.addViewSpaceSeparated("Gene.primaryIdentifier Gene.organism.shortName Gene.homologues.homologue.primaryIdentifier Gene.homologues.homologue.organism.shortName Gene.homologues.type Gene.homologues.dataSets.name");
        q.addConstraint((PathConstraint)Constraints.neq((String)"Gene.homologues.type", (String)"paralogue"));
        q.addConstraint((PathConstraint)Constraints.lookup((String)"Gene.organism", (String)parameter, (String)""));
        if (externalids.length() < 4000) {
            q.addConstraint((PathConstraint)Constraints.lookup((String)"Gene.homologues.homologue", (String)externalids, (String)""));
        }
        String query = q.toXml(2);
        String encodedurl = URLEncoder.encode(query, "UTF-8");
        Object[] values = new String[]{String.valueOf(convertedSize), parameter, String.valueOf(externalids.split(",").length), type, encodedurl};
        ActionMessage am = new ActionMessage("portal.orthologues", values);
        return am;
    }
}

