/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.web.struts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.actions.TilesAction;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.results.Column;
import org.intermine.bio.web.export.BEDHttpExporter;
import org.intermine.bio.web.logic.OrganismGenomeBuildLookup;
import org.intermine.bio.web.logic.SequenceFeatureExportUtil;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.Model;
import org.intermine.metadata.StringUtil;
import org.intermine.model.bio.Chromosome;
import org.intermine.model.bio.SequenceFeature;
import org.intermine.objectstore.ObjectStore;
import org.intermine.pathquery.Constraints;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathConstraintBag;
import org.intermine.pathquery.PathConstraintLookup;
import org.intermine.pathquery.PathQuery;
import org.intermine.pathquery.PathQueryBinding;
import org.intermine.template.SwitchOffAbility;
import org.intermine.template.TemplateQuery;
import org.intermine.util.DynamicUtil;
import org.intermine.web.logic.WebUtil;
import org.intermine.web.logic.results.PagedTable;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.util.URLGenerator;

public class GalaxyExportOptionsController
extends TilesAction {
    private static final Logger LOG = Logger.getLogger(GalaxyExportOptionsController.class);

    public ActionForward execute(ComponentContext context, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean canExportAsBED = false;
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)session);
        Model model = im.getModel();
        PathQuery query = new PathQuery(model);
        HashSet<String> orgSet = new HashSet<String>();
        Set genomeBuildSet = new HashSet();
        if (request.getParameter("featureIds") != null) {
            String featureIds = request.getParameter("featureIds").trim();
            String orgName = request.getParameter("orgName");
            if (orgName != null && !"".equals(orgName)) {
                orgSet.add(orgName);
            }
            String path = "SequenceFeature";
            query.addView(path + ".primaryIdentifier");
            query.addView(path + ".chromosomeLocation.locatedOn.primaryIdentifier");
            query.addView(path + ".chromosomeLocation.start");
            query.addView(path + ".chromosomeLocation.end");
            query.addView(path + ".organism.name");
            String[] stringArray = featureIds.split(",");
            HashSet<Integer> ids = new HashSet<Integer>();
            boolean isIds = true;
            for (String id : stringArray) {
                if (!Pattern.matches("^\\d+$", id = id.trim())) {
                    isIds = false;
                    break;
                }
                ids.add(Integer.valueOf(id));
            }
            if (isIds) {
                query.addConstraint((PathConstraint)Constraints.inIds((String)path, ids));
            } else {
                if (featureIds.contains("'")) {
                    featureIds = featureIds.replaceAll("'", "\\\\'");
                }
                query.addConstraint((PathConstraint)Constraints.lookup((String)path, (String)featureIds, null));
            }
            canExportAsBED = true;
        } else {
            String pathString;
            String tableName = request.getParameter("table");
            request.setAttribute("table", (Object)tableName);
            PagedTable pt = SessionMethods.getResultsTable((HttpSession)session, (String)tableName);
            if (pt == null) {
                LOG.error((Object)"Page table is NULL...");
                return null;
            }
            BEDHttpExporter tableExporter = new BEDHttpExporter();
            try {
                canExportAsBED = tableExporter.canExport(pt);
            }
            catch (Exception exception) {
                canExportAsBED = false;
                LOG.error((Object)("Caught an error running canExport() for: BEDHttpExporter. " + exception));
                exception.printStackTrace();
            }
            LinkedHashMap<Path, Integer> linkedHashMap = GalaxyExportOptionsController.getExportClassPaths(pt);
            ArrayList<Path> exportClassPaths = new ArrayList<Path>(linkedHashMap.keySet());
            LinkedHashMap<String, String> pathMap = new LinkedHashMap<String, String>();
            for (Path path : exportClassPaths) {
                pathString = path.toStringNoConstraints();
                String displayPath = pathString.replace(".", " &gt; ");
                pathMap.put(pathString, displayPath);
            }
            LinkedHashMap<String, Integer> pathIndexMap = new LinkedHashMap<String, Integer>();
            for (int index = 0; index < exportClassPaths.size(); ++index) {
                pathString = ((Path)exportClassPaths.get(index)).toStringNoConstraints();
                Integer idx = linkedHashMap.get(exportClassPaths.get(index));
                pathIndexMap.put(pathString, idx);
            }
            request.setAttribute("exportClassPaths", pathMap);
            request.setAttribute("pathIndexMap", pathIndexMap);
            query = pt.getWebTable().getPathQuery();
            ObjectStore os = im.getObjectStore();
            Map constrains = query.getConstraints();
            for (PathConstraint constraint : constrains.keySet()) {
                if (!(constraint instanceof PathConstraintBag)) continue;
                String bagName = ((PathConstraintBag)constraint).getBag();
                InterMineBag imBag = im.getBagManager().getBag(SessionMethods.getProfile((HttpSession)session), bagName);
                LinkedHashSet<String> classKeySet = new LinkedHashSet<String>();
                for (Integer id : imBag.getContentsAsIds()) {
                    String classKey = pt.findClassKeyValue((Map)im.getClassKeys(), os.getObjectById(id));
                    classKeySet.add(classKey);
                }
                String path = ((PathConstraintBag)constraint).getPath();
                PathConstraintLookup newConstraint = new PathConstraintLookup(path, ((Object)classKeySet).toString().substring(1, ((Object)classKeySet).toString().length() - 1), null);
                query.replaceConstraint(constraint, (PathConstraint)newConstraint);
            }
            orgSet = SequenceFeatureExportUtil.getOrganisms(query, session);
        }
        if (query instanceof TemplateQuery) {
            TemplateQuery templateQuery = (TemplateQuery)query;
            Map constraintSwitchOffAbilityMap = templateQuery.getConstraintSwitchOffAbility();
            for (Map.Entry entry : constraintSwitchOffAbilityMap.entrySet()) {
                if (((SwitchOffAbility)entry.getValue()).compareTo((Enum)SwitchOffAbility.OFF) != 0) continue;
                templateQuery.removeConstraint((PathConstraint)entry.getKey());
            }
        }
        String queryXML = PathQueryBinding.marshal((PathQuery)query, (String)"", (String)model.getName(), (int)2);
        String tableViewURL = new URLGenerator(request).getPermanentBaseURL() + "/service/query/results";
        request.setAttribute("tableURL", (Object)tableViewURL);
        request.setAttribute("queryXML", (Object)queryXML);
        request.setAttribute("size", (Object)1000000);
        request.setAttribute("canExportAsBED", (Object)canExportAsBED);
        if (canExportAsBED) {
            String bedURL = new URLGenerator(request).getPermanentBaseURL() + "/service/query/results/bed";
            request.setAttribute("bedURL", (Object)bedURL);
            genomeBuildSet = (Set)OrganismGenomeBuildLookup.getGenomeBuildByOrgansimCollection(orgSet);
            String string = orgSet.size() < 1 ? "Organism information not available" : StringUtil.join(orgSet, (String)",");
            genomeBuildSet.removeAll(Collections.singleton(null));
            String dbkey = genomeBuildSet.size() < 1 ? "Genome Build information not available" : StringUtil.join(genomeBuildSet, (String)",");
            request.setAttribute("org", (Object)string);
            request.setAttribute("dbkey", (Object)dbkey);
        }
        LinkedHashMap<String, String> pathsMap = new LinkedHashMap<String, String>();
        List list = query.getView();
        for (String view : list) {
            String title = query.getGeneratedPathDescription(view);
            title = WebUtil.formatColumnName((String)title);
            pathsMap.put(view, title);
        }
        request.setAttribute("pathsMap", pathsMap);
        return null;
    }

    public static LinkedHashMap<Path, Integer> getExportClassPaths(PagedTable pt) {
        LinkedHashMap<Path, Integer> retPaths = new LinkedHashMap<Path, Integer>();
        List columns = pt.getColumns();
        for (int index = 0; index < columns.size(); ++index) {
            Path prefix = ((Column)columns.get(index)).getPath().getPrefix();
            ClassDescriptor prefixCD = prefix.getLastClassDescriptor();
            Class prefixClass = DynamicUtil.getSimpleClass((Class)prefixCD.getType());
            if (!SequenceFeature.class.isAssignableFrom(prefixClass) || Chromosome.class.isAssignableFrom(prefixClass) || retPaths.keySet().contains(prefix)) continue;
            retPaths.put(prefix, index);
        }
        return retPaths;
    }
}

